/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.teiid.adminapi.AdminException;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.BufferManagerService;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.TransportService;

abstract class TeiidOperationHandler
extends BaseOperationHandler<DQPCore> {
    protected TeiidOperationHandler(String operationName) {
        super(operationName);
    }

    @Override
    protected DQPCore getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        ServiceController repo = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.ENGINE);
        if (repo != null) {
            return (DQPCore)DQPCore.class.cast(repo.getValue());
        }
        return null;
    }

    protected BufferManagerService getBufferManager(OperationContext context) {
        ServiceController repo = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.BUFFER_MGR);
        if (repo != null) {
            return (BufferManagerService)((Object)BufferManagerService.class.cast(repo.getService()));
        }
        return null;
    }

    protected VDBRepository getVDBrepository(OperationContext context) {
        ServiceController repo = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        if (repo != null) {
            return (VDBRepository)VDBRepository.class.cast(repo.getValue());
        }
        return null;
    }

    protected int getSessionCount(OperationContext context) throws AdminException {
        int count = 0;
        List<TransportService> transportServices = this.getTransportServices(context);
        for (TransportService t : transportServices) {
            count += t.getActiveSessionsCount();
        }
        return count;
    }

    protected List<TransportService> getTransportServices(OperationContext context) {
        ArrayList<TransportService> transports = new ArrayList<TransportService>();
        List services = context.getServiceRegistry(false).getServiceNames();
        for (ServiceName name : services) {
            ServiceController transport;
            if (!TeiidServiceNames.TRANSPORT_BASE.isParentOf(name) || (transport = context.getServiceRegistry(false).getService(name)) == null) continue;
            transports.add((TransportService)((Object)TransportService.class.cast(transport.getValue())));
        }
        return transports;
    }
}

