/*
 * Decompiled with CFR 0.152.
 */
package org.odata4j.stax2.staximpl;

import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import org.core4j.Enumerable;
import org.odata4j.core.Throwables;
import org.odata4j.stax2.QName2;
import org.odata4j.stax2.XMLWriter2;
import org.odata4j.stax2.staximpl.StaxXMLFactoryProvider2;

public class StaxXMLWriter2
implements XMLWriter2 {
    private final XMLEventFactory eventFactory;
    private final XMLEventWriter eventWriter;

    public StaxXMLWriter2(Writer stream) {
        XMLOutputFactory f = XMLOutputFactory.newInstance();
        try {
            this.eventFactory = XMLEventFactory.newInstance();
            this.eventWriter = f.createXMLEventWriter(stream);
            this.eventWriter.setDefaultNamespace("");
        }
        catch (XMLStreamException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void startElement(String name) {
        this.startElement(new QName2(name));
    }

    @Override
    public void startElement(QName2 qname) {
        this.startElement(qname, null);
    }

    @Override
    public void startElement(QName2 qname, String xmlns) {
        try {
            Iterator nsIterator = null;
            if (xmlns != null) {
                nsIterator = Enumerable.create((Object[])new Namespace[]{this.eventFactory.createNamespace(xmlns)}).iterator();
            }
            StartElement event = this.eventFactory.createStartElement(StaxXMLFactoryProvider2.toQName(qname), null, nsIterator);
            this.eventWriter.add(event);
        }
        catch (XMLStreamException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void writeAttribute(String localName, String value) {
        try {
            Attribute event = this.eventFactory.createAttribute(localName, value);
            this.eventWriter.add(event);
        }
        catch (XMLStreamException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void writeAttribute(QName2 qname, String value) {
        try {
            Attribute event = this.eventFactory.createAttribute(StaxXMLFactoryProvider2.toQName(qname), value);
            this.eventWriter.add(event);
        }
        catch (XMLStreamException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void writeText(String content) {
        try {
            Characters event = this.eventFactory.createCharacters(content);
            this.eventWriter.add(event);
        }
        catch (XMLStreamException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void writeNamespace(String prefix, String namespaceUri) {
        try {
            Namespace event = this.eventFactory.createNamespace(prefix, namespaceUri);
            this.eventWriter.add(event);
        }
        catch (XMLStreamException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void startDocument() {
        try {
            this.eventWriter.add(this.eventFactory.createStartDocument("utf-8", "1.0", true));
        }
        catch (XMLStreamException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void endElement(String localName) {
        try {
            EndElement event = this.eventFactory.createEndElement(new QName(localName), null);
            this.eventWriter.add(event);
        }
        catch (XMLStreamException e) {
            throw Throwables.propagate(e);
        }
    }

    @Override
    public void endDocument() {
        try {
            EndDocument event = this.eventFactory.createEndDocument();
            this.eventWriter.add(event);
            this.eventWriter.flush();
        }
        catch (XMLStreamException e) {
            throw Throwables.propagate(e);
        }
    }
}

