/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.operation.ParsedCommandLine;

public class FileSystemPathArgument
extends ArgumentWithValue {
    private final FilenameTabCompleter completer;

    public FileSystemPathArgument(CommandHandlerWithArguments handler, FilenameTabCompleter completer, int index, String name) {
        super(handler, (CommandLineCompleter)completer, index, name);
        this.completer = completer;
    }

    public FileSystemPathArgument(CommandHandlerWithArguments handler, FilenameTabCompleter completer, String name) {
        super(handler, completer, name);
        this.completer = completer;
    }

    @Override
    public String getValue(ParsedCommandLine args) {
        String value = super.getValue(args);
        if (value != null) {
            if (value.length() >= 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                value = value.substring(1, value.length() - 1);
            }
            if (this.completer != null) {
                value = this.completer.translatePath(value);
            }
        }
        return value;
    }
}

