/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.cli.impl.CLIModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClient;

public interface ModelControllerClientFactory {
    public static final String SASL_DISALLOWED_MECHANISMS = "SASL_DISALLOWED_MECHANISMS";
    public static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    public static final Map<String, String> DISABLED_LOCAL_AUTH = Collections.singletonMap("SASL_DISALLOWED_MECHANISMS", "JBOSS-LOCAL-USER");
    public static final Map<String, String> ENABLED_LOCAL_AUTH = Collections.emptyMap();
    public static final ModelControllerClientFactory DEFAULT = new ModelControllerClientFactory(){

        @Override
        public ModelControllerClient getClient(String hostName, int port, CallbackHandler handler, boolean disableLocalAuth, SSLContext sslContext, int connectionTimeout, ConnectionCloseHandler closeHandler) throws IOException {
            Map saslOptions = disableLocalAuth ? DISABLED_LOCAL_AUTH : ENABLED_LOCAL_AUTH;
            return ModelControllerClient.Factory.create((String)hostName, (int)port, (CallbackHandler)handler, (SSLContext)sslContext, (int)connectionTimeout, (Map)saslOptions);
        }
    };
    public static final ModelControllerClientFactory CUSTOM = new ModelControllerClientFactory(){

        @Override
        public ModelControllerClient getClient(String hostName, int port, CallbackHandler handler, boolean disableLocalAuth, SSLContext sslContext, int connectionTimeout, ConnectionCloseHandler closeHandler) throws IOException {
            Map saslOptions = disableLocalAuth ? DISABLED_LOCAL_AUTH : ENABLED_LOCAL_AUTH;
            return new CLIModelControllerClient(handler, hostName, connectionTimeout, closeHandler, port, saslOptions, sslContext);
        }
    };

    public ModelControllerClient getClient(String var1, int var2, CallbackHandler var3, boolean var4, SSLContext var5, int var6, ConnectionCloseHandler var7) throws IOException;

    public static interface ConnectionCloseHandler {
        public void handleClose();
    }
}

