/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.salesforce;

import com.sforce.soap.partner.SforceService;
import java.net.MalformedURLException;
import java.net.URL;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.resource.adapter.salesforce.SalesforceConnectionImpl;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;
import org.teiid.resource.spi.ConnectionContext;

public class SalesForceManagedConnectionFactory
extends BasicManagedConnectionFactory {
    private static final long serialVersionUID = 5298591275313314698L;
    private String username;
    private String password;
    private URL URL;
    private String configFile;
    private Long requestTimeout;
    private Long connectTimeout;
    private Bus bus;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        if (username.trim().length() == 0) {
            throw new TeiidRuntimeException("Name can not be null");
        }
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public URL getAsURL() {
        return this.URL;
    }

    public String getURL() {
        return this.URL.toExternalForm();
    }

    public void setURL(String uRL) {
        try {
            this.URL = new URL(uRL);
        }
        catch (MalformedURLException e) {
            throw new TeiidRuntimeException("URL Supplied is not valid URL" + e.getMessage());
        }
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String config) {
        this.configFile = config;
    }

    public Long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public BasicConnectionFactory<SalesforceConnectionImpl> createConnectionFactory() throws ResourceException {
        QName portQName = SforceService.SERVICE;
        if (this.configFile != null) {
            this.bus = new SpringBusFactory().createBus(this.configFile);
            JaxWsClientFactoryBean instance = new JaxWsClientFactoryBean();
            Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
            if (null != configurer) {
                configurer.configureBean(portQName.toString() + ".jaxws-client.proxyFactory", (Object)instance);
            }
        }
        return new BasicConnectionFactory<SalesforceConnectionImpl>(){
            private static final long serialVersionUID = 5028356110047329135L;

            public SalesforceConnectionImpl getConnection() throws ResourceException {
                String userName = SalesForceManagedConnectionFactory.this.getUsername();
                String password = SalesForceManagedConnectionFactory.this.getPassword();
                Subject subject = ConnectionContext.getSubject();
                if (subject != null) {
                    userName = ConnectionContext.getUserName((Subject)subject, (BasicManagedConnectionFactory)SalesForceManagedConnectionFactory.this, (String)userName);
                    password = ConnectionContext.getPassword((Subject)subject, (BasicManagedConnectionFactory)SalesForceManagedConnectionFactory.this, (String)userName, (String)password);
                }
                return new SalesforceConnectionImpl(userName, password, SalesForceManagedConnectionFactory.this.getAsURL(), SalesForceManagedConnectionFactory.this);
            }
        };
    }

    public Bus getBus() {
        return this.bus;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.URL == null ? 0 : this.URL.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.configFile == null ? 0 : this.configFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SalesForceManagedConnectionFactory other = (SalesForceManagedConnectionFactory)((Object)obj);
        if (!SalesForceManagedConnectionFactory.checkEquals((Object)this.URL, (Object)other.URL)) {
            return false;
        }
        if (!SalesForceManagedConnectionFactory.checkEquals((Object)this.password, (Object)other.password)) {
            return false;
        }
        if (!SalesForceManagedConnectionFactory.checkEquals((Object)this.username, (Object)other.username)) {
            return false;
        }
        return SalesForceManagedConnectionFactory.checkEquals((Object)this.configFile, (Object)other.configFile);
    }
}

