/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.util.ExternalizeUtil;
import org.teiid.core.util.HashCodeUtil;

public final class ArrayImpl
implements Comparable<ArrayImpl>,
Externalizable,
Array {
    private static final String INVALID = "";
    private static final long serialVersionUID = 517794153664734815L;
    private boolean zeroBased;
    private Object[] values;
    private static final NullException ex = new NullException();

    public ArrayImpl(Object[] values) {
        this.values = values;
    }

    public ArrayImpl() {
    }

    private void checkValues() throws SQLException {
        if (this.values == null) {
            throw new SQLException("Already freed or invalid");
        }
    }

    @Override
    public int compareTo(ArrayImpl o) {
        return this.compareTo(o, false, null);
    }

    public int compareTo(ArrayImpl o, boolean noNulls, Comparator<Object> comparator) {
        if (this.zeroBased != o.zeroBased) {
            throw new TeiidRuntimeException("Incompatible types");
        }
        try {
            this.checkValues();
            o.checkValues();
        }
        catch (SQLException e) {
            throw new TeiidRuntimeException(e);
        }
        int len1 = this.values.length;
        int len2 = o.values.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            Object object1 = this.values[k];
            Object object2 = o.values[k];
            if (object1 == null) {
                if (noNulls) {
                    throw ex;
                }
                if (object2 == null) continue;
                return -1;
            }
            if (object2 == null) {
                if (noNulls) {
                    throw ex;
                }
                return 1;
            }
            int comp = 0;
            comp = comparator != null ? comparator.compare(object1, object2) : ((Comparable)object1).compareTo(object2);
            if (comp == 0) continue;
            return comp;
        }
        return len1 - len2;
    }

    public int hashCode() {
        return HashCodeUtil.expHashCode(0, this.values);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArrayImpl)) {
            return false;
        }
        ArrayImpl other = (ArrayImpl)obj;
        return this.zeroBased == other.zeroBased && Arrays.equals(this.values, other.values);
    }

    public Object[] getValues() {
        if (this.values == null) {
            throw new TeiidRuntimeException("Already freed or invalid");
        }
        return this.values;
    }

    public String toString() {
        return Arrays.toString(this.values);
    }

    public boolean isZeroBased() {
        return this.zeroBased;
    }

    public void setZeroBased(boolean zeroBased) {
        this.zeroBased = zeroBased;
    }

    @Override
    public void free() throws SQLException {
        this.values = null;
    }

    @Override
    public Object getArray() throws SQLException {
        this.checkValues();
        return this.values;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        if (index > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index));
        }
        int offset = this.zeroBased ? 0 : 1;
        int iIndex = (int)index - offset;
        if (iIndex >= this.values.length || iIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(iIndex);
        }
        this.checkValues();
        return Arrays.copyOfRange(this.values, iIndex, Math.min(iIndex + count, this.values.length));
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getBaseType() throws SQLException {
        this.checkValues();
        return JDBCSQLTypeInfo.getSQLType(DataTypeManager.getDataTypeName(this.values.getClass().getComponentType()));
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        this.checkValues();
        return DataTypeManager.getDataTypeName(this.values.getClass().getComponentType());
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String componentType = in.readUTF();
        if (INVALID.equalsIgnoreCase(componentType)) {
            return;
        }
        this.values = ExternalizeUtil.readArray(in, DataTypeManager.getDataTypeClass(componentType));
        this.zeroBased = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.values == null) {
            out.writeUTF(INVALID);
            return;
        }
        out.writeUTF(DataTypeManager.getDataTypeName(this.values.getClass().getComponentType()));
        ExternalizeUtil.writeArray(out, this.values);
        out.writeBoolean(this.zeroBased);
    }

    public static final class NullException
    extends RuntimeException {
    }
}

