/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import org.teiid.dqp.internal.process.multisource.MultiSourceMetadataWrapper;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class MultiSourceMetadataRepository
extends MetadataRepository<Object, Object> {
    private String multiSourceColumnName;

    public MultiSourceMetadataRepository(String multiSourceColumnName) {
        this.multiSourceColumnName = multiSourceColumnName;
    }

    public void loadMetadata(MetadataFactory factory, ExecutionFactory<Object, Object> executionFactory, Object connectionFactory) throws TranslatorException {
        Schema s = factory.getSchema();
        for (Table t : s.getTables().values()) {
            Column c;
            if (!t.isPhysical() || (c = t.getColumnByName(this.multiSourceColumnName)) != null) continue;
            c = factory.addColumn(this.multiSourceColumnName, "string", (ColumnSet)t);
            MultiSourceMetadataWrapper.setMultiSourceElementMetadata((Column)c);
        }
        block1: for (Procedure p : s.getProcedures().values()) {
            if (p.isVirtual()) continue;
            for (ProcedureParameter pp : p.getParameters()) {
                if (!this.multiSourceColumnName.equalsIgnoreCase(pp.getName())) continue;
                continue block1;
            }
            ProcedureParameter pp = factory.addProcedureParameter(this.multiSourceColumnName, "string", ProcedureParameter.Type.In, p);
            pp.setNullType(BaseColumn.NullType.Nullable);
        }
    }
}

