/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.infinispan.base;

import java.util.Map;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.infinispan.base.AbstractInfinispanManagedConnectionFactory;
import org.teiid.resource.adapter.infinispan.base.InfinispanPlugin;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.object.CacheContainerWrapper;
import org.teiid.translator.object.ObjectConnection;

public class InfinispanConnectionImpl
extends BasicConnection
implements ObjectConnection {
    private AbstractInfinispanManagedConnectionFactory config;

    public InfinispanConnectionImpl(AbstractInfinispanManagedConnectionFactory config) {
        this.config = config;
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Infinispan Connection has been newly created."});
    }

    @Override
    public CacheContainerWrapper getCacheContainer() throws TranslatorException {
        return this.config.getCacheContainer();
    }

    public void close() {
        this.config = null;
    }

    public boolean isAlive() {
        boolean alive = this.config == null ? false : this.config.isAlive();
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Infinispan Cache Connection is alive:", alive});
        return alive;
    }

    @Override
    public Class<?> getType(String cacheName) throws TranslatorException {
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"=== GetType for cache :", cacheName, "==="});
        Class<?> type = this.config.getCacheType(cacheName);
        if (type != null) {
            return type;
        }
        String msg = InfinispanPlugin.Util.getString("InfinispanConnection.typeNotFound", new Object[]{cacheName != null ? cacheName : "Default"});
        throw new TranslatorException(msg);
    }

    @Override
    public String getPkField(String cacheName) {
        return this.config.getPkMap(cacheName);
    }

    @Override
    public Map<String, Class<?>> getCacheNameClassTypeMapping() {
        return this.config.getCacheNameClassTypeMapping();
    }
}

