/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.logging.LogManager;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.JDBCBaseExecution;
import org.teiid.translator.jdbc.JDBCExecutionException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCPlugin;
import org.teiid.translator.jdbc.TranslatedCommand;

public class JDBCQueryExecution
extends JDBCBaseExecution
implements ResultSetExecution {
    protected ResultSet results;
    protected Class<?>[] columnDataTypes;

    public JDBCQueryExecution(Command command, Connection connection, ExecutionContext context, JDBCExecutionFactory env) {
        super(command, connection, context, env);
    }

    public void execute() throws TranslatorException {
        this.columnDataTypes = ((QueryExpression)this.command).getColumnTypes();
        TranslatedCommand translatedComm = this.translateCommand(this.command);
        String sql = translatedComm.getSql();
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Source sql", sql});
        try {
            if (!translatedComm.isPrepared()) {
                this.results = this.getStatement().executeQuery(sql);
            } else {
                PreparedStatement pstatement = this.getPreparedStatement(sql);
                this.bind(pstatement, translatedComm.getPreparedValues(), null);
                this.results = pstatement.executeQuery();
            }
            this.addStatementWarnings();
        }
        catch (SQLException e) {
            throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11008, e, translatedComm);
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        try {
            if (this.results.next()) {
                ArrayList<Object> vals = new ArrayList<Object>(this.columnDataTypes.length);
                for (int i = 0; i < this.columnDataTypes.length; ++i) {
                    Object value = this.executionFactory.retrieveValue(this.results, i + 1, this.columnDataTypes[i]);
                    vals.add(value);
                }
                return vals;
            }
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e, JDBCPlugin.Util.getString("JDBCTranslator.Unexpected_exception_translating_results___8", new Object[]{e.getMessage()}));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.results != null) {
                try {
                    this.results.close();
                    this.results = null;
                }
                catch (SQLException e) {
                    LogManager.logDetail((String)"org.teiid.CONNECTOR", (Throwable)e, (Object[])new Object[]{"Exception closing"});
                }
            }
        }
        finally {
            super.close();
        }
    }
}

