/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.modeshape;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Comparison;
import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.Not;
import org.teiid.logging.LogManager;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.modeshape.IdentifierFunctionModifier;

@Translator(name="modeshape", description="A translator for the open source Modeshape JCR Repository")
public class ModeShapeExecutionFactory
extends JDBCExecutionFactory {
    private static final String JCR = "JCR";
    private static final String JCR_REFERENCE = "JCR_REFERENCE";
    private static final String JCR_CONTAINS = "JCR_CONTAINS";
    private static final String JCR_ISSAMENODE = "JCR_ISSAMENODE";
    private static final String JCR_ISDESCENDANTNODE = "JCR_ISDESCENDANTNODE";
    private static final String JCR_ISCHILDNODE = "JCR_ISCHILDNODE";

    public ModeShapeExecutionFactory() {
        this.setUseBindVariables(false);
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("ucase", new AliasModifier("UpperCase"));
        this.registerFunctionModifier("lcase", new AliasModifier("LowerCase"));
        this.registerFunctionModifier(JCR_ISCHILDNODE, new IdentifierFunctionModifier());
        this.registerFunctionModifier(JCR_ISDESCENDANTNODE, new IdentifierFunctionModifier());
        this.registerFunctionModifier(JCR_ISSAMENODE, new IdentifierFunctionModifier());
        this.registerFunctionModifier(JCR_REFERENCE, new IdentifierFunctionModifier());
        this.registerFunctionModifier(JCR_CONTAINS, new IdentifierFunctionModifier());
        this.addPushDownFunction(JCR, JCR_ISCHILDNODE, "boolean", new String[]{"string", "string"});
        this.addPushDownFunction(JCR, JCR_ISDESCENDANTNODE, "boolean", new String[]{"string", "string"});
        this.addPushDownFunction(JCR, JCR_ISSAMENODE, "boolean", new String[]{"string", "string"});
        this.addPushDownFunction(JCR, JCR_CONTAINS, "boolean", new String[]{"string", "string"});
        this.addPushDownFunction(JCR, JCR_REFERENCE, "boolean", new String[]{"string"});
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"ModeShape Translator Started"});
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "CAST('" + this.formatDateValue(dateValue) + "' AS DATE)";
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "CAST('" + this.formatDateValue(timeValue) + "' AS DATE)";
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "CAST('" + this.formatDateValue(timestampValue) + "' AS DATE)";
    }

    @Override
    public String translateLiteralBoolean(Boolean booleanValue) {
        return "CAST('" + booleanValue.toString() + "' AS BOOLEAN)";
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ucase");
        supportedFunctions.add("lcase");
        supportedFunctions.add("length");
        return supportedFunctions;
    }

    @Override
    public List<?> translate(LanguageObject obj, ExecutionContext context) {
        if (obj instanceof Comparison) {
            Comparison compare = (Comparison)obj;
            if (compare.getLeftExpression().getType() == TypeFacility.RUNTIME_TYPES.BOOLEAN && compare.getLeftExpression() instanceof Function && compare.getRightExpression() instanceof Literal) {
                boolean isTrue = Boolean.TRUE.equals(((Literal)compare.getRightExpression()).getValue());
                if (isTrue && compare.getOperator() == Comparison.Operator.EQ || !isTrue && compare.getOperator() == Comparison.Operator.NE) {
                    return Arrays.asList(compare.getLeftExpression());
                }
                if (!isTrue && compare.getOperator() == Comparison.Operator.EQ || isTrue && compare.getOperator() == Comparison.Operator.NE) {
                    return Arrays.asList("NOT ", compare.getLeftExpression());
                }
            }
        } else if (obj instanceof Not) {
            Not not = (Not)obj;
            return Arrays.asList("NOT ", not.getCriteria());
        }
        return super.translate(obj, context);
    }

    @Override
    public boolean useBindVariables() {
        return false;
    }

    @Override
    public boolean supportsAggregatesAvg() {
        return false;
    }

    @Override
    public boolean supportsAggregatesCountStar() {
        return false;
    }

    @Override
    public boolean supportsAggregatesCount() {
        return false;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return false;
    }

    @Override
    public boolean supportsAggregatesMax() {
        return false;
    }

    @Override
    public boolean supportsAggregatesMin() {
        return false;
    }

    @Override
    public boolean supportsAggregatesSum() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return false;
    }

    @Override
    public boolean supportsHaving() {
        return false;
    }

    @Override
    public boolean supportsSelectExpression() {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsExistsCriteria() {
        return false;
    }

    @Override
    public boolean supportsInCriteriaSubquery() {
        return false;
    }

    @Override
    public boolean supportsInlineViews() {
        return false;
    }

    public boolean supportsOrderByNullOrdering() {
        return false;
    }

    @Override
    public boolean supportsQuantifiedCompareCriteriaAll() {
        return false;
    }

    @Override
    public boolean supportsQuantifiedCompareCriteriaSome() {
        return false;
    }

    @Override
    public boolean supportsScalarSubqueries() {
        return false;
    }

    @Override
    public boolean supportsSearchedCaseExpressions() {
        return false;
    }

    public boolean supportsExcept() {
        return true;
    }

    public boolean supportsIntersect() {
        return true;
    }

    @Override
    public boolean supportsSetQueryOrderBy() {
        return false;
    }
}

