/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.oracle;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.core.util.StringUtil;
import org.teiid.translator.jdbc.ParseFormatFunctionModifier;

public final class OracleFormatFunctionModifier
extends ParseFormatFunctionModifier {
    public static final Pattern tokenPattern = Pattern.compile("(G|y{1,4}|M{1,4}|D{1,3}|d{1,2}|E{1,4}|a{1,2}|H{1,2}|h{1,2}|m{1,2}|s{1,2}|S{1,3}|Z|[\\- /,.;:]+|(?:'[^'\"]*')+|[^'\"a-zA-Z]+)");

    public OracleFormatFunctionModifier(String prefix) {
        super(prefix);
    }

    public static boolean supportsLiteral(String literal) {
        Matcher m = tokenPattern.matcher(literal);
        int end = 0;
        while (m.find()) {
            if (end != m.start()) {
                return false;
            }
            end = m.end();
        }
        return end == literal.length();
    }

    @Override
    protected Object translateFormat(String format) {
        Matcher m = tokenPattern.matcher(format);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            if (m.group().length() == 0) continue;
            String group = m.group();
            sb.append(this.convertToken(group));
        }
        return sb.toString();
    }

    private Object convertToken(String group) {
        switch (group.charAt(0)) {
            case 'G': {
                return "AD";
            }
            case 'y': {
                if (group.length() == 4) {
                    return "YYYY";
                }
                return "YY";
            }
            case 'M': {
                if (group.length() <= 2) {
                    return "MM";
                }
                if (group.length() == 3) {
                    return "Mon";
                }
                return "Month";
            }
            case 'D': {
                return "DDD";
            }
            case 'd': {
                return "DD";
            }
            case 'E': {
                if (group.length() == 4) {
                    return "Day";
                }
                return "Dy";
            }
            case 'a': {
                return "PM";
            }
            case 'H': {
                return "HH24";
            }
            case 'h': {
                return "HH";
            }
            case 'm': {
                return "MI";
            }
            case 's': {
                return "SS";
            }
            case 'S': {
                return "FF" + group.length();
            }
            case 'Z': {
                return "TZHTZM";
            }
            case '\'': {
                return '\"' + StringUtil.replace((String)group.substring(1, group.length() - 1), (String)"''", (String)"'") + '\"';
            }
            case ' ': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': {
                return group;
            }
        }
        return '\"' + group + '\"';
    }
}

