/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.odata4j.core.ODataConstants;
import org.odata4j.core.ODataVersion;
import org.odata4j.core.OEntity;
import org.odata4j.core.OError;
import org.odata4j.core.OProperty;
import org.odata4j.edm.EdmComplexType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmStructuralType;
import org.odata4j.format.Entry;
import org.odata4j.format.Feed;
import org.odata4j.format.FormatParser;
import org.odata4j.format.FormatParserFactory;
import org.odata4j.format.FormatType;
import org.odata4j.format.Settings;
import org.odata4j.format.xml.AtomFeedFormatParser;
import org.odata4j.stax2.StartElement2;
import org.odata4j.stax2.XMLEvent2;
import org.odata4j.stax2.XMLEventReader2;
import org.odata4j.stax2.util.StaxUtil;
import org.teiid.core.BundleUtil;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Literal;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.WSConnection;
import org.teiid.translator.odata.AtomErrorFormatParser;
import org.teiid.translator.odata.ODataExecutionFactory;
import org.teiid.translator.odata.ODataPlugin;
import org.teiid.translator.ws.BinaryWSProcedureExecution;

public class BaseQueryExecution {
    protected WSConnection connection;
    protected ODataExecutionFactory translator;
    protected RuntimeMetadata metadata;
    protected ExecutionContext executionContext;

    public BaseQueryExecution(ODataExecutionFactory translator, ExecutionContext executionContext, RuntimeMetadata metadata, WSConnection connection) {
        this.metadata = metadata;
        this.executionContext = executionContext;
        this.translator = translator;
        this.connection = connection;
    }

    protected Feed parse(Blob blob, ODataVersion version, String entityTable, EdmDataServices edsMetadata) throws TranslatorException {
        try {
            FormatParser parser = FormatParserFactory.getParser(Feed.class, (FormatType)FormatType.ATOM, (Settings)new Settings(version, edsMetadata, entityTable, null));
            return (Feed)parser.parse((Reader)new InputStreamReader(blob.getBinaryStream()));
        }
        catch (SQLException e) {
            throw new TranslatorException((BundleUtil.Event)ODataPlugin.Event.TEIID17010, (Throwable)e, e.getMessage());
        }
    }

    protected static ODataVersion getDataServiceVersion(String headerValue) {
        ODataVersion version = ODataConstants.DATA_SERVICE_VERSION;
        if (headerValue != null) {
            String[] str = headerValue.split(";");
            version = ODataVersion.parse((String)str[0]);
        }
        return version;
    }

    protected ODataEntitiesResponse executeWithReturnEntity(String method, String uri, String payload, String entityTable, EdmDataServices edsMetadata, String eTag, Response.Status ... expectedStatus) throws TranslatorException {
        Map<String, List<String>> headers = this.getDefaultHeaders();
        if (eTag != null) {
            headers.put("If-Match", Arrays.asList(eTag));
        }
        if (payload != null) {
            headers.put("Content-Type", Arrays.asList("application/atom+xml"));
        }
        BinaryWSProcedureExecution execution = this.executeDirect(method, uri, payload, headers);
        for (Response.Status status : expectedStatus) {
            if (status.getStatusCode() != execution.getResponseCode()) continue;
            if (execution.getResponseCode() != Response.Status.NO_CONTENT.getStatusCode() && execution.getResponseCode() != Response.Status.NOT_FOUND.getStatusCode()) {
                Blob blob = (Blob)execution.getOutputParameterValues().get(0);
                ODataVersion version = this.getODataVersion(execution);
                Feed feed = this.parse(blob, version, entityTable, edsMetadata);
                return new ODataEntitiesResponse(uri, feed, entityTable, edsMetadata, new Response.Status[0]);
            }
            return new ODataEntitiesResponse();
        }
        return new ODataEntitiesResponse(this.buildError(execution));
    }

    ODataVersion getODataVersion(BinaryWSProcedureExecution execution) {
        return BaseQueryExecution.getDataServiceVersion(this.getHeader(execution, "DataServiceVersion"));
    }

    String getHeader(BinaryWSProcedureExecution execution, String header) {
        Object value = execution.getResponseHeader(header);
        if (value instanceof List) {
            return (String)((List)value).get(0);
        }
        return (String)value;
    }

    protected ODataEntitiesResponse executeWithComplexReturn(String method, String uri, String payload, String complexTypeName, EdmDataServices edsMetadata, String eTag, Response.Status ... expectedStatus) throws TranslatorException {
        Map<String, List<String>> headers = this.getDefaultHeaders();
        if (eTag != null) {
            headers.put("If-Match", Arrays.asList(eTag));
        }
        if (payload != null) {
            headers.put("Content-Type", Arrays.asList("application/atom+xml"));
        }
        BinaryWSProcedureExecution execution = this.executeDirect(method, uri, payload, headers);
        for (Response.Status status : expectedStatus) {
            if (status.getStatusCode() != execution.getResponseCode()) continue;
            if (execution.getResponseCode() != Response.Status.NO_CONTENT.getStatusCode()) {
                Blob blob = (Blob)execution.getOutputParameterValues().get(0);
                EdmComplexType complexType = edsMetadata.findEdmComplexType(complexTypeName);
                if (complexType == null) {
                    throw new RuntimeException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17016, new Object[]{complexType}));
                }
                try {
                    return this.parserComplex(StaxUtil.newXMLEventReader((Reader)new InputStreamReader(blob.getBinaryStream())), complexType, edsMetadata);
                }
                catch (SQLException e) {
                    throw new TranslatorException((BundleUtil.Event)ODataPlugin.Event.TEIID17010, (Throwable)e, e.getMessage());
                }
            }
            return new ODataEntitiesResponse();
        }
        return new ODataEntitiesResponse(this.buildError(execution));
    }

    private ODataEntitiesResponse parserComplex(XMLEventReader2 reader, EdmComplexType complexType, EdmDataServices edsMetadata) {
        XMLEvent2 event = reader.nextEvent();
        while (!event.isStartElement()) {
            event = reader.nextEvent();
        }
        return new ODataEntitiesResponse(AtomFeedFormatParser.parseProperties((XMLEventReader2)reader, (StartElement2)event.asStartElement(), (EdmDataServices)edsMetadata, (EdmStructuralType)complexType).iterator());
    }

    protected TranslatorException buildError(BinaryWSProcedureExecution execution) {
        try {
            Blob blob = (Blob)execution.getOutputParameterValues().get(0);
            AtomErrorFormatParser parser = new AtomErrorFormatParser();
            OError error = (OError)parser.parse(new InputStreamReader(blob.getBinaryStream(), Charset.forName("UTF-8")));
            return new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17013, new Object[]{execution.getResponseCode(), error.getCode(), error.getMessage(), error.getInnerError()}));
        }
        catch (Throwable t) {
            return new TranslatorException(t);
        }
    }

    protected BinaryWSProcedureExecution executeDirect(String method, String uri, String payload, Map<String, List<String>> headers) throws TranslatorException {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.ODATA", (int)5)) {
            try {
                LogManager.logDetail((String)"org.teiid.ODATA", (Object[])new Object[]{"Source-URL=", URLDecoder.decode(uri, "UTF-8")});
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        ArrayList<Argument> parameters = new ArrayList<Argument>();
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)method, TypeFacility.RUNTIME_TYPES.STRING), null));
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)payload, TypeFacility.RUNTIME_TYPES.STRING), null));
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)uri, TypeFacility.RUNTIME_TYPES.STRING), null));
        parameters.add(new Argument(Argument.Direction.IN, new Literal((Object)true, TypeFacility.RUNTIME_TYPES.BOOLEAN), null));
        parameters.add(new Argument(Argument.Direction.OUT, TypeFacility.RUNTIME_TYPES.STRING, null));
        Call call = this.translator.getLanguageFactory().createCall("invokeHttp", parameters, null);
        BinaryWSProcedureExecution execution = new BinaryWSProcedureExecution(call, this.metadata, this.executionContext, null, this.connection);
        execution.setUseResponseContext(true);
        execution.setAlwaysAllowPayloads(true);
        for (String header : headers.keySet()) {
            execution.addHeader(header, headers.get(header));
        }
        execution.execute();
        return execution;
    }

    protected Map<String, List<String>> getDefaultHeaders() {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Accept", Arrays.asList(FormatType.ATOM.getAcceptableMediaTypes()));
        headers.put("Content-Type", Arrays.asList("application/xml"));
        return headers;
    }

    class ODataEntitiesResponse {
        private Feed feed;
        private String uri;
        private Iterator<Entry> rowIter;
        private String entityTypeName;
        private TranslatorException exception;
        private Response.Status[] acceptedStatus;
        private Iterator<OProperty<?>> complexValues;
        private EdmDataServices edsMetadata;

        public ODataEntitiesResponse(String uri, Feed feed, String entityTypeName, EdmDataServices edsMetadata, Response.Status ... accptedStatus) {
            this.uri = uri;
            this.feed = feed;
            this.entityTypeName = entityTypeName;
            this.rowIter = this.feed.getEntries().iterator();
            this.acceptedStatus = accptedStatus;
            this.edsMetadata = edsMetadata;
        }

        public ODataEntitiesResponse(TranslatorException ex) {
            this.exception = ex;
        }

        public ODataEntitiesResponse() {
        }

        public ODataEntitiesResponse(Iterator<OProperty<?>> complexValues) {
            this.complexValues = complexValues;
        }

        public boolean hasRow() {
            return this.rowIter != null && this.rowIter.hasNext();
        }

        public boolean hasError() {
            return this.exception != null;
        }

        public TranslatorException getError() {
            return this.exception;
        }

        public List<?> getNextRow(Column[] columns, Class<?>[] expectedType) throws TranslatorException {
            if (this.rowIter != null && this.rowIter.hasNext()) {
                OEntity entity = this.rowIter.next().getEntity();
                ArrayList<Object> results = new ArrayList<Object>();
                for (int i = 0; i < columns.length; ++i) {
                    boolean isComplex = true;
                    String colName = columns[i].getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}ColumnGroup", false);
                    if (colName == null) {
                        colName = columns[i].getName();
                        isComplex = false;
                    }
                    Object value = entity.getProperty(colName).getValue();
                    if (isComplex) {
                        List embeddedProperties = (List)value;
                        for (OProperty prop : embeddedProperties) {
                            if (!prop.getName().equals(columns[i].getNameInSource())) continue;
                            value = prop.getValue();
                            break;
                        }
                    }
                    results.add(BaseQueryExecution.this.translator.retrieveValue(value, expectedType[i]));
                }
                this.fetchNextBatch(!this.rowIter.hasNext(), this.edsMetadata);
                return results;
            }
            if (this.complexValues != null) {
                HashMap<String, Object> values = new HashMap<String, Object>();
                while (this.complexValues.hasNext()) {
                    OProperty<?> prop = this.complexValues.next();
                    values.put(prop.getName(), prop.getValue());
                }
                ArrayList<Object> results = new ArrayList<Object>();
                for (int i = 0; i < columns.length; ++i) {
                    results.add(BaseQueryExecution.this.translator.retrieveValue(values.get(columns[i].getName()), expectedType[i]));
                }
                this.complexValues = null;
                return results;
            }
            return null;
        }

        private void fetchNextBatch(boolean fetch, EdmDataServices edsMetadata) throws TranslatorException {
            if (!fetch) {
                return;
            }
            String next = this.feed.getNext();
            if (next == null) {
                this.feed = null;
                this.rowIter = null;
                return;
            }
            int idx = next.indexOf("$skiptoken=");
            if (idx != -1) {
                String skip = null;
                try {
                    skip = next.substring(idx + 11);
                    skip = URLDecoder.decode(skip, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new TranslatorException((Throwable)e);
                }
                String nextUri = this.uri;
                nextUri = this.uri.indexOf(63) == -1 ? this.uri + "?$skiptoken=" + skip : this.uri + "&$skiptoken=" + skip;
                BinaryWSProcedureExecution execution = BaseQueryExecution.this.executeDirect("GET", nextUri, null, BaseQueryExecution.this.getDefaultHeaders());
                this.validateResponse(execution);
                Blob blob = (Blob)execution.getOutputParameterValues().get(0);
                ODataVersion version = BaseQueryExecution.this.getODataVersion(execution);
                this.feed = BaseQueryExecution.this.parse(blob, version, this.entityTypeName, edsMetadata);
                this.rowIter = this.feed.getEntries().iterator();
            } else if (next.toLowerCase().startsWith("http")) {
                BinaryWSProcedureExecution execution = BaseQueryExecution.this.executeDirect("GET", next, null, BaseQueryExecution.this.getDefaultHeaders());
                this.validateResponse(execution);
                Blob blob = (Blob)execution.getOutputParameterValues().get(0);
                ODataVersion version = BaseQueryExecution.getDataServiceVersion((String)execution.getResponseHeader("DataServiceVersion"));
                this.feed = BaseQueryExecution.this.parse(blob, version, this.entityTypeName, edsMetadata);
                this.rowIter = this.feed.getEntries().iterator();
            } else {
                throw new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17001, new Object[]{next}));
            }
        }

        private void validateResponse(BinaryWSProcedureExecution execution) throws TranslatorException {
            for (Response.Status expected : this.acceptedStatus) {
                if (execution.getResponseCode() == expected.getStatusCode()) continue;
                throw BaseQueryExecution.this.buildError(execution);
            }
        }

        Iterator<Entry> getResultsIter() {
            return this.rowIter;
        }
    }
}

