/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.auth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.teiid.resource.adapter.google.auth.AuthHeaderFactory;
import org.teiid.resource.adapter.google.common.SpreadsheetAuthException;

public class ClientLoginHeaderFactory
implements AuthHeaderFactory {
    private String authkey = null;
    private String username = null;
    private String password = null;

    public ClientLoginHeaderFactory(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void login() {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httpPost = new HttpPost("https://www.google.com/accounts/ClientLogin");
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("Email", this.username));
        nvps.add(new BasicNameValuePair("Passwd", this.password));
        nvps.add(new BasicNameValuePair("accountType", "GOOGLE"));
        nvps.add(new BasicNameValuePair("source", "ClientLoginHttpFactory"));
        nvps.add(new BasicNameValuePair("service", "wise"));
        HttpResponse response = null;
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            response = httpclient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception ex) {
            throw new SpreadsheetAuthException("Error when attempting Client Login", ex);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            String msg = null;
            msg = response.getStatusLine().getStatusCode() + ": " + response.getStatusLine().getReasonPhrase();
            throw new SpreadsheetAuthException("Error when attempting Client Login: " + msg);
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), Charset.forName("UTF-8")));
            br.readLine();
            br.readLine();
            this.authkey = br.readLine();
            if (this.authkey == null) {
                throw new SpreadsheetAuthException("Authkey read from server is null");
            }
            this.authkey = this.authkey.substring(this.authkey.indexOf(61) + 1);
        }
        catch (IOException e) {
            throw new SpreadsheetAuthException("Error reading Client Login response", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public String getAuthHeader() {
        return "GoogleLogin Auth=" + this.authkey;
    }
}

