/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.gdata;

import com.google.gdata.data.spreadsheet.SpreadsheetEntry;
import com.google.gdata.data.spreadsheet.WorksheetEntry;
import com.google.gdata.util.ServiceException;
import java.io.IOException;
import java.util.List;
import org.teiid.resource.adapter.google.common.SpreadsheetOperationException;
import org.teiid.resource.adapter.google.dataprotocol.GoogleDataProtocolAPI;
import org.teiid.resource.adapter.google.gdata.GDataClientLoginAPI;
import org.teiid.resource.adapter.google.metadata.Column;
import org.teiid.resource.adapter.google.metadata.SpreadsheetInfo;
import org.teiid.resource.adapter.google.metadata.Worksheet;

public class SpreadsheetMetadataExtractor {
    private GDataClientLoginAPI gdataAPI = null;
    private GoogleDataProtocolAPI visualizationAPI = null;

    public GoogleDataProtocolAPI getVisualizationAPI() {
        return this.visualizationAPI;
    }

    public void setVisualizationAPI(GoogleDataProtocolAPI visualizationAPI) {
        this.visualizationAPI = visualizationAPI;
    }

    public GDataClientLoginAPI getGdataAPI() {
        return this.gdataAPI;
    }

    public void setGdataAPI(GDataClientLoginAPI gdataAPI) {
        this.gdataAPI = gdataAPI;
    }

    public SpreadsheetInfo extractMetadata(String spreadsheetName) {
        SpreadsheetEntry sentry = this.gdataAPI.getSpreadsheetEntryByTitle(spreadsheetName);
        SpreadsheetInfo metadata = new SpreadsheetInfo(spreadsheetName);
        try {
            for (WorksheetEntry wentry : sentry.getWorksheets()) {
                String title = wentry.getTitle().getPlainText();
                Worksheet worksheet = metadata.createWorksheet(title);
                List<Column> cols = this.visualizationAPI.getMetadata(spreadsheetName, title);
                if (cols.isEmpty()) {
                    worksheet.setColumnCount(0);
                    continue;
                }
                worksheet.setColumns(cols);
            }
        }
        catch (IOException ex) {
            throw new SpreadsheetOperationException("Error getting metadata about Spreadsheets worksheet", ex);
        }
        catch (ServiceException ex) {
            throw new SpreadsheetOperationException("Error getting metadata about Spreadsheets worksheet", ex);
        }
        return metadata;
    }
}

