/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google;

import java.util.Arrays;
import java.util.List;
import javax.resource.cci.ConnectionFactory;
import org.teiid.core.BundleUtil;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.resource.adapter.google.GoogleSpreadsheetConnection;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.google.execution.DirectSpreadsheetQueryExecution;
import org.teiid.translator.google.execution.SpreadsheetQueryExecution;
import org.teiid.translator.google.metadata.MetadataProcessor;

@Translator(name="google-spreadsheet", description="A translator for Google Spreadsheet")
public class SpreadsheetExecutionFactory
extends ExecutionFactory<ConnectionFactory, GoogleSpreadsheetConnection> {
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(SpreadsheetExecutionFactory.class);

    public SpreadsheetExecutionFactory() {
        this.setSourceRequiredForMetadata(false);
    }

    public void start() throws TranslatorException {
        super.start();
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Google Spreadsheet ExecutionFactory Started"});
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, GoogleSpreadsheetConnection connection) throws TranslatorException {
        return new SpreadsheetQueryExecution((Select)command, connection, executionContext);
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, GoogleSpreadsheetConnection connection) throws TranslatorException {
        return new DirectSpreadsheetQueryExecution(arguments, executionContext, connection);
    }

    public void getMetadata(MetadataFactory metadataFactory, GoogleSpreadsheetConnection connection) throws TranslatorException {
        MetadataProcessor metadataProcessor = new MetadataProcessor(metadataFactory, connection.getSpreadsheetInfo());
        metadataProcessor.processMetadata();
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsLikeCriteria() {
        return true;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsNotCriteria() {
        return true;
    }

    public boolean supportsAggregatesCount() {
        return true;
    }

    public boolean supportsAggregatesMax() {
        return true;
    }

    public boolean supportsAggregatesMin() {
        return true;
    }

    public boolean supportsAggregatesSum() {
        return true;
    }

    public boolean supportsAggregatesAvg() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsOrderBy() {
        return false;
    }

    public boolean supportsHaving() {
        return false;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public List<String> getSupportedFunctions() {
        return Arrays.asList("year", "month", "dayofmonth", "hour", "minute", "second", "quarter", "dayofweek", "ucase", "lcase");
    }
}

