/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google.execution;

import java.util.Iterator;
import java.util.List;
import org.teiid.language.LanguageObject;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.google.GoogleSpreadsheetConnection;
import org.teiid.resource.adapter.google.common.SheetRow;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.google.SpreadsheetExecutionFactory;
import org.teiid.translator.google.execution.SpreadsheetSQLVisitor;

public class SpreadsheetQueryExecution
implements ResultSetExecution {
    private Select query;
    private GoogleSpreadsheetConnection connection;
    private Iterator<SheetRow> rowIterator;
    private ExecutionContext executionContext;

    public SpreadsheetQueryExecution(Select query, GoogleSpreadsheetConnection connection, ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.connection = connection;
        this.query = query;
    }

    public void close() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{SpreadsheetExecutionFactory.UTIL.getString("close_query")});
    }

    public void cancel() throws TranslatorException {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{SpreadsheetExecutionFactory.UTIL.getString("cancel_query")});
    }

    public void execute() throws TranslatorException {
        SpreadsheetSQLVisitor visitor = new SpreadsheetSQLVisitor();
        visitor.translateSQL((LanguageObject)this.query);
        this.rowIterator = this.connection.executeQuery(visitor.getWorksheetTitle(), visitor.getTranslatedSQL(), visitor.getOffsetValue(), visitor.getLimitValue(), this.executionContext.getBatchSize()).iterator();
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        if (this.rowIterator.hasNext()) {
            return this.rowIterator.next().getRow();
        }
        return null;
    }
}

