/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.google.execution;

import org.teiid.language.Function;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Select;
import org.teiid.language.visitor.SQLStringVisitor;
import org.teiid.translator.TypeFacility;

public class SpreadsheetSQLVisitor
extends SQLStringVisitor {
    private String worksheetTitle;
    private Integer limitValue = null;
    private Integer offsetValue = null;

    public String getWorksheetTitle() {
        return this.worksheetTitle;
    }

    protected String replaceElementName(String group, String element) {
        return element;
    }

    public String getTranslatedSQL() {
        return this.buffer.toString();
    }

    public void translateSQL(LanguageObject obj) {
        this.append(obj);
    }

    public void visit(Select obj) {
        this.buffer.append("SELECT").append(" ");
        this.append(obj.getDerivedColumns());
        if (obj.getFrom() != null && !obj.getFrom().isEmpty()) {
            NamedTable table = (NamedTable)obj.getFrom().get(0);
            this.worksheetTitle = table.getName();
            if (table.getMetadataObject().getNameInSource() != null) {
                this.worksheetTitle = table.getMetadataObject().getNameInSource();
            }
        }
        if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append((LanguageObject)obj.getWhere());
        }
        if (obj.getGroupBy() != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)obj.getGroupBy());
        }
        if (obj.getOrderBy() != null) {
            this.buffer.append(" ");
            this.append((LanguageObject)obj.getOrderBy());
        }
        if (obj.getLimit() != null) {
            if (obj.getLimit().getRowOffset() > 0) {
                this.offsetValue = obj.getLimit().getRowOffset();
            }
            this.limitValue = obj.getLimit().getRowLimit();
        }
    }

    public Integer getLimitValue() {
        return this.limitValue;
    }

    public Integer getOffsetValue() {
        return this.offsetValue;
    }

    public void visit(Function function) {
        if (function.getName().equalsIgnoreCase("dayofmonth")) {
            function.setName("day");
        } else if (function.getName().equalsIgnoreCase("ucase")) {
            function.setName("upper");
        } else if (function.getName().equalsIgnoreCase("lcase")) {
            function.setName("lower");
        }
        super.visit(function);
    }

    public void visit(Literal obj) {
        if (obj.getValue() == null) {
            super.visit(obj);
        } else if (obj.getType() == TypeFacility.RUNTIME_TYPES.DATE) {
            this.buffer.append("date ").append('\"').append(obj.getValue()).append('\"');
        } else if (obj.getType() == TypeFacility.RUNTIME_TYPES.TIME) {
            this.buffer.append("timeofday ").append('\"').append(obj.getValue()).append('\"');
        } else if (obj.getType() == TypeFacility.RUNTIME_TYPES.TIMESTAMP) {
            String val = obj.getValue().toString();
            int i = val.lastIndexOf(46);
            if (i != -1 && i < val.length() - 4) {
                val = val.substring(0, i + 4);
            }
            this.buffer.append("datetime ").append('\"').append(val).append('\"');
        } else {
            super.visit(obj);
        }
    }
}

