/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google;

import javax.security.auth.Subject;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.google.GoogleSpreadsheetConnection;
import org.teiid.resource.adapter.google.SpreadsheetManagedConnectionFactory;
import org.teiid.resource.adapter.google.auth.AuthHeaderFactory;
import org.teiid.resource.adapter.google.auth.ClientLoginHeaderFactory;
import org.teiid.resource.adapter.google.auth.OAuth2HeaderFactory;
import org.teiid.resource.adapter.google.common.GDataAPI;
import org.teiid.resource.adapter.google.common.SpreadsheetAuthException;
import org.teiid.resource.adapter.google.dataprotocol.GoogleDataProtocolAPI;
import org.teiid.resource.adapter.google.gdata.GDataClientLoginAPI;
import org.teiid.resource.adapter.google.gdata.SpreadsheetMetadataExtractor;
import org.teiid.resource.adapter.google.metadata.SpreadsheetInfo;
import org.teiid.resource.adapter.google.result.RowsResult;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.resource.spi.BasicManagedConnectionFactory;
import org.teiid.resource.spi.ConnectionContext;

public class SpreadsheetConnectionImpl
extends BasicConnection
implements GoogleSpreadsheetConnection {
    private SpreadsheetInfo info = null;
    private SpreadsheetManagedConnectionFactory config;
    private GDataClientLoginAPI gdata = null;
    private GoogleDataProtocolAPI dataProtocol = null;

    public SpreadsheetConnectionImpl(SpreadsheetManagedConnectionFactory config) {
        this.config = config;
        String userName = config.getUsername().trim();
        String password = config.getPassword();
        Subject subject = ConnectionContext.getSubject();
        if (subject != null) {
            userName = ConnectionContext.getUserName((Subject)subject, (BasicManagedConnectionFactory)this.config, (String)userName);
            password = ConnectionContext.getPassword((Subject)subject, (BasicManagedConnectionFactory)this.config, (String)userName, (String)password);
        }
        this.checkConfig(userName, password);
        Object authHeaderFactory = null;
        authHeaderFactory = "ClientLogin".equals(config.getAuthMethod()) ? new ClientLoginHeaderFactory(userName, password) : new OAuth2HeaderFactory(config.getRefreshToken().trim());
        this.gdata = new GDataClientLoginAPI();
        this.dataProtocol = new GoogleDataProtocolAPI();
        authHeaderFactory.login();
        this.dataProtocol.setHeaderFactory((AuthHeaderFactory)authHeaderFactory);
        this.gdata.setHeaderFactory((AuthHeaderFactory)authHeaderFactory);
        this.dataProtocol.setSpreadSheetBrowser((GDataAPI)this.gdata);
        LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)SpreadsheetManagedConnectionFactory.UTIL.getString("init"));
    }

    private void checkConfig(String userName, String password) {
        if (this.config.getSpreadsheetName() == null || this.config.getSpreadsheetName().trim().equals("")) {
            throw new SpreadsheetAuthException(SpreadsheetManagedConnectionFactory.UTIL.getString("provide_spreadsheetname", new Object[]{"SpreadsheetName"}));
        }
        if (this.config.getAuthMethod() == null || !this.config.getAuthMethod().equals("ClientLogin") && !this.config.getAuthMethod().equals("OAuth2")) {
            throw new SpreadsheetAuthException(SpreadsheetManagedConnectionFactory.UTIL.getString("provide_auth", new Object[]{"ClientLogin", "OAuth2"}));
        }
        if (this.config.getAuthMethod().equals("ClientLogin") && (userName == null || password == null || userName.equals("") || password.equals(""))) {
            throw new SpreadsheetAuthException(SpreadsheetManagedConnectionFactory.UTIL.getString("client_login_requires_pass"));
        }
        if (this.config.getAuthMethod().equals("OAuth2") && (this.config.getRefreshToken() == null || this.config.getRefreshToken().trim().equals(""))) {
            throw new SpreadsheetAuthException(SpreadsheetManagedConnectionFactory.UTIL.getString("oauth_requires_pass"));
        }
    }

    public void close() {
        LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)SpreadsheetManagedConnectionFactory.UTIL.getString("closing"));
    }

    public boolean isAlive() {
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{SpreadsheetManagedConnectionFactory.UTIL.getString("alive")});
        return true;
    }

    public RowsResult executeQuery(String worksheetName, String query, Integer offset, Integer limit, int batchSize) {
        return this.dataProtocol.executeQuery(this.config.getSpreadsheetName(), worksheetName, query, Math.min(batchSize, this.config.getBatchSize()), offset, limit);
    }

    public SpreadsheetInfo getSpreadsheetInfo() {
        if (this.info == null) {
            SpreadsheetMetadataExtractor metadataExtractor = new SpreadsheetMetadataExtractor();
            metadataExtractor.setGdataAPI(this.gdata);
            metadataExtractor.setVisualizationAPI(this.dataProtocol);
            this.info = metadataExtractor.extractMetadata(this.config.getSpreadsheetName());
        }
        return this.info;
    }
}

