/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ws;

import javax.security.auth.callback.CallbackHandler;
import org.teiid.resource.adapter.ws.WSSecurityCredential;
import org.teiid.resource.adapter.ws.WSSecurityToken;

public class SAMLTokenProfile
extends WSSecurityToken {
    private boolean signed = false;
    private String samlPropFile;
    private CallbackHandler handler;

    public SAMLTokenProfile(boolean signed, String samlPropFile, CallbackHandler handler) {
        this.signed = signed;
        this.samlPropFile = samlPropFile;
        this.handler = handler;
    }

    @Override
    public void addSecurity(WSSecurityCredential credential) {
        if (this.signed) {
            this.setAction(credential, "SAMLTokenSigned");
        } else {
            this.setAction(credential, "SAMLTokenUnsigned");
        }
        credential.getRequestPropterties().put("samlPropFile", this.samlPropFile);
        credential.getRequestPropterties().put("samlCallbackRef", this.handler);
    }
}

