/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ws;

import java.io.IOException;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.ws.WSManagedConnectionFactory;
import org.teiid.resource.adapter.ws.WSSecurityCredential;
import org.teiid.resource.adapter.ws.WSSecurityToken;

public class SignatureProfile
extends WSSecurityToken
implements CallbackHandler {
    private String signatureUser;
    private String signaturePassword;
    private Properties signatureProperties;
    private String signatureKeyIdentifier;
    private String signatureParts;
    private String signatureAlgorithm;
    private String signatureDigestAlgorithm;

    public SignatureProfile(String signatureUser, String signaturePassword, Properties signatureProperties, String signatureKeyIdentifier, String signatureParts, String signatureAlgorithm, String signatureDigestAlgorithm) {
        this.signatureUser = signatureUser;
        this.signaturePassword = signaturePassword;
        this.signatureProperties = signatureProperties;
        this.signatureKeyIdentifier = signatureKeyIdentifier;
        this.signatureParts = signatureParts;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signatureDigestAlgorithm = signatureDigestAlgorithm;
        LogManager.logDetail((String)WSManagedConnectionFactory.UTIL.getString("using_signature_profile"), (Object[])new Object[0]);
    }

    @Override
    public void addSecurity(WSSecurityCredential credential) {
        this.setAction(credential, "Signature");
        if (this.signatureUser != null) {
            credential.getRequestPropterties().put("signatureUser", this.signatureUser);
        }
        if (this.signaturePassword != null) {
            credential.getRequestPropterties().put("passwordCallbackRef", this);
        }
        credential.getRequestPropterties().put("signaturePropRefId", this.signatureProperties);
        if (this.signatureKeyIdentifier != null) {
            credential.getRequestPropterties().put("signatureKeyIdentifier", this.signatureKeyIdentifier);
        }
        if (this.signatureParts != null) {
            credential.getRequestPropterties().put("signatureParts", this.signatureParts);
        }
        if (this.signatureAlgorithm != null) {
            credential.getRequestPropterties().put("signatureAlgorithm", this.signatureAlgorithm);
        }
        if (this.signatureDigestAlgorithm != null) {
            credential.getRequestPropterties().put("signatureDigestAlgorithm", this.signatureDigestAlgorithm);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (this.signatureUser != null && this.signaturePassword != null) {
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof WSPasswordCallback)) {
                    throw new UnsupportedCallbackException(callbacks[i], "unrecognized_callback");
                }
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                pc.setPassword(this.signaturePassword);
            }
        } else {
            super.handleCallback(callbacks);
        }
    }
}

