/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ws;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBusFactory;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.resource.adapter.ws.WSConnectionImpl;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;

public class WSManagedConnectionFactory
extends BasicManagedConnectionFactory {
    private static final long serialVersionUID = -2998163922934555003L;
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(WSManagedConnectionFactory.class);
    private String endPoint;
    private List<? extends Interceptor> outInterceptors;
    private String wsdl;
    private String serviceName = "teiid";
    private URL wsdlUrl;
    private String securityType = SecurityType.None.name();
    private String configFile;
    private String endPointName = "teiid";
    private String authPassword;
    private String authUserName;
    private Long requestTimeout;
    private Long connectTimeout;
    private String namespaceUri = "http://teiid.org";
    private Bus bus;
    private QName portQName;
    private QName serviceQName;
    static final String DEFAULT_NAMESPACE_URI = "http://teiid.org";
    static final String DEFAULT_LOCAL_NAME = "teiid";

    public BasicConnectionFactory<WSConnectionImpl> createConnectionFactory() throws ResourceException {
        if (this.endPointName == null) {
            this.endPointName = DEFAULT_LOCAL_NAME;
        }
        if (this.serviceName == null) {
            this.serviceName = DEFAULT_LOCAL_NAME;
        }
        if (this.namespaceUri == null) {
            this.namespaceUri = DEFAULT_NAMESPACE_URI;
        }
        this.portQName = new QName(this.namespaceUri, this.endPointName);
        this.serviceQName = new QName(this.namespaceUri, this.serviceName);
        if (this.wsdl != null) {
            try {
                this.wsdlUrl = new URL(this.wsdl);
            }
            catch (MalformedURLException e) {
                File f = new File(this.wsdl);
                try {
                    this.wsdlUrl = f.toURI().toURL();
                }
                catch (MalformedURLException e1) {
                    throw new InvalidPropertyException((Throwable)e1);
                }
            }
        }
        if (this.configFile != null) {
            this.bus = new SpringBusFactory().createBus(this.configFile);
            JaxWsClientFactoryBean instance = new JaxWsClientFactoryBean();
            if (this.wsdl == null) {
                Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
                if (null != configurer) {
                    configurer.configureBean(this.portQName.toString() + ".jaxws-client.proxyFactory", (Object)instance);
                }
                this.outInterceptors = instance.getOutInterceptors();
            }
        }
        return new BasicConnectionFactory<WSConnectionImpl>(){

            public WSConnectionImpl getConnection() throws ResourceException {
                return new WSConnectionImpl(WSManagedConnectionFactory.this);
            }
        };
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getEndPointName() {
        return this.endPointName;
    }

    public void setEndPointName(String portName) {
        this.endPointName = portName;
    }

    public String getAuthPassword() {
        return this.authPassword;
    }

    public void setAuthPassword(String authPassword) {
        this.authPassword = authPassword;
    }

    public String getAuthUserName() {
        return this.authUserName;
    }

    public void setAuthUserName(String authUserName) {
        this.authUserName = authUserName;
    }

    public String getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Long timeout) {
        this.requestTimeout = timeout;
    }

    public SecurityType getAsSecurityType() {
        return SecurityType.valueOf(this.securityType);
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String config) {
        this.configFile = config;
    }

    public String getConfigName() {
        return this.endPointName;
    }

    public void setConfigName(String configName) {
        this.endPointName = configName;
    }

    public Bus getBus() {
        return this.bus;
    }

    public QName getPortQName() {
        return this.portQName;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public URL getWsdlUrl() {
        return this.wsdlUrl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public List<? extends Interceptor> getOutInterceptors() {
        return this.outInterceptors;
    }

    public Long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.authPassword == null ? 0 : this.authPassword.hashCode());
        result = 31 * result + (this.authUserName == null ? 0 : this.authUserName.hashCode());
        result = 31 * result + (this.configFile == null ? 0 : this.configFile.hashCode());
        result = 31 * result + (this.endPointName == null ? 0 : this.endPointName.hashCode());
        result = 31 * result + (this.endPoint == null ? 0 : this.endPoint.hashCode());
        result = 31 * result + (this.securityType == null ? 0 : this.securityType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WSManagedConnectionFactory other = (WSManagedConnectionFactory)((Object)obj);
        if (!WSManagedConnectionFactory.checkEquals((Object)this.authPassword, (Object)other.authPassword)) {
            return false;
        }
        if (!WSManagedConnectionFactory.checkEquals((Object)this.authUserName, (Object)other.authUserName)) {
            return false;
        }
        if (!WSManagedConnectionFactory.checkEquals((Object)this.configFile, (Object)other.configFile)) {
            return false;
        }
        if (!WSManagedConnectionFactory.checkEquals((Object)this.endPointName, (Object)other.endPointName)) {
            return false;
        }
        if (!WSManagedConnectionFactory.checkEquals((Object)this.endPoint, (Object)other.endPoint)) {
            return false;
        }
        if (!WSManagedConnectionFactory.checkEquals((Object)this.securityType, (Object)other.securityType)) {
            return false;
        }
        return EquivalenceUtil.areEqual((Object)this.requestTimeout, (Object)other.requestTimeout) && EquivalenceUtil.areEqual((Object)this.connectTimeout, (Object)other.connectTimeout);
    }

    public static enum SecurityType {
        None,
        HTTPBasic,
        WSSecurity;

    }
}

