/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.xquery;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Serializer;
import nu.xom.Text;
import nu.xom.XMLException;
import nux.xom.xquery.DefaultResultSequence;

public class ResultSequenceSerializer {
    public static final String W3C_ALGORITHM = "w3c";
    public static final String WRAP_ALGORITHM = "wrap";
    private String algorithm = "w3c";
    private int indent = 0;
    private String encoding = "UTF-8";
    private boolean nfc = false;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public int getIndent() {
        return this.indent;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean getUnicodeNormalizationFormC() {
        return this.nfc;
    }

    public void setAlgorithm(String algorithm) {
        if (!W3C_ALGORITHM.equals(algorithm) && !WRAP_ALGORITHM.equals(algorithm)) {
            throw new IllegalArgumentException("Unrecognized XQuery serialization algorithm: " + algorithm);
        }
        this.algorithm = algorithm;
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException("Encoding must not be null");
        }
        this.encoding = encoding;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void setUnicodeNormalizationFormC(boolean nfc) {
        this.nfc = nfc;
    }

    public String toString() {
        return "[algorithm=" + this.getAlgorithm() + ", encoding=" + this.getEncoding() + ", indent=" + this.getIndent() + ", unicodeNormalizationFormC=" + this.getUnicodeNormalizationFormC() + "]";
    }

    public void write(Nodes nodes, OutputStream out) throws IOException {
        SequenceSerializer ser = W3C_ALGORITHM.equals(this.getAlgorithm()) ? new W3CSerializer(out, this.getEncoding()) : new WrapSerializer(out, this.getEncoding());
        ser.setIndent(this.getIndent());
        ser.setUnicodeNormalizationFormC(this.getUnicodeNormalizationFormC());
        ser.write(nodes);
    }

    private static abstract class SequenceSerializer
    extends Serializer {
        public SequenceSerializer(OutputStream out, String encoding) throws UnsupportedEncodingException {
            super(out, encoding);
        }

        public abstract void write(Nodes var1) throws IOException;
    }

    private static final class W3CSerializer
    extends SequenceSerializer {
        private boolean writeNamespaceDeclarationsInScope = false;
        private static boolean isXom11Plus = true;

        public W3CSerializer(OutputStream out, String encoding) throws UnsupportedEncodingException {
            super(out, encoding);
        }

        protected void writeXMLDeclaration() throws IOException {
            this.writeRaw("<?xml version=\"1.0\" encoding=\"");
            this.writeRaw(this.getEncoding());
            this.writeRaw("\"?>");
        }

        public void write(Nodes nodes) throws IOException {
            boolean indentYes = this.getIndent() > 0;
            boolean mayBreakLine = true;
            boolean isPreviousAtomic = false;
            this.writeNamespaceDeclarationsInScope = false;
            this.writeXMLDeclaration();
            int size = nodes.size();
            int i = 0;
            while (i < size) {
                Node node = nodes.get(i);
                if (node instanceof Attribute) {
                    throw new XMLException("SENR0001: W3C XQuery Serialization spec forbids top-level attributes");
                }
                if (node instanceof Document) {
                    Document doc = (Document)node;
                    int j = 0;
                    while (j < doc.getChildCount()) {
                        Node child = doc.getChild(j);
                        if (mayBreakLine && indentYes && child instanceof Element) {
                            this.breakLine();
                        }
                        this.writeChild(child);
                        mayBreakLine = true;
                        ++j;
                    }
                    isPreviousAtomic = false;
                } else if (DefaultResultSequence.isAtomicValue(node)) {
                    if (isPreviousAtomic) {
                        this.writeEscaped(" ");
                    }
                    this.writeEscaped(node.getChild(0).getValue());
                    mayBreakLine = false;
                    isPreviousAtomic = true;
                } else if (node instanceof Text) {
                    String value = node.getValue();
                    if (value.length() > 0) {
                        this.writeEscaped(value);
                        mayBreakLine = false;
                        isPreviousAtomic = false;
                    }
                } else {
                    if (node instanceof Element) {
                        ParentNode parent;
                        if (mayBreakLine && indentYes) {
                            this.breakLine();
                        }
                        this.writeNamespaceDeclarationsInScope = (parent = node.getParent()) != null && !(parent instanceof Document);
                    }
                    this.writeChild(node);
                    this.writeNamespaceDeclarationsInScope = false;
                    mayBreakLine = true;
                    isPreviousAtomic = false;
                }
                ++i;
            }
            if (mayBreakLine && indentYes) {
                this.breakLine();
            }
            this.flush();
        }

        protected void writeNamespaceDeclarations(Element element) throws IOException {
            if (this.writeNamespaceDeclarationsInScope) {
                this.writeNamespaceDeclarationsInScope = false;
                this.writeNamespaceDeclarationsInScope(element);
            } else {
                super.writeNamespaceDeclarations(element);
            }
        }

        private void writeNamespaceDeclarationsInScope(Element element) throws IOException {
            Map namespaces = W3CSerializer.getNamespacePrefixesInScope(element);
            int size = namespaces.size();
            Iterator iter = namespaces.entrySet().iterator();
            int i = 0;
            while (i < size) {
                Map.Entry entry = iter.next();
                String uri = (String)entry.getValue();
                if (uri.length() > 0) {
                    String prefix = (String)entry.getKey();
                    this.writeRaw(" ");
                    this.writeNamespaceDeclaration(prefix, uri);
                }
                ++i;
            }
        }

        private static Map getNamespacePrefixesInScope(Element element) {
            if (isXom11Plus) {
                try {
                    return W3CSerializer.getNamespacePrefixesInScopePublic(element);
                }
                catch (Error e) {
                    isXom11Plus = false;
                }
            }
            return W3CSerializer.getNamespacePrefixesInScopeNonPublic(element);
        }

        private static Map getNamespacePrefixesInScopePublic(Element element) {
            return element.getNamespacePrefixesInScope();
        }

        private static Map getNamespacePrefixesInScopeNonPublic(Element element) {
            ParentNode parent;
            HashMap<String, String> namespaces = new HashMap<String, String>();
            do {
                int size = element.getNamespaceDeclarationCount();
                int i = 0;
                while (i < size) {
                    String prefix = element.getNamespacePrefix(i);
                    if (!namespaces.containsKey(prefix)) {
                        String uri = element.getNamespaceURI(prefix);
                        namespaces.put(prefix, uri);
                    }
                    ++i;
                }
            } while ((element = (parent = element.getParent()) instanceof Element ? (Element)parent : null) != null);
            return namespaces;
        }
    }

    private static final class WrapSerializer
    extends SequenceSerializer {
        private static final HashMap TEMPLATES = WrapSerializer.initTemplates();
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;
        static /* synthetic */ Class class$3;
        static /* synthetic */ Class class$4;
        static /* synthetic */ Class class$5;
        static /* synthetic */ Class class$6;
        static /* synthetic */ Class class$7;

        public WrapSerializer(OutputStream out, String encoding) throws UnsupportedEncodingException {
            super(out, encoding);
        }

        public void write(Nodes nodes) throws IOException {
            Document doc = WrapSerializer.wrapSequence(nodes);
            this.write(doc);
        }

        private static Document wrapSequence(Nodes nodes) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("nu.xom.Nodes");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Element items = (Element)TEMPLATES.get(clazz.getName());
            items = new Element(items);
            int size = nodes.size();
            int i = 0;
            while (i < size) {
                items.appendChild((Node)WrapSerializer.wrap(nodes.get(i)));
                ++i;
            }
            return new Document(items);
        }

        private static Element wrap(Node node) {
            if (DefaultResultSequence.isAtomicValue(node)) {
                return (Element)node.copy();
            }
            Element item = (Element)TEMPLATES.get(node.getClass().getName());
            if (item == null) {
                throw new IllegalArgumentException("Unrecognized node type: " + node.getClass());
            }
            item = new Element(item);
            if (node instanceof Attribute) {
                Attribute attr = (Attribute)node;
                item.addAttribute((Attribute)attr.copy());
            } else if (node instanceof Document) {
                Document doc = (Document)node;
                int j = 0;
                while (j < doc.getChildCount()) {
                    item.appendChild(doc.getChild(j).copy());
                    ++j;
                }
            } else if (node instanceof DocType) {
                DocType docType = (DocType)node;
                Element e = new Element("rootName");
                e.appendChild(docType.getRootElementName());
                item.appendChild((Node)e);
                if (docType.getPublicID() != null) {
                    e = new Element("publicID");
                    e.appendChild(docType.getPublicID());
                    item.appendChild((Node)e);
                }
                if (docType.getSystemID() != null) {
                    e = new Element("systemID");
                    e.appendChild(docType.getSystemID());
                    item.appendChild((Node)e);
                }
                if (docType.getInternalDTDSubset().length() > 0) {
                    e = new Element("internalDTDSubset");
                    e.appendChild(docType.getInternalDTDSubset());
                    item.appendChild((Node)e);
                }
            } else {
                item.appendChild(node.copy());
            }
            return item;
        }

        private static HashMap initTemplates() {
            HashMap<String, Element> templates = new HashMap<String, Element>();
            String ns = "http://dsd.lbl.gov/nux";
            Element template = new Element("item:document", ns);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("nu.xom.Document");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            templates.put(clazz.getName(), template);
            template = new Element("item:element", ns);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("nu.xom.Element");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            templates.put(clazz2.getName(), template);
            template = new Element("item:attribute", ns);
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("nu.xom.Attribute");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            templates.put(clazz3.getName(), template);
            template = new Element("item:text", ns);
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("nu.xom.Text");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            templates.put(clazz4.getName(), template);
            template = new Element("item:comment", ns);
            Class<?> clazz5 = class$5;
            if (clazz5 == null) {
                try {
                    clazz5 = class$5 = Class.forName("nu.xom.Comment");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            templates.put(clazz5.getName(), template);
            template = new Element("item:pi", ns);
            Class<?> clazz6 = class$6;
            if (clazz6 == null) {
                try {
                    clazz6 = class$6 = Class.forName("nu.xom.ProcessingInstruction");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            templates.put(clazz6.getName(), template);
            template = new Element("item:docType", ns);
            Class<?> clazz7 = class$7;
            if (clazz7 == null) {
                try {
                    clazz7 = class$7 = Class.forName("nu.xom.DocType");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            templates.put(clazz7.getName(), template);
            template = new Element("item:items", ns);
            template.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            Class<?> clazz8 = class$0;
            if (clazz8 == null) {
                try {
                    clazz8 = class$0 = Class.forName("nu.xom.Nodes");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            templates.put(clazz8.getName(), template);
            return templates;
        }
    }
}

