/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.language.BatchedUpdates;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Insert;
import org.teiid.language.Literal;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Column;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.jpa.JPAPlugin;
import org.teiid.translator.jpa.JPQLBaseExecution;
import org.teiid.translator.jpa.JPQLUpdateQueryVisitor;

public class JPQLUpdateExecution
extends JPQLBaseExecution
implements UpdateExecution {
    private Command command;
    private int[] results;

    public JPQLUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, EntityManager em) {
        super(executionContext, metadata, em);
        this.command = command;
    }

    public void execute() throws TranslatorException {
        if (this.command instanceof BatchedUpdates) {
            BatchedUpdates updates = (BatchedUpdates)this.command;
            this.results = new int[updates.getUpdateCommands().size()];
            int index = 0;
            for (Command cmd : updates.getUpdateCommands()) {
                this.results[index++] = this.executeUpdate(cmd);
            }
        } else if (this.command instanceof Insert) {
            this.results = new int[1];
            Object entity = this.handleInsert((Insert)this.command);
            this.enityManager.merge(entity);
            this.results[0] = 1;
        } else {
            this.results = new int[1];
            this.results[0] = this.executeUpdate(this.command);
        }
    }

    private int executeUpdate(Command cmd) throws TranslatorException {
        String jpql = JPQLUpdateQueryVisitor.getJPQLString(cmd);
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"JPA Source-Query:", jpql});
        Query query = this.enityManager.createQuery(jpql);
        return query.executeUpdate();
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return this.results;
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    private Object handleInsert(Insert insert) throws TranslatorException {
        try {
            String entityClassName = insert.getTable().getMetadataObject().getProperty("entity_class", false);
            Object entity = ReflectionHelper.create((String)entityClassName, null, (ClassLoader)this.executionContext.getCommandContext().getVDBClassLoader());
            List columns = insert.getColumns();
            List values = ((ExpressionValueSource)insert.getValueSource()).getValues();
            if (columns.size() != values.size()) {
                throw new TranslatorException(JPAPlugin.Util.gs((BundleUtil.Event)JPAPlugin.Event.TEIID14007, new Object[0]));
            }
            for (int i = 0; i < columns.size(); ++i) {
                Column column = ((ColumnReference)columns.get(i)).getMetadataObject();
                Object value = values.get(i);
                String name = column.getProperty("assosiated_with_table", false);
                if (name != null) continue;
                if (value instanceof Literal) {
                    Literal literalValue = (Literal)value;
                    PropertiesUtils.setBeanProperty((Object)entity, (String)column.getName(), (Object)literalValue.getValue());
                    continue;
                }
                PropertiesUtils.setBeanProperty((Object)entity, (String)column.getName(), value);
            }
            return entity;
        }
        catch (TeiidException e) {
            throw new TranslatorException((Throwable)e);
        }
    }
}

