/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ldap;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.ldap.LDAPManagedConnectionFactory;
import org.teiid.resource.adapter.ldap.LDAPPlugin;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.resource.spi.BasicManagedConnectionFactory;
import org.teiid.resource.spi.ConnectionContext;

public class LDAPConnectionImpl
extends BasicConnection
implements LdapContext {
    private LDAPManagedConnectionFactory config;
    private InitialLdapContext initCtx;
    public static final String LDAP_AUTH_TYPE = "simple";
    public static final String LDAP_USER_OBJECT_TYPE = "person";
    public static final String LDAP_REFERRAL_MODE = "follow";

    public LDAPConnectionImpl(LDAPManagedConnectionFactory config) throws ResourceException {
        this.config = config;
        this.checkProperties();
        this.initCtx = this.initializeLDAPContext();
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"LDAP Connection has been newly created."});
    }

    private void checkProperties() throws ResourceException {
        if (this.config.getLdapUrl() == null) {
            String msg = LDAPPlugin.Util.getString("LDAPConnection.urlPropNotFound");
            throw new ResourceException(msg);
        }
    }

    private InitialLdapContext initializeLDAPContext() throws ResourceException {
        InitialLdapContext initContext;
        Hashtable<String, Object> connenv = new Hashtable<String, Object>();
        connenv.put("java.naming.factory.initial", this.config.getLdapContextFactory());
        connenv.put("java.naming.provider.url", this.config.getLdapUrl());
        connenv.put("java.naming.referral", LDAP_REFERRAL_MODE);
        String userName = this.config.getLdapAdminUserDN();
        String password = this.config.getLdapAdminUserPassword();
        Subject subject = ConnectionContext.getSubject();
        if (subject != null) {
            userName = ConnectionContext.getUserName((Subject)subject, (BasicManagedConnectionFactory)this.config, (String)userName);
            password = ConnectionContext.getPassword((Subject)subject, (BasicManagedConnectionFactory)this.config, (String)userName, (String)password);
        }
        if (userName == null) {
            String msg = LDAPPlugin.Util.getString("LDAPConnection.adminUserDNPropNotFound");
            throw new ResourceException(msg);
        }
        if (password == null) {
            String msg = LDAPPlugin.Util.getString("LDAPConnection.adminUserPassPropNotFound");
            throw new ResourceException(msg);
        }
        if (!userName.equals("")) {
            connenv.put("java.naming.security.authentication", LDAP_AUTH_TYPE);
            connenv.put("java.naming.security.principal", userName);
            connenv.put("java.naming.security.credentials", password);
        } else {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"LDAP Username DN was blank; performing anonymous bind."});
            connenv.put("java.naming.security.authentication", "none");
        }
        if (this.config.getLdapTxnTimeoutInMillis() != null && this.config.getLdapTxnTimeoutInMillis() != -1L) {
            connenv.put("com.sun.jndi.ldap.connect.timeout", this.config.getLdapTxnTimeoutInMillis());
        }
        connenv.put("com.sun.jndi.ldap.connect.pool", "true");
        connenv.put("com.sun.jndi.ldap.connect.pool.debug", "fine");
        try {
            initContext = new InitialLdapContext(connenv, null);
        }
        catch (NamingException ne) {
            String msg = LDAPPlugin.Util.getString("LDAPConnection.directoryNamingError", new Object[]{ne.getExplanation()});
            throw new ResourceException(msg);
        }
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Successfully obtained initial LDAP context."});
        return initContext;
    }

    @Override
    public void close() {
        if (this.initCtx != null) {
            try {
                this.initCtx.close();
            }
            catch (NamingException e) {
                LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{LDAPPlugin.Util.getString("LDAPConnection.contextCloseError", new Object[]{e.getExplanation()})});
            }
        }
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"LDAP context has been closed."});
    }

    public boolean isAlive() {
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"LDAP Connection is alive."});
        return true;
    }

    @Override
    public Object lookup(String context) throws NamingException {
        return this.initCtx.lookup(context);
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.initCtx.addToEnvironment(propName, propVal);
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.initCtx.bind(name, obj, attrs);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.initCtx.bind(name, obj);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.initCtx.bind(name, obj, attrs);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.initCtx.bind(name, obj);
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.initCtx.composeName(name, prefix);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.initCtx.composeName(name, prefix);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.initCtx.createSubcontext(name, attrs);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.initCtx.createSubcontext(name);
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.initCtx.createSubcontext(name, attrs);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.initCtx.createSubcontext(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.initCtx.destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.initCtx.destroySubcontext(name);
    }

    public boolean equals(Object obj) {
        return this.initCtx.equals(obj);
    }

    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest request) throws NamingException {
        return this.initCtx.extendedOperation(request);
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.initCtx.getAttributes(name, attrIds);
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.initCtx.getAttributes(name);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.initCtx.getAttributes(name, attrIds);
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.initCtx.getAttributes(name);
    }

    @Override
    public Control[] getConnectControls() throws NamingException {
        return this.initCtx.getConnectControls();
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.initCtx.getEnvironment();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.initCtx.getNameInNamespace();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.initCtx.getNameParser(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.initCtx.getNameParser(name);
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        return this.initCtx.getRequestControls();
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        return this.initCtx.getResponseControls();
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return this.initCtx.getSchema(name);
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        return this.initCtx.getSchema(name);
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.initCtx.getSchemaClassDefinition(name);
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return this.initCtx.getSchemaClassDefinition(name);
    }

    public int hashCode() {
        return this.initCtx.hashCode();
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.initCtx.list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.initCtx.list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.initCtx.listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.initCtx.listBindings(name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.initCtx.lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.initCtx.lookupLink(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.initCtx.lookupLink(name);
    }

    @Override
    public void modifyAttributes(Name name, int modOp, Attributes attrs) throws NamingException {
        this.initCtx.modifyAttributes(name, modOp, attrs);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.initCtx.modifyAttributes(name, mods);
    }

    @Override
    public void modifyAttributes(String name, int modOp, Attributes attrs) throws NamingException {
        this.initCtx.modifyAttributes(name, modOp, attrs);
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.initCtx.modifyAttributes(name, mods);
    }

    @Override
    public LdapContext newInstance(Control[] reqCtls) throws NamingException {
        return this.initCtx.newInstance(reqCtls);
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        this.initCtx.rebind(name, obj, attrs);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.initCtx.rebind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.initCtx.rebind(name, obj, attrs);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.initCtx.rebind(name, obj);
    }

    @Override
    public void reconnect(Control[] connCtls) throws NamingException {
        this.initCtx.reconnect(connCtls);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.initCtx.removeFromEnvironment(propName);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.initCtx.rename(oldName, newName);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.initCtx.rename(oldName, newName);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.initCtx.search(name, matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.initCtx.search(name, matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.initCtx.search(name, filterExpr, filterArgs, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.initCtx.search(name, filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.initCtx.search(name, matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return this.initCtx.search(name, matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.initCtx.search(name, filterExpr, filterArgs, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return this.initCtx.search(name, filter, cons);
    }

    @Override
    public void setRequestControls(Control[] requestControls) throws NamingException {
        this.initCtx.setRequestControls(requestControls);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.initCtx.unbind(name);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.initCtx.unbind(name);
    }
}

