/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.teiid.core.types.BaseLob;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.SqlUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SQLXMLImpl
extends BaseLob
implements SQLXML {
    public SQLXMLImpl() {
    }

    public SQLXMLImpl(final byte[] bytes) {
        super(new InputStreamFactory(){

            @Override
            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(bytes);
            }

            @Override
            public InputStreamFactory.StorageMode getStorageMode() {
                return InputStreamFactory.StorageMode.MEMORY;
            }

            @Override
            public long getLength() {
                return bytes.length;
            }
        });
        this.setEncoding("UTF-8");
    }

    public SQLXMLImpl(String str) {
        this(str.getBytes(Charset.forName("UTF-8")));
    }

    public SQLXMLImpl(InputStreamFactory factory) {
        super(factory);
    }

    @Override
    public Charset getCharset() {
        Charset cs = super.getCharset();
        if (cs != null) {
            return cs;
        }
        String enc = null;
        try {
            enc = XMLType.getEncoding(this.getBinaryStream());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (enc != null) {
            this.setEncoding(enc);
        } else {
            super.setCharset(Streamable.CHARSET);
        }
        return super.getCharset();
    }

    @Override
    public <T extends Source> T getSource(Class<T> sourceClass) throws SQLException {
        if (sourceClass == null || sourceClass == StreamSource.class) {
            return (T)new StreamSource(this.getBinaryStream(), this.getStreamFactory().getSystemId());
        }
        if (sourceClass == StAXSource.class) {
            XMLInputFactory factory = XMLType.getXmlInputFactory();
            try {
                return (T)new StAXSource(factory.createXMLStreamReader(this.getBinaryStream()));
            }
            catch (XMLStreamException e) {
                throw new SQLException(e);
            }
        }
        if (sourceClass == SAXSource.class) {
            return (T)new SAXSource(new InputSource(this.getBinaryStream()));
        }
        if (sourceClass == DOMSource.class) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                DocumentBuilder docBuilder = dbf.newDocumentBuilder();
                Document doc = docBuilder.parse(new InputSource(this.getBinaryStream()));
                return (T)new DOMSource(doc);
            }
            catch (ParserConfigurationException e) {
                throw new SQLException(e);
            }
            catch (SAXException e) {
                throw new SQLException(e);
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        throw new SQLException("Unsupported source type " + sourceClass);
    }

    @Override
    public String getString() throws SQLException {
        try {
            return ObjectConverterUtil.convertToString(this.getCharacterStream());
        }
        catch (IOException e) {
            SQLException ex = new SQLException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public OutputStream setBinaryStream() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public Writer setCharacterStream() throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setString(String value) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public <T extends Result> T setResult(Class<T> resultClass) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }
}

