/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RelationalPlanner;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.NewCalculateCostUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleChooseDependent
implements OptimizerRule {
    private static AtomicInteger ID = new AtomicInteger();
    public static final int DEFAULT_INDEPENDENT_CARDINALITY = 10;
    public static final int UNKNOWN_INDEPENDENT_CARDINALITY = 256;

    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        List<CandidateJoin> matches = this.findCandidate(plan, metadata, analysisRecord);
        boolean pushCriteria = false;
        for (CandidateJoin entry : matches) {
            PlanNode joinNode = entry.joinNode;
            PlanNode sourceNode = entry.leftCandidate ? joinNode.getFirstChild() : joinNode.getLastChild();
            PlanNode siblingNode = entry.leftCandidate ? joinNode.getLastChild() : joinNode.getFirstChild();
            boolean bothCandidates = entry.leftCandidate && entry.rightCandidate;
            PlanNode chosenNode = this.chooseDepWithoutCosting(sourceNode, bothCandidates ? siblingNode : null, analysisRecord);
            if (chosenNode != null) {
                pushCriteria |= this.markDependent(chosenNode, joinNode, metadata, null, false);
                continue;
            }
            NewCalculateCostUtil.DependentCostAnalysis dca = NewCalculateCostUtil.computeCostForDepJoin(joinNode, !entry.leftCandidate, metadata, capFinder, context);
            PlanNode dependentNode = sourceNode;
            if (bothCandidates && dca.expectedCardinality == null) {
                dca = NewCalculateCostUtil.computeCostForDepJoin(joinNode, true, metadata, capFinder, context);
                if (dca.expectedCardinality != null) {
                    dependentNode = siblingNode;
                }
            }
            if (dca.expectedCardinality != null) {
                pushCriteria |= this.markDependent(dependentNode, joinNode, metadata, dca, null);
                continue;
            }
            float sourceCost = NewCalculateCostUtil.computeCostForTree(sourceNode, metadata);
            float siblingCost = NewCalculateCostUtil.computeCostForTree(siblingNode, metadata);
            List leftExpressions = (List)joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS);
            List rightExpressions = (List)joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS);
            float sourceNdv = NewCalculateCostUtil.getNDVEstimate(joinNode.getFirstChild(), metadata, sourceCost, leftExpressions, true);
            float siblingNdv = NewCalculateCostUtil.getNDVEstimate(joinNode.getLastChild(), metadata, siblingCost, rightExpressions, true);
            if (sourceCost != -1.0f && sourceNdv == -1.0f) {
                sourceNdv = sourceCost;
            }
            if (siblingCost != -1.0f && siblingNdv == -1.0f) {
                siblingNdv = siblingCost;
            }
            if (bothCandidates && sourceNdv != -1.0f && (sourceCost <= 10.0f && sourceCost <= siblingCost || siblingCost == -1.0f && sourceNdv <= 256.0f)) {
                pushCriteria |= this.markDependent(siblingNode, joinNode, metadata, null, sourceCost > 10.0f ? Boolean.valueOf(true) : null);
                continue;
            }
            if (siblingNdv == -1.0f || !(siblingCost <= 10.0f) && (sourceCost != -1.0f || !(siblingNdv <= 256.0f))) continue;
            pushCriteria |= this.markDependent(sourceNode, joinNode, metadata, null, siblingCost > 10.0f ? Boolean.valueOf(true) : null);
        }
        if (pushCriteria) {
            rules.push(RuleConstants.CLEAN_CRITERIA);
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        }
        return plan;
    }

    List<CandidateJoin> findCandidate(PlanNode root, QueryMetadataInterface metadata, AnalysisRecord analysisRecord) throws QueryMetadataException, TeiidComponentException {
        ArrayList<CandidateJoin> candidates = new ArrayList<CandidateJoin>();
        for (PlanNode joinNode : NodeEditor.findAllNodes(root, 4, 1)) {
            CandidateJoin candidate = null;
            Iterator<PlanNode> j = joinNode.getChildren().iterator();
            while (j.hasNext()) {
                PlanNode child = j.next();
                if ((child = FrameUtil.findJoinSourceNode(child)).hasBooleanProperty(NodeConstants.Info.MAKE_NOT_DEP) || !this.isValidJoin(joinNode, child, analysisRecord)) continue;
                if (candidate == null) {
                    candidate = new CandidateJoin();
                    candidate.joinNode = joinNode;
                    candidates.add(candidate);
                }
                if (j.hasNext()) {
                    candidate.leftCandidate = true;
                    continue;
                }
                candidate.rightCandidate = true;
            }
        }
        return candidates;
    }

    boolean isValidJoin(PlanNode joinNode, PlanNode sourceNode, AnalysisRecord analysisRecord) throws QueryMetadataException, TeiidComponentException {
        JoinType jtype = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jtype.equals(JoinType.JOIN_CROSS) || jtype.equals(JoinType.JOIN_FULL_OUTER)) {
            sourceNode.recordDebugAnnotation("parent join is CROSS or FULL OUTER", null, "Rejecting dependent join", analysisRecord, null);
            return false;
        }
        if (!joinNode.getExportedCorrelatedReferences().isEmpty()) {
            sourceNode.recordDebugAnnotation("parent join has a correlated nested table", null, "Rejecting dependent join", analysisRecord, null);
            return false;
        }
        List jcrit = (List)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        if (jcrit == null || jcrit.size() == 0) {
            sourceNode.recordDebugAnnotation("parent join has has no join criteria", null, "Rejecting dependent join", analysisRecord, null);
            return false;
        }
        if (joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS) == null) {
            sourceNode.recordDebugAnnotation("parent join has no equa-join predicates", null, "Rejecting dependent join", analysisRecord, null);
            return false;
        }
        if (jtype.isOuter() && JoinUtil.getInnerSideJoinNodes(joinNode)[0] != sourceNode) {
            sourceNode.recordDebugAnnotation("node is on outer side of the join", null, "Rejecting dependent join", analysisRecord, null);
            return false;
        }
        return true;
    }

    PlanNode chooseDepWithoutCosting(PlanNode rootNode1, PlanNode rootNode2, AnalysisRecord analysisRecord) throws QueryMetadataException, TeiidComponentException {
        PlanNode sourceNode1 = FrameUtil.findJoinSourceNode(rootNode1);
        PlanNode sourceNode2 = null;
        if (rootNode2 != null) {
            sourceNode2 = FrameUtil.findJoinSourceNode(rootNode2);
        }
        if (sourceNode1.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            if (sourceNode2 != null && sourceNode2.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
                rootNode1.getParent().recordDebugAnnotation("both children have unsatisfied access patterns", null, "Neither node can be made dependent", analysisRecord, null);
                return null;
            }
            rootNode1.recordDebugAnnotation("unsatisfied access pattern detected", null, "marking as dependent side of join", analysisRecord, null);
            return rootNode1;
        }
        if (sourceNode2 != null && sourceNode2.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            sourceNode2.recordDebugAnnotation("unsatisfied access pattern detected", null, "marking as dependent side of join", analysisRecord, null);
            return rootNode2;
        }
        if (sourceNode1.hasBooleanProperty(NodeConstants.Info.MAKE_DEP)) {
            sourceNode1.recordDebugAnnotation("MAKE_DEP hint detected", null, "marking as dependent side of join", analysisRecord, null);
            return rootNode1;
        }
        if (sourceNode2 != null && sourceNode2.hasBooleanProperty(NodeConstants.Info.MAKE_DEP)) {
            sourceNode2.recordDebugAnnotation("MAKE_DEP hint detected", null, "marking as dependent side of join", analysisRecord, null);
            return rootNode2;
        }
        if (sourceNode1.hasBooleanProperty(NodeConstants.Info.MAKE_IND) && sourceNode2 != null) {
            sourceNode2.recordDebugAnnotation("MAKE_IND hint detected", null, "marking as dependent side of join", analysisRecord, null);
            return rootNode2;
        }
        if (sourceNode2 != null && sourceNode2.hasBooleanProperty(NodeConstants.Info.MAKE_IND)) {
            sourceNode1.recordDebugAnnotation("MAKE_IND hint detected", null, "marking as dependent side of join", analysisRecord, null);
            return rootNode1;
        }
        return null;
    }

    boolean markDependent(PlanNode sourceNode, PlanNode joinNode, QueryMetadataInterface metadata, NewCalculateCostUtil.DependentCostAnalysis dca, Boolean bound) throws QueryMetadataException, TeiidComponentException {
        PlanNode indNode;
        boolean isLeft = joinNode.getFirstChild() == sourceNode;
        List independentExpressions = (List)(isLeft ? joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS) : joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS));
        List dependentExpressions = (List)(isLeft ? joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS) : joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS));
        if (independentExpressions == null || independentExpressions.isEmpty()) {
            return false;
        }
        String id = "$dsc/id" + ID.getAndIncrement();
        joinNode.setProperty(NodeConstants.Info.DEPENDENT_VALUE_SOURCE, id);
        PlanNode planNode = indNode = isLeft ? joinNode.getLastChild() : joinNode.getFirstChild();
        if (bound == null) {
            List<PlanNode> sources = NodeEditor.findAllNodes(indNode, 64);
            block0: for (PlanNode planNode2 : sources) {
                for (GroupSymbol gs : planNode2.getGroups()) {
                    if (!gs.isTempTable() || metadata.getCardinality(gs.getMetadataID()) != -1) continue;
                    bound = true;
                    continue block0;
                }
            }
            if (bound == null) {
                bound = false;
            }
        }
        PlanNode crit = this.getDependentCriteriaNode(id, independentExpressions, dependentExpressions, indNode, metadata, dca, bound);
        sourceNode.addAsParent(crit);
        if (isLeft) {
            JoinUtil.swapJoinChildren(joinNode);
        }
        return true;
    }

    private PlanNode getDependentCriteriaNode(String id, List<Expression> independentExpressions, List<Expression> dependentExpressions, PlanNode indNode, QueryMetadataInterface metadata, NewCalculateCostUtil.DependentCostAnalysis dca, Boolean bound) throws QueryMetadataException, TeiidComponentException {
        Float cardinality = null;
        ArrayList<DependentSetCriteria.AttributeComparison> expressions = new ArrayList<DependentSetCriteria.AttributeComparison>(dependentExpressions.size());
        for (int i = 0; i < dependentExpressions.size(); ++i) {
            Expression depExpr = dependentExpressions.get(i);
            Expression indExpr = independentExpressions.get(i);
            DependentSetCriteria.AttributeComparison comp = new DependentSetCriteria.AttributeComparison();
            if (dca != null && dca.expectedNdv[i] != null) {
                if (dca.expectedNdv[i].floatValue() > 4.0f * dca.maxNdv[i].floatValue()) continue;
                comp.ndv = dca.expectedNdv[i].floatValue();
                comp.maxNdv = dca.maxNdv[i].floatValue();
            } else {
                Collection<ElementSymbol> elems = ElementCollectorVisitor.getElements((LanguageObject)indExpr, true);
                if (cardinality == null) {
                    cardinality = Float.valueOf(NewCalculateCostUtil.computeCostForTree(indNode, metadata));
                }
                comp.ndv = NewCalculateCostUtil.getNDVEstimate(indNode, metadata, cardinality.floatValue(), elems, true);
                if (bound.booleanValue()) {
                    comp.maxNdv = dca != null ? Math.max(comp.ndv * 4.0f, dca.expectedCardinality.floatValue() * 2.0f) : Math.max(256.0f, comp.ndv * 4.0f);
                }
            }
            comp.ind = indExpr;
            comp.dep = SymbolMap.getExpression(depExpr);
            expressions.add(comp);
        }
        return RuleChooseDependent.createDependentSetNode(id, expressions);
    }

    static PlanNode createDependentSetNode(String id, List<DependentSetCriteria.AttributeComparison> expressions) {
        DependentSetCriteria crit = RuleChooseDependent.createDependentSetCriteria(id, expressions);
        PlanNode selectNode = RelationalPlanner.createSelectNode(crit, false);
        selectNode.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
        return selectNode;
    }

    static DependentSetCriteria createDependentSetCriteria(String id, List<DependentSetCriteria.AttributeComparison> expressions) {
        if (expressions.isEmpty()) {
            return null;
        }
        Expression indEx = null;
        Expression depEx = null;
        float maxNdv = -1.0f;
        float ndv = -1.0f;
        if (expressions.size() == 1) {
            DependentSetCriteria.AttributeComparison attributeComparison = expressions.get(0);
            indEx = attributeComparison.ind;
            depEx = attributeComparison.dep;
            maxNdv = attributeComparison.maxNdv;
            ndv = attributeComparison.ndv;
        } else {
            ArrayList<Expression> indExprs = new ArrayList<Expression>(expressions.size());
            ArrayList<Expression> depExprs = new ArrayList<Expression>(expressions.size());
            boolean unknown = false;
            for (DependentSetCriteria.AttributeComparison comp : expressions) {
                indExprs.add(comp.ind);
                depExprs.add(comp.dep);
                if (comp.ndv == -1.0f) {
                    ndv = -1.0f;
                    maxNdv = -1.0f;
                    unknown = true;
                    continue;
                }
                if (unknown) continue;
                ndv = Math.max(ndv, comp.ndv);
                maxNdv = Math.max(maxNdv, comp.maxNdv);
            }
            indEx = new Array(DataTypeManager.DefaultDataClasses.OBJECT, indExprs);
            depEx = new Array(DataTypeManager.DefaultDataClasses.OBJECT, depExprs);
        }
        DependentSetCriteria crit = new DependentSetCriteria(depEx, id);
        crit.setValueExpression(indEx);
        crit.setAttributes(expressions);
        crit.setMaxNdv(maxNdv);
        crit.setNdv(ndv);
        return crit;
    }

    public String toString() {
        return "ChooseDependent";
    }

    private static class CandidateJoin {
        PlanNode joinNode;
        boolean leftCandidate;
        boolean rightCandidate;

        private CandidateJoin() {
        }
    }
}

