/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.util.CommandContext;

public class RulePlanProcedures
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capabilitiesFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        for (PlanNode node : NodeEditor.findAllNodes(plan, 64, 1)) {
            StoredProcedure proc;
            if (!FrameUtil.isProcedure(node.getFirstChild()) || !(proc = (StoredProcedure)node.getProperty(NodeConstants.Info.NESTED_COMMAND)).isProcedureRelational()) continue;
            HashSet<ElementSymbol> inputSymbols = new HashSet<ElementSymbol>();
            LinkedList<Reference> inputReferences = new LinkedList<Reference>();
            PlanNode critNode = node.getParent();
            LinkedList<Criteria> conjuncts = new LinkedList<Criteria>();
            HashSet<ElementSymbol> coveredParams = new HashSet<ElementSymbol>();
            for (SPParameter param : proc.getInputParameters()) {
                ElementSymbol symbol = param.getParameterSymbol();
                Expression input = param.getExpression();
                inputReferences.add((Reference)input);
                inputSymbols.add(symbol);
            }
            this.findInputNodes(inputSymbols, critNode, conjuncts, coveredParams);
            LinkedList<Object> defaults = new LinkedList<Object>();
            for (Reference ref : inputReferences) {
                ElementSymbol symbol = ref.getExpression();
                Object defaultValue = null;
                defaults.add(defaultValue);
                if (defaultValue != null || coveredParams.contains(symbol)) continue;
                throw new QueryPlannerException((BundleUtil.Event)QueryPlugin.Event.TEIID30270, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30270, new Object[]{symbol}));
            }
            PlanNode accessNode = NodeEditor.findNodePreOrder(node, 1);
            Criteria crit = Criteria.combineCriteria(conjuncts);
            if (crit == null) continue;
            accessNode.setProperty(NodeConstants.Info.PROCEDURE_CRITERIA, crit);
            accessNode.setProperty(NodeConstants.Info.PROCEDURE_INPUTS, inputReferences);
            accessNode.setProperty(NodeConstants.Info.PROCEDURE_DEFAULTS, defaults);
            accessNode.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
        }
        return plan;
    }

    private void findInputNodes(final HashSet<ElementSymbol> inputs, PlanNode critNode, final List<Criteria> conjuncts, final Set<ElementSymbol> params) {
        while (critNode.getType() == 16) {
            final PlanNode currentNode = critNode;
            final Criteria crit = (Criteria)currentNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
            critNode = currentNode.getParent();
            if (!currentNode.getGroups().isEmpty()) continue;
            LanguageVisitor visitor = new LanguageVisitor(){

                @Override
                public void visit(CompareCriteria compCrit) {
                    if (compCrit.getOperator() == 1 && this.checkForInput(compCrit.getLeftExpression()) && !this.checkForAnyInput(compCrit.getRightExpression())) {
                        this.addInputNode((Reference)compCrit.getLeftExpression());
                    }
                }

                private void addInputNode(Reference param) {
                    params.add(param.getExpression());
                    conjuncts.add(crit);
                    NodeEditor.removeChildNode(currentNode.getParent(), currentNode);
                }

                @Override
                public void visit(IsNullCriteria isNull) {
                    if (!isNull.isNegated() && this.checkForInput(isNull.getExpression())) {
                        this.addInputNode((Reference)isNull.getExpression());
                    }
                }

                @Override
                public void visit(SetCriteria obj) {
                    if (!obj.isNegated() && this.checkForInput(obj.getExpression()) && !this.checkForAnyInput(obj.getValues())) {
                        this.addInputNode((Reference)obj.getExpression());
                    }
                }

                @Override
                public void visit(DependentSetCriteria obj) {
                    if (obj.isNegated()) {
                        return;
                    }
                    if (obj.hasMultipleAttributes()) {
                        for (DependentSetCriteria.AttributeComparison comp : obj.getAttributes()) {
                            if (this.checkForInput(comp.dep)) continue;
                            return;
                        }
                        for (DependentSetCriteria.AttributeComparison comp : obj.getAttributes()) {
                            params.add(((Reference)comp.dep).getExpression());
                        }
                        conjuncts.add(crit);
                        NodeEditor.removeChildNode(currentNode.getParent(), currentNode);
                    } else if (this.checkForInput(obj.getExpression())) {
                        this.addInputNode((Reference)obj.getExpression());
                    }
                }

                boolean checkForInput(Expression expr) {
                    if (!(expr instanceof Reference)) {
                        return false;
                    }
                    Reference ref = (Reference)expr;
                    return inputs.contains(ref.getExpression());
                }

                boolean checkForAnyInput(LanguageObject expr) {
                    for (Reference ref : ReferenceCollectorVisitor.getReferences(expr)) {
                        if (!this.checkForInput(ref)) continue;
                        return true;
                    }
                    return false;
                }

                boolean checkForAnyInput(Collection<Expression> expressions) {
                    for (Expression expr : expressions) {
                        if (!this.checkForAnyInput(expr)) continue;
                        return true;
                    }
                    return false;
                }
            };
            for (Criteria conjunct : Criteria.separateCriteriaByAnd(crit)) {
                conjunct.acceptVisitor(visitor);
            }
        }
    }

    public String toString() {
        return "PlanProcedures";
    }
}

