/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.Assertion;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleMergeVirtual;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.util.CommandContext;

public final class RuleRaiseNull
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        List<PlanNode> nodes = NodeEditor.findAllNodes(plan, 512);
        for (PlanNode nullNode : new LinkedList<PlanNode>(nodes)) {
            PlanNode newRoot;
            while (nullNode.getParent() != null && nodes.contains(nullNode) && (newRoot = this.raiseNullNode(plan, nodes, nullNode, metadata, capFinder)) != null) {
                plan = newRoot;
            }
            if (nullNode.getParent() != null) continue;
            nodes.remove(nullNode);
        }
        return plan;
    }

    PlanNode raiseNullNode(PlanNode rootNode, List<PlanNode> nodes, PlanNode nullNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        PlanNode parentNode = nullNode.getParent();
        switch (parentNode.getType()) {
            case 4: {
                JoinType jt = (JoinType)parentNode.getProperty(NodeConstants.Info.JOIN_TYPE);
                if (jt == JoinType.JOIN_CROSS || jt == JoinType.JOIN_INNER) {
                    return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
                }
                if (jt == JoinType.JOIN_LEFT_OUTER) {
                    if (nullNode == parentNode.getFirstChild()) {
                        return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
                    }
                    RuleRaiseNull.raiseNullThroughJoin(metadata, parentNode, parentNode.getLastChild());
                    return null;
                }
                if (jt == JoinType.JOIN_RIGHT_OUTER) {
                    if (nullNode == parentNode.getLastChild()) {
                        return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
                    }
                    RuleRaiseNull.raiseNullThroughJoin(metadata, parentNode, parentNode.getFirstChild());
                    return null;
                }
                if (jt != JoinType.JOIN_FULL_OUTER) break;
                if (nullNode == parentNode.getLastChild()) {
                    RuleRaiseNull.raiseNullThroughJoin(metadata, parentNode, parentNode.getLastChild());
                } else {
                    RuleRaiseNull.raiseNullThroughJoin(metadata, parentNode, parentNode.getFirstChild());
                }
                return null;
            }
            case 256: {
                boolean raiseOverSetOp;
                boolean isLeftChild = parentNode.getFirstChild() == nullNode;
                SetQuery.Operation operation = (SetQuery.Operation)((Object)parentNode.getProperty(NodeConstants.Info.SET_OPERATION));
                boolean bl = raiseOverSetOp = operation == SetQuery.Operation.INTERSECT || operation == SetQuery.Operation.EXCEPT && isLeftChild;
                if (raiseOverSetOp) {
                    return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
                }
                boolean isAll = parentNode.hasBooleanProperty(NodeConstants.Info.USE_ALL);
                if (isLeftChild) {
                    PlanNode sourceNode;
                    PlanNode firstProject = NodeEditor.findNodePreOrder(parentNode, 8);
                    if (firstProject == null) {
                        return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
                    }
                    List newProjectSymbols = (List)firstProject.getProperty(NodeConstants.Info.PROJECT_COLS);
                    List oldProjectSymbols = (List)nullNode.getProperty(NodeConstants.Info.PROJECT_COLS);
                    for (int i = 0; i < newProjectSymbols.size(); ++i) {
                        Expression newSes = (Expression)newProjectSymbols.get(i);
                        Expression oldSes = (Expression)oldProjectSymbols.get(i);
                        if (newSes instanceof Symbol && Symbol.getShortName(newSes).equals(Symbol.getShortName(oldSes))) continue;
                        if (newSes instanceof AliasSymbol) {
                            newSes = ((AliasSymbol)newSes).getSymbol();
                        }
                        newProjectSymbols.set(i, new AliasSymbol(Symbol.getShortName(oldSes), newSes));
                    }
                    PlanNode sort = NodeEditor.findParent(firstProject, 32, 64);
                    if (sort != null) {
                        OrderBy sortOrder = (OrderBy)sort.getProperty(NodeConstants.Info.SORT_ORDER);
                        for (OrderByItem item : sortOrder.getOrderByItems()) {
                            Expression sortElement = item.getSymbol();
                            sortElement = (Expression)newProjectSymbols.get(oldProjectSymbols.indexOf(sortElement));
                            item.setSymbol(sortElement);
                        }
                    }
                    if ((sourceNode = NodeEditor.findParent(parentNode, 64)) != null && NodeEditor.findNodePreOrder(sourceNode, 8) == firstProject) {
                        SymbolMap symbolMap = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
                        symbolMap = SymbolMap.createSymbolMap(symbolMap.getKeys(), newProjectSymbols);
                        sourceNode.setProperty(NodeConstants.Info.SYMBOL_MAP, symbolMap);
                    }
                }
                NodeEditor.removeChildNode(parentNode, nullNode);
                PlanNode grandParent = parentNode.getParent();
                if (!isAll) {
                    PlanNode nestedSetOp = NodeEditor.findNodePreOrder(parentNode.getFirstChild(), 256, 64);
                    if (nestedSetOp != null) {
                        nestedSetOp.setProperty(NodeConstants.Info.USE_ALL, false);
                    } else if (NodeEditor.findNodePreOrder(parentNode.getFirstChild(), 2, 64) == null) {
                        parentNode.getFirstChild().addAsParent(NodeFactory.getNewNode(2));
                    }
                }
                if (grandParent == null) {
                    PlanNode newRoot = parentNode.getFirstChild();
                    parentNode.removeChild(newRoot);
                    return newRoot;
                }
                NodeEditor.removeChildNode(grandParent, parentNode);
                PlanNode sourceNode = NodeEditor.findParent(grandParent.getFirstChild(), 64, 256);
                if (sourceNode != null) {
                    return RuleMergeVirtual.doMerge(sourceNode, rootNode, false, metadata, capFinder);
                }
                return null;
            }
            case 128: {
                if (!parentNode.hasCollectionProperty(NodeConstants.Info.GROUP_COLS)) break;
                return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
            }
            case 8: {
                PlanNode upperProject = NodeEditor.findParent(parentNode.getParent(), 8, 64);
                if (upperProject != null && upperProject.getProperty(NodeConstants.Info.INTO_GROUP) != null) break;
                return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
            }
            case 64: {
                PlanNode upperProject = parentNode.getParent();
                if (upperProject != null && upperProject.getType() == 8 && upperProject.hasProperty(NodeConstants.Info.INTO_GROUP)) break;
                return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
            }
            default: {
                return this.raiseNullNode(rootNode, parentNode, nullNode, nodes);
            }
        }
        return null;
    }

    private PlanNode raiseNullNode(PlanNode rootNode, PlanNode parentNode, PlanNode nullNode, List<PlanNode> nodes) {
        if (parentNode.getType() == 64) {
            nullNode.getGroups().clear();
        } else if (parentNode.getType() == 8) {
            nullNode.setProperty(NodeConstants.Info.PROJECT_COLS, parentNode.getProperty(NodeConstants.Info.PROJECT_COLS));
        }
        nullNode.addGroups(parentNode.getGroups());
        parentNode.removeChild(nullNode);
        nodes.removeAll(NodeEditor.findAllNodes(parentNode, 512));
        if (parentNode.getParent() != null) {
            parentNode.getParent().replaceChild(parentNode, nullNode);
        } else {
            rootNode = nullNode;
        }
        return rootNode;
    }

    static void raiseNullThroughJoin(QueryMetadataInterface metadata, PlanNode joinNode, PlanNode nullNode) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        Assertion.assertTrue((joinNode.getType() == 4 ? 1 : 0) != 0);
        Assertion.assertTrue((nullNode.getType() == 512 ? 1 : 0) != 0);
        Assertion.assertTrue((nullNode.getParent() == joinNode ? 1 : 0) != 0);
        PlanNode frameStart = joinNode.getParent();
        NodeEditor.removeChildNode(joinNode, nullNode);
        NodeEditor.removeChildNode(joinNode.getParent(), joinNode);
        for (GroupSymbol group : nullNode.getGroups()) {
            Map<ElementSymbol, Expression> nullSymbolMap = FrameUtil.buildSymbolMap(group, null, metadata);
            FrameUtil.convertFrame(frameStart, group, null, nullSymbolMap, metadata);
        }
    }

    public String toString() {
        return "RaiseNull";
    }
}

