/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class SetClauseList
implements LanguageObject {
    private static final long serialVersionUID = 8174681510498719451L;
    private List<SetClause> setClauses;

    public SetClauseList() {
        this.setClauses = new ArrayList<SetClause>();
    }

    public SetClauseList(List<SetClause> setClauses) {
        this.setClauses = setClauses;
    }

    public void addClause(ElementSymbol symbol, Expression expression) {
        this.setClauses.add(new SetClause(symbol, expression));
    }

    public void addClause(SetClause clause) {
        this.setClauses.add(clause);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    @Override
    public Object clone() {
        SetClauseList copy = new SetClauseList();
        for (SetClause clause : this.setClauses) {
            copy.addClause((SetClause)clause.clone());
        }
        return copy;
    }

    public LinkedHashMap<ElementSymbol, Expression> getClauseMap() {
        LinkedHashMap<ElementSymbol, Expression> result = new LinkedHashMap<ElementSymbol, Expression>();
        for (SetClause clause : this.setClauses) {
            result.put(clause.getSymbol(), clause.getValue());
        }
        return result;
    }

    public List<SetClause> getClauses() {
        return this.setClauses;
    }

    public boolean isEmpty() {
        return this.setClauses.isEmpty();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SetClauseList)) {
            return false;
        }
        SetClauseList other = (SetClauseList)obj;
        return this.setClauses.equals(other.setClauses);
    }

    public int hashCode() {
        return this.setClauses.hashCode();
    }
}

