/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.ObjectTable;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.ExceptionExpression;
import org.teiid.query.sql.proc.ReturnStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Array;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.symbol.WindowSpecification;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;

public class ExpressionMappingVisitor
extends LanguageVisitor {
    private Map symbolMap;
    private boolean clone = true;
    private boolean elementSymbolsOnly;

    public ExpressionMappingVisitor(Map symbolMap) {
        this.symbolMap = symbolMap;
    }

    public ExpressionMappingVisitor(Map symbolMap, boolean clone) {
        this.symbolMap = symbolMap;
        this.clone = clone;
    }

    protected boolean createAliases() {
        return true;
    }

    @Override
    public void visit(Select obj) {
        List<Expression> symbols = obj.getSymbols();
        for (int i = 0; i < symbols.size(); ++i) {
            Expression symbol = symbols.get(i);
            if (symbol instanceof MultipleElementSymbol) continue;
            Expression replacmentSymbol = this.replaceSymbol(symbol, true);
            symbols.set(i, replacmentSymbol);
        }
    }

    public boolean isClone() {
        return this.clone;
    }

    public void setClone(boolean clone) {
        this.clone = clone;
    }

    @Override
    public void visit(DerivedColumn obj) {
        Expression original = obj.getExpression();
        obj.setExpression(this.replaceExpression(original));
        if (obj.isPropagateName() && obj.getAlias() == null && !(obj.getExpression() instanceof ElementSymbol) && original instanceof ElementSymbol) {
            obj.setAlias(((ElementSymbol)original).getShortName());
        }
    }

    @Override
    public void visit(XMLTable obj) {
        for (XMLTable.XMLColumn col : obj.getColumns()) {
            Expression exp = col.getDefaultExpression();
            if (exp == null) continue;
            col.setDefaultExpression(this.replaceExpression(exp));
        }
    }

    @Override
    public void visit(ObjectTable obj) {
        for (ObjectTable.ObjectColumn col : obj.getColumns()) {
            Expression exp = col.getDefaultExpression();
            if (exp == null) continue;
            col.setDefaultExpression(this.replaceExpression(exp));
        }
    }

    @Override
    public void visit(XMLSerialize obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    @Override
    public void visit(XMLParse obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    private Expression replaceSymbol(Expression ses, boolean alias) {
        Expression replacmentSymbol;
        Expression expr = ses;
        String name = Symbol.getShortName(ses);
        if (ses instanceof ExpressionSymbol) {
            expr = ((ExpressionSymbol)ses).getExpression();
        }
        if (!((replacmentSymbol = this.replaceExpression(expr)) instanceof Symbol)) {
            replacmentSymbol = new ExpressionSymbol(name, replacmentSymbol);
        } else if (alias && this.createAliases() && !Symbol.getShortName(replacmentSymbol).equals(name)) {
            replacmentSymbol = new AliasSymbol(name, replacmentSymbol);
        }
        return replacmentSymbol;
    }

    @Override
    public void visit(AliasSymbol obj) {
        Expression replacement = this.replaceExpression(obj.getSymbol());
        obj.setSymbol(replacement);
    }

    @Override
    public void visit(ExpressionSymbol expr) {
        expr.setExpression(this.replaceExpression(expr.getExpression()));
    }

    @Override
    public void visit(BetweenCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        obj.setLowerExpression(this.replaceExpression(obj.getLowerExpression()));
        obj.setUpperExpression(this.replaceExpression(obj.getUpperExpression()));
    }

    @Override
    public void visit(CaseExpression obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> whens = new ArrayList<Expression>(whenCount);
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            whens.add(this.replaceExpression(obj.getWhenExpression(i)));
            thens.add(this.replaceExpression(obj.getThenExpression(i)));
        }
        obj.setWhen(whens, thens);
        if (obj.getElseExpression() != null) {
            obj.setElseExpression(this.replaceExpression(obj.getElseExpression()));
        }
    }

    @Override
    public void visit(CompareCriteria obj) {
        obj.setLeftExpression(this.replaceExpression(obj.getLeftExpression()));
        obj.setRightExpression(this.replaceExpression(obj.getRightExpression()));
    }

    @Override
    public void visit(Function obj) {
        Expression[] args = obj.getArgs();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.replaceExpression(args[i]);
            }
        }
    }

    @Override
    public void visit(IsNullCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    @Override
    public void visit(MatchCriteria obj) {
        obj.setLeftExpression(this.replaceExpression(obj.getLeftExpression()));
        obj.setRightExpression(this.replaceExpression(obj.getRightExpression()));
    }

    @Override
    public void visit(SearchedCaseExpression obj) {
        int whenCount = obj.getWhenCount();
        ArrayList<Expression> thens = new ArrayList<Expression>(whenCount);
        for (int i = 0; i < whenCount; ++i) {
            thens.add(this.replaceExpression(obj.getThenExpression(i)));
        }
        obj.setWhen(obj.getWhen(), thens);
        if (obj.getElseExpression() != null) {
            obj.setElseExpression(this.replaceExpression(obj.getElseExpression()));
        }
    }

    @Override
    public void visit(SetCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
        if (obj.isAllConstants()) {
            return;
        }
        ArrayList<Expression> newValues = new ArrayList<Expression>(obj.getValues().size());
        Iterator valueIter = obj.getValues().iterator();
        while (valueIter.hasNext()) {
            newValues.add(this.replaceExpression((Expression)valueIter.next()));
        }
        obj.setValues(newValues);
    }

    @Override
    public void visit(DependentSetCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        obj.setLeftExpression(this.replaceExpression(obj.getLeftExpression()));
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    public Expression replaceExpression(Expression element) {
        if (this.elementSymbolsOnly && !(element instanceof ElementSymbol)) {
            return element;
        }
        Expression mapped = (Expression)this.symbolMap.get(element);
        if (mapped != null) {
            if (this.clone) {
                return (Expression)mapped.clone();
            }
            return mapped;
        }
        return element;
    }

    @Override
    public void visit(StoredProcedure obj) {
        for (SPParameter param : obj.getInputParameters()) {
            Expression expr = param.getExpression();
            param.setExpression(this.replaceExpression(expr));
        }
    }

    @Override
    public void visit(AggregateSymbol obj) {
        this.visit((Function)obj);
        if (obj.getCondition() != null) {
            obj.setCondition(this.replaceExpression(obj.getCondition()));
        }
    }

    @Override
    public void visit(GroupBy obj) {
        List<Expression> symbols = obj.getSymbols();
        for (int i = 0; i < symbols.size(); ++i) {
            Expression symbol = symbols.get(i);
            symbols.set(i, this.replaceExpression(symbol));
        }
    }

    @Override
    public void visit(OrderByItem obj) {
        obj.setSymbol(this.replaceSymbol(obj.getSymbol(), obj.getExpressionPosition() != -1));
    }

    @Override
    public void visit(Limit obj) {
        if (obj.getOffset() != null) {
            obj.setOffset(this.replaceExpression(obj.getOffset()));
        }
        obj.setRowLimit(this.replaceExpression(obj.getRowLimit()));
    }

    @Override
    public void visit(DynamicCommand obj) {
        obj.setSql(this.replaceExpression(obj.getSql()));
        if (obj.getUsing() != null) {
            for (SetClause clause : obj.getUsing().getClauses()) {
                this.visit(clause);
            }
        }
    }

    @Override
    public void visit(SetClause obj) {
        obj.setValue(this.replaceExpression(obj.getValue()));
    }

    @Override
    public void visit(QueryString obj) {
        obj.setPath(this.replaceExpression(obj.getPath()));
    }

    @Override
    public void visit(ExpressionCriteria obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    public static void mapExpressions(LanguageObject obj, Map<? extends Expression, ? extends Expression> exprMap) {
        if (obj == null || exprMap == null || exprMap.isEmpty()) {
            return;
        }
        ExpressionMappingVisitor visitor = new ExpressionMappingVisitor(exprMap);
        visitor.elementSymbolsOnly = true;
        boolean preOrder = true;
        boolean useReverseMapping = true;
        for (Map.Entry<? extends Expression, ? extends Expression> entry : exprMap.entrySet()) {
            if (entry.getKey() instanceof ElementSymbol) continue;
            visitor.elementSymbolsOnly = false;
            break;
        }
        if (!visitor.elementSymbolsOnly) {
            for (Map.Entry<? extends Expression, ? extends Expression> entry : exprMap.entrySet()) {
                if (entry.getValue() instanceof ElementSymbol) continue;
                useReverseMapping = !Collections.disjoint(GroupsUsedByElementsVisitor.getGroups(exprMap.keySet()), GroupsUsedByElementsVisitor.getGroups(exprMap.values()));
                break;
            }
        } else {
            preOrder = false;
            useReverseMapping = false;
        }
        if (useReverseMapping) {
            final HashSet<? extends Expression> reverseSet = new HashSet<Expression>(exprMap.values());
            PreOrderNavigator pon = new PreOrderNavigator(visitor){

                @Override
                protected void visitNode(LanguageObject obj) {
                    if (!(obj instanceof Expression) || !reverseSet.contains(obj)) {
                        super.visitNode(obj);
                    }
                }
            };
            obj.acceptVisitor(pon);
        } else {
            PreOrPostOrderNavigator.doVisit(obj, visitor, preOrder, false);
        }
    }

    protected void setVariableValues(Map variableValues) {
        this.symbolMap = variableValues;
    }

    protected Map getVariableValues() {
        return this.symbolMap;
    }

    @Override
    public void visit(AssignmentStatement obj) {
        obj.setExpression(this.replaceExpression(obj.getExpression()));
    }

    @Override
    public void visit(Insert obj) {
        for (int i = 0; i < obj.getValues().size(); ++i) {
            obj.getValues().set(i, this.replaceExpression((Expression)obj.getValues().get(i)));
        }
    }

    @Override
    public void visit(XMLElement obj) {
        for (int i = 0; i < obj.getContent().size(); ++i) {
            obj.getContent().set(i, this.replaceExpression(obj.getContent().get(i)));
        }
    }

    @Override
    public void visit(WindowSpecification windowSpecification) {
        if (windowSpecification.getPartition() == null) {
            return;
        }
        List<Expression> partition = windowSpecification.getPartition();
        for (int i = 0; i < partition.size(); ++i) {
            partition.set(i, this.replaceExpression(partition.get(i)));
        }
    }

    @Override
    public void visit(Array array) {
        List<Expression> exprs = array.getExpressions();
        for (int i = 0; i < exprs.size(); ++i) {
            exprs.set(i, this.replaceExpression(exprs.get(i)));
        }
    }

    @Override
    public void visit(ExceptionExpression exceptionExpression) {
        if (exceptionExpression.getMessage() != null) {
            exceptionExpression.setMessage(this.replaceExpression(exceptionExpression.getMessage()));
        }
        if (exceptionExpression.getSqlState() != null) {
            exceptionExpression.setSqlState(this.replaceExpression(exceptionExpression.getSqlState()));
        }
        if (exceptionExpression.getErrorCode() != null) {
            exceptionExpression.setErrorCode(this.replaceExpression(exceptionExpression.getErrorCode()));
        }
        if (exceptionExpression.getParent() != null) {
            exceptionExpression.setParent(this.replaceExpression(exceptionExpression.getParent()));
        }
    }

    @Override
    public void visit(ReturnStatement obj) {
        if (obj.getExpression() != null) {
            obj.setExpression(this.replaceExpression(obj.getExpression()));
        }
    }
}

