/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.AdminObjectImpl;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.EntryMetaData;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.TeiidRuntimeException;

public class VDBMetaData
extends AdminObjectImpl
implements VDB,
Cloneable {
    private static final String VERSION_DELIM = ".";
    private static final long serialVersionUID = -4723595252013356436L;
    private LinkedHashMap<String, ModelMetaData> models = new LinkedHashMap();
    private LinkedHashMap<String, VDBTranslatorMetaData> translators = new LinkedHashMap();
    private LinkedHashMap<String, DataPolicyMetadata> dataPolicies = new LinkedHashMap();
    private List<VDBImportMetadata> imports = new ArrayList<VDBImportMetadata>(2);
    private List<EntryMetaData> entries = new ArrayList<EntryMetaData>(2);
    private int version = 1;
    private String description;
    private boolean xmlDeployment = false;
    private volatile VDB.Status status = VDB.Status.ACTIVE;
    private VDB.ConnectionType connectionType = VDB.ConnectionType.BY_VERSION;
    private long queryTimeout = Long.MIN_VALUE;
    private Set<String> importedModels = Collections.emptySet();

    public String getFullName() {
        return this.getName() + VERSION_DELIM + this.getVersion();
    }

    @Override
    public VDB.ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(VDB.ConnectionType allowConnections) {
        this.connectionType = allowConnections;
    }

    public void setConnectionType(String allowConnections) {
        this.connectionType = VDB.ConnectionType.valueOf(allowConnections);
    }

    @Override
    public VDB.Status getStatus() {
        return this.status;
    }

    public synchronized void setStatus(VDB.Status s) {
        this.notifyAll();
        this.status = s;
    }

    public void setStatus(String s) {
        this.setStatus(VDB.Status.valueOf(s));
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public List<Model> getModels() {
        return new ArrayList<Model>(this.models.values());
    }

    public LinkedHashMap<String, ModelMetaData> getModelMetaDatas() {
        return this.models;
    }

    public void setModels(Collection<ModelMetaData> models) {
        this.models.clear();
        for (ModelMetaData obj : models) {
            this.addModel(obj);
        }
    }

    public ModelMetaData addModel(ModelMetaData m) {
        return this.models.put(m.getName(), m);
    }

    @Override
    public List<Translator> getOverrideTranslators() {
        return new ArrayList<Translator>(this.translators.values());
    }

    public LinkedHashMap<String, VDBTranslatorMetaData> getOverrideTranslatorsMap() {
        return this.translators;
    }

    public void setOverrideTranslators(List<Translator> translators) {
        for (Translator t : translators) {
            this.translators.put(t.getName(), (VDBTranslatorMetaData)t);
        }
    }

    public void addOverideTranslator(VDBTranslatorMetaData t) {
        this.translators.put(t.getName(), t);
    }

    public boolean isOverideTranslator(String name) {
        return this.translators.containsKey(name);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public List<String> getValidityErrors() {
        ArrayList<String> allErrors = new ArrayList<String>();
        for (ModelMetaData model : this.models.values()) {
            List<ModelMetaData.Message> errors = model.getMessages();
            if (errors == null || errors.isEmpty()) continue;
            for (ModelMetaData.Message m : errors) {
                if (m.getSeverity() != ModelMetaData.Message.Severity.ERROR) continue;
                allErrors.add(m.getValue());
            }
        }
        return allErrors;
    }

    @Override
    public boolean isValid() {
        return this.status == VDB.Status.ACTIVE && !this.hasErrors();
    }

    public boolean hasErrors() {
        for (ModelMetaData model : this.models.values()) {
            if (!model.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getName() + VERSION_DELIM + this.getVersion() + this.models.values();
    }

    public boolean isVisible(String modelName) {
        ModelMetaData model = this.getModel(modelName);
        return model == null || model.isVisible();
    }

    public ModelMetaData getModel(String modelName) {
        return this.models.get(modelName);
    }

    public boolean isXmlDeployment() {
        return this.xmlDeployment;
    }

    public void setXmlDeployment(boolean dynamic) {
        this.xmlDeployment = dynamic;
    }

    @Override
    public List<DataPolicy> getDataPolicies() {
        return new ArrayList<DataPolicy>(this.dataPolicies.values());
    }

    public void setDataPolicies(List<DataPolicy> policies) {
        this.dataPolicies.clear();
        for (DataPolicy policy : policies) {
            this.dataPolicies.put(policy.getName(), (DataPolicyMetadata)policy);
        }
    }

    public DataPolicyMetadata addDataPolicy(DataPolicyMetadata policy) {
        return this.dataPolicies.put(policy.getName(), policy);
    }

    public LinkedHashMap<String, DataPolicyMetadata> getDataPolicyMap() {
        return this.dataPolicies;
    }

    public VDBTranslatorMetaData getTranslator(String name) {
        return this.translators.get(name);
    }

    public boolean isPreview() {
        return Boolean.valueOf(this.getPropertyValue("preview"));
    }

    public long getQueryTimeout() {
        if (this.queryTimeout == Long.MIN_VALUE) {
            String timeout = this.getPropertyValue("query-timeout");
            this.queryTimeout = timeout != null ? Math.max(0L, Long.parseLong(timeout)) : 0L;
        }
        return this.queryTimeout;
    }

    public List<VDBImportMetadata> getVDBImports() {
        return this.imports;
    }

    public Set<String> getImportedModels() {
        return this.importedModels;
    }

    public void setImportedModels(Set<String> importedModels) {
        this.importedModels = importedModels;
    }

    public List<EntryMetaData> getEntries() {
        return this.entries;
    }

    public void setEntries(List<EntryMetaData> entries) {
        this.entries = entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VDBMetaData clone() {
        try {
            VDBMetaData clone = (VDBMetaData)super.clone();
            clone.models = new LinkedHashMap<String, ModelMetaData>(this.models);
            Map map = this.attachments;
            synchronized (map) {
                clone.attachments = Collections.synchronizedMap(new LinkedHashMap(this.attachments));
            }
            clone.dataPolicies = new LinkedHashMap<String, DataPolicyMetadata>(this.dataPolicies);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }
}

