/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBRef;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import org.teiid.core.BundleUtil;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Expression;
import org.teiid.language.In;
import org.teiid.language.IsNull;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Literal;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.MongoDBPlugin;

public class ExpressionEvaluator
extends HierarchyVisitor {
    private BasicDBObject row;
    protected Stack<Boolean> match = new Stack();
    protected ArrayList<TranslatorException> exceptions = new ArrayList();

    public static boolean matches(Condition condition, BasicDBObject row) throws TranslatorException {
        ExpressionEvaluator evaluator = new ExpressionEvaluator(row);
        evaluator.append((LanguageObject)condition);
        if (!evaluator.exceptions.isEmpty()) {
            throw evaluator.exceptions.get(0);
        }
        try {
            return evaluator.match.pop();
        }
        catch (EmptyStackException e) {
            return true;
        }
    }

    private ExpressionEvaluator(BasicDBObject row) {
        this.row = row;
    }

    public void visit(Comparison obj) {
        try {
            Object o1 = this.getRowValue(obj.getLeftExpression());
            Object o2 = this.getLiteralValue(obj.getRightExpression());
            int compare = ((Comparable)o1).compareTo(o2);
            switch (obj.getOperator()) {
                case EQ: {
                    this.match.push(compare == 0);
                    break;
                }
                case NE: {
                    this.match.push(compare != 0);
                    break;
                }
                case LT: {
                    this.match.push(compare < 0);
                    break;
                }
                case LE: {
                    this.match.push(compare <= 0);
                    break;
                }
                case GT: {
                    this.match.push(compare > 0);
                    break;
                }
                case GE: {
                    this.match.push(compare >= 0);
                }
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    private Object getRowValue(Expression obj) throws TranslatorException {
        if (!(obj instanceof ColumnReference)) {
            throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18017, new Object[0]));
        }
        ColumnReference column = (ColumnReference)obj;
        Object value = this.row.get(column.getName());
        if (value instanceof DBRef) {
            value = ((DBRef)value).getId();
        }
        return value;
    }

    private Object getLiteralValue(Expression obj) throws TranslatorException {
        if (!(obj instanceof Literal)) {
            throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18018, new Object[0]));
        }
        Literal right = (Literal)obj;
        return right.getValue();
    }

    public void visit(AndOr obj) {
        this.append((LanguageObject)obj.getLeftCondition());
        this.append((LanguageObject)obj.getRightCondition());
        if (!this.exceptions.isEmpty()) {
            return;
        }
        boolean right = this.match.pop();
        boolean left = this.match.pop();
        switch (obj.getOperator()) {
            case AND: {
                this.match.push(right && left);
                break;
            }
            case OR: {
                this.match.push(right || left);
            }
        }
    }

    public void visit(In obj) {
        try {
            Object o1 = this.getRowValue(obj.getLeftExpression());
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < obj.getRightExpressions().size(); ++i) {
                values.add(this.getLiteralValue((Expression)obj.getRightExpressions().get(i)));
            }
            if (obj.isNegated()) {
                this.match.push(!values.contains(o1));
            } else {
                this.match.push(values.contains(o1));
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(IsNull obj) {
        try {
            Object o1 = this.getRowValue(obj.getExpression());
            if (obj.isNegated()) {
                this.match.push(o1 != null);
            } else {
                this.match.push(o1 == null);
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(Like obj) {
        try {
            Object o1 = this.getRowValue(obj.getLeftExpression());
            Object o2 = this.getLiteralValue(obj.getRightExpression());
            if (o1 instanceof String && o2 instanceof String) {
                String value = (String)o1;
                if (obj.isNegated()) {
                    this.match.push(!value.matches((String)o2));
                } else {
                    this.match.push(value.matches((String)o2));
                }
            } else {
                this.exceptions.add(new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18019, new Object[0])));
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void append(LanguageObject obj) {
        if (obj != null) {
            this.visitNode(obj);
        }
    }

    protected void append(List<? extends LanguageObject> items) {
        if (items != null && items.size() != 0) {
            this.append(items.get(0));
            for (int i = 1; i < items.size(); ++i) {
                this.append(items.get(i));
            }
        }
    }

    protected void append(LanguageObject[] items) {
        if (items != null && items.length != 0) {
            this.append(items[0]);
            for (int i = 1; i < items.length; ++i) {
                this.append(items[i]);
            }
        }
    }
}

