/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBRef;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.resource.cci.ConnectionFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.mongodb.MongoDBDirectQueryExecution;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDBQueryExecution;
import org.teiid.translator.mongodb.MongoDBUpdateExecution;

@Translator(name="mongodb", description="MongoDB Translator, reads and writes the data to MongoDB")
public class MongoDBExecutionFactory
extends ExecutionFactory<ConnectionFactory, MongoDBConnection> {
    protected Map<String, FunctionModifier> functionModifiers = new TreeMap<String, FunctionModifier>(String.CASE_INSENSITIVE_ORDER);

    public MongoDBExecutionFactory() {
        this.setSupportsOrderBy(true);
        this.setSupportsSelectDistinct(true);
        this.setSupportsNativeQueries(false);
        this.setSourceRequiredForMetadata(false);
        this.setSupportsOuterJoins(true);
        this.setSupportedJoinCriteria(ExecutionFactory.SupportedJoinCriteria.KEY);
        this.registerFunctionModifier("%", (FunctionModifier)new AliasModifier("$mod"));
        this.registerFunctionModifier("+", (FunctionModifier)new AliasModifier("$add"));
        this.registerFunctionModifier("-", (FunctionModifier)new AliasModifier("$subtract"));
        this.registerFunctionModifier("*", (FunctionModifier)new AliasModifier("$multiply"));
        this.registerFunctionModifier("/", (FunctionModifier)new AliasModifier("$divide"));
        this.registerFunctionModifier("concat", (FunctionModifier)new AliasModifier("$concat"));
        this.registerFunctionModifier("substring", (FunctionModifier)new AliasModifier("$substr"));
        this.registerFunctionModifier("lcase", (FunctionModifier)new AliasModifier("$toLower"));
        this.registerFunctionModifier("ucase", (FunctionModifier)new AliasModifier("$toUpper"));
        this.registerFunctionModifier("dayofyear", (FunctionModifier)new AliasModifier("$dayOfYear"));
        this.registerFunctionModifier("dayofmonth", (FunctionModifier)new AliasModifier("$dayOfMonth"));
        this.registerFunctionModifier("dayofweek", (FunctionModifier)new AliasModifier("$dayOfWeek"));
        this.registerFunctionModifier("year", (FunctionModifier)new AliasModifier("$year"));
        this.registerFunctionModifier("month", (FunctionModifier)new AliasModifier("$month"));
        this.registerFunctionModifier("week", (FunctionModifier)new AliasModifier("$week"));
        this.registerFunctionModifier("hour", (FunctionModifier)new AliasModifier("$hour"));
        this.registerFunctionModifier("minute", (FunctionModifier)new AliasModifier("$minute"));
        this.registerFunctionModifier("second", (FunctionModifier)new AliasModifier("$second"));
        this.registerFunctionModifier("ifnull", (FunctionModifier)new AliasModifier("$ifNull"));
    }

    public void start() throws TranslatorException {
        super.start();
    }

    public void registerFunctionModifier(String name, FunctionModifier modifier) {
        this.functionModifiers.put(name, modifier);
    }

    public Map<String, FunctionModifier> getFunctionModifiers() {
        return this.functionModifiers;
    }

    public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection) throws TranslatorException {
        return new MongoDBQueryExecution(this, command, executionContext, metadata, connection);
    }

    public ProcedureExecution createProcedureExecution(Call command, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection) throws TranslatorException {
        String nativeQuery = command.getMetadataObject().getProperty("{http://www.teiid.org/ext/relational/2012}native-query", false);
        if (nativeQuery != null) {
            return new MongoDBDirectQueryExecution(command.getArguments(), (Command)command, executionContext, metadata, connection, nativeQuery, false);
        }
        throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18011, new Object[0]));
    }

    public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection) throws TranslatorException {
        return new MongoDBUpdateExecution(this, command, executionContext, metadata, connection);
    }

    public ProcedureExecution createDirectExecution(List<Argument> arguments, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection) throws TranslatorException {
        return new MongoDBDirectQueryExecution(arguments.subList(1, arguments.size()), command, executionContext, metadata, connection, (String)arguments.get(0).getArgumentValue().getValue(), true);
    }

    public boolean useAnsiJoin() {
        return true;
    }

    public boolean supportsSelfJoins() {
        return true;
    }

    public boolean supportsCompareCriteriaEquals() {
        return true;
    }

    public boolean supportsCompareCriteriaOrdered() {
        return true;
    }

    public boolean supportsLikeCriteria() {
        return true;
    }

    public boolean supportsOrCriteria() {
        return true;
    }

    public boolean supportsOrderByUnrelated() {
        return true;
    }

    public boolean supportsGroupBy() {
        return true;
    }

    public boolean supportsHaving() {
        return true;
    }

    public boolean supportsAggregatesSum() {
        return true;
    }

    public boolean supportsAggregatesAvg() {
        return true;
    }

    public boolean supportsAggregatesMin() {
        return true;
    }

    public boolean supportsAggregatesMax() {
        return true;
    }

    public boolean supportsAggregatesCount() {
        return true;
    }

    public boolean supportsAggregatesCountStar() {
        return true;
    }

    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(this.getDefaultSupportedFunctions());
        supportedFunctions.add("mod");
        supportedFunctions.add("concat");
        supportedFunctions.add("substring");
        supportedFunctions.add("lcase");
        supportedFunctions.add("ucase");
        supportedFunctions.add("dayofyear");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("dayofweek");
        supportedFunctions.add("year");
        supportedFunctions.add("month");
        supportedFunctions.add("week");
        supportedFunctions.add("hour");
        supportedFunctions.add("minute");
        supportedFunctions.add("second");
        supportedFunctions.add("ifnull");
        return supportedFunctions;
    }

    public List<String> getDefaultSupportedFunctions() {
        return Arrays.asList("+", "-", "*", "/", "%");
    }

    public boolean supportsInCriteria() {
        return true;
    }

    public boolean supportsNotCriteria() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsIsNullCriteria() {
        return true;
    }

    public boolean supportsRowOffset() {
        return true;
    }

    public boolean supportsBulkUpdate() {
        return false;
    }

    public boolean supportsLikeRegex() {
        return true;
    }

    public boolean supportsSelectExpression() {
        return true;
    }

    public boolean supportsOnlyLiteralComparison() {
        return true;
    }

    public Object retrieveValue(Object value, Class<?> expectedClass, DB mongoDB, String fqn, String colName) {
        if (value == null) {
            return null;
        }
        if (value.getClass().equals(expectedClass)) {
            return value;
        }
        if (value instanceof DBRef) {
            Object obj = ((DBRef)value).getId();
            if (obj instanceof BasicDBObject) {
                BasicDBObject bdb = (BasicDBObject)obj;
                return bdb.get(colName);
            }
            return obj;
        }
        if (value instanceof java.util.Date && expectedClass.equals(Date.class)) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value instanceof java.util.Date && expectedClass.equals(Timestamp.class)) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof java.util.Date && expectedClass.equals(Time.class)) {
            return new Time(((java.util.Date)value).getTime());
        }
        if (value instanceof String && expectedClass.equals(BigDecimal.class)) {
            return new BigDecimal((String)value);
        }
        if (value instanceof String && expectedClass.equals(BigInteger.class)) {
            return new BigInteger((String)value);
        }
        if (value instanceof String && expectedClass.equals(Character.class)) {
            return new Character(((String)value).charAt(0));
        }
        if (value instanceof String && expectedClass.equals(Blob.class)) {
            GridFS gfs = new GridFS(mongoDB, fqn);
            final GridFSDBFile resource = gfs.findOne((String)value);
            if (resource == null) {
                return null;
            }
            return new BlobImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return resource.getInputStream();
                }
            });
        }
        if (value instanceof String && expectedClass.equals(Clob.class)) {
            GridFS gfs = new GridFS(mongoDB, fqn);
            final GridFSDBFile resource = gfs.findOne((String)value);
            if (resource == null) {
                return null;
            }
            return new ClobImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return resource.getInputStream();
                }
            }, -1L);
        }
        if (value instanceof String && expectedClass.equals(SQLXML.class)) {
            GridFS gfs = new GridFS(mongoDB, fqn);
            final GridFSDBFile resource = gfs.findOne((String)value);
            if (resource == null) {
                return null;
            }
            return new SQLXMLImpl(new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return resource.getInputStream();
                }
            });
        }
        return value;
    }

    public Object convertToMongoType(Object value, DB mongoDB, String fqn) throws TranslatorException {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toPlainString();
            }
            if (value instanceof BigInteger) {
                return ((BigInteger)value).toString();
            }
            if (value instanceof Character) {
                return ((Character)value).toString();
            }
            if (value instanceof Date) {
                return new java.util.Date(((Date)value).getTime());
            }
            if (value instanceof Time) {
                return new java.util.Date(((Time)value).getTime());
            }
            if (value instanceof Timestamp) {
                return new java.util.Date(((Timestamp)value).getTime());
            }
            if (value instanceof Blob) {
                String uuid = UUID.randomUUID().toString();
                GridFS gfs = new GridFS(mongoDB, fqn);
                GridFSInputFile gfsFile = gfs.createFile(((Blob)value).getBinaryStream());
                gfsFile.setFilename(uuid);
                gfsFile.save();
                return uuid;
            }
            if (value instanceof Clob) {
                String uuid = UUID.randomUUID().toString();
                GridFS gfs = new GridFS(mongoDB, fqn);
                GridFSInputFile gfsFile = gfs.createFile(((Clob)value).getAsciiStream());
                gfsFile.setFilename(uuid);
                gfsFile.save();
                return uuid;
            }
            if (value instanceof SQLXML) {
                String uuid = UUID.randomUUID().toString();
                GridFS gfs = new GridFS(mongoDB, fqn);
                GridFSInputFile gfsFile = gfs.createFile(((SQLXML)value).getBinaryStream());
                gfsFile.setFilename(uuid);
                gfsFile.save();
                return uuid;
            }
            return value;
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
    }
}

