/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.teiid.language.LanguageObject;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.logging.LogManager;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.MongoDBBaseExecution;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.MongoDBSelectVisitor;

public class MongoDBQueryExecution
extends MongoDBBaseExecution
implements ResultSetExecution {
    private Select command;
    private MongoDBExecutionFactory executionFactory;
    private Iterator<DBObject> results;
    private MongoDBSelectVisitor visitor;
    private Class<?>[] expectedTypes;

    public MongoDBQueryExecution(MongoDBExecutionFactory executionFactory, QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection) {
        super(executionContext, metadata, connection);
        this.command = (Select)command;
        this.executionFactory = executionFactory;
        this.expectedTypes = command.getColumnTypes();
    }

    public void execute() throws TranslatorException {
        this.visitor = new MongoDBSelectVisitor(this.executionFactory, this.metadata);
        this.visitor.visitNode((LanguageObject)this.command);
        if (!this.visitor.exceptions.isEmpty()) {
            throw this.visitor.exceptions.get(0);
        }
        LogManager.logInfo((String)"org.teiid.CONNECTOR", (Object)this.command);
        DBCollection collection = this.mongoDB.getCollection(this.visitor.mongoDoc.getTargetTable().getName());
        if (collection != null) {
            ArrayList<DBObject> ops = new ArrayList<DBObject>();
            if (this.visitor.projectBeforeMatch) {
                this.buildAggregate(ops, "$project", this.visitor.project);
            }
            if (!this.visitor.unwindTables.isEmpty()) {
                for (String ref : this.visitor.unwindTables) {
                    this.buildAggregate(ops, "$unwind", "$" + ref);
                }
            }
            this.buildAggregate(ops, "$match", this.visitor.match);
            this.buildAggregate(ops, "$group", this.visitor.group);
            this.buildAggregate(ops, "$match", this.visitor.having);
            if (!this.visitor.projectBeforeMatch) {
                this.buildAggregate(ops, "$project", this.visitor.project);
            }
            this.buildAggregate(ops, "$sort", this.visitor.sort);
            this.buildAggregate(ops, "$skip", this.visitor.skip);
            this.buildAggregate(ops, "$limit", this.visitor.limit);
            AggregationOutput output = collection.aggregate(ops.remove(0), ops.toArray(new DBObject[ops.size()]));
            this.results = output.results().iterator();
        }
    }

    private void buildAggregate(List<DBObject> query, String type, Object object) {
        if (object != null) {
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{type + ":" + object.toString()});
            query.add((DBObject)new BasicDBObject(type, object));
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        DBObject result;
        if (this.results != null && this.results.hasNext() && (result = this.results.next()) != null) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 0; i < this.visitor.selectColumns.size(); ++i) {
                row.add(this.executionFactory.retrieveValue(result.get(this.visitor.selectColumns.get(i)), this.expectedTypes[i], this.mongoDB, this.visitor.selectColumns.get(i), this.visitor.selectColumnReferences.get(i)));
            }
            return row;
        }
        return null;
    }

    public void close() {
        this.results = null;
    }

    public void cancel() throws TranslatorException {
        this.close();
    }
}

