/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.teiid.core.BundleUtil;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.GroupBy;
import org.teiid.language.In;
import org.teiid.language.IsNull;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.OrderBy;
import org.teiid.language.Select;
import org.teiid.language.SortSpecification;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.mongodb.ColumnAlias;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDocument;
import org.teiid.translator.mongodb.MutableDBRef;

public class MongoDBSelectVisitor
extends HierarchyVisitor {
    public static final String MERGE = "{http://www.teiid.org/translator/mongodb/2013}MERGE";
    public static final String EMBEDDABLE = "{http://www.teiid.org/translator/mongodb/2013}EMBEDDABLE";
    private AtomicInteger aliasCount = new AtomicInteger();
    protected MongoDBExecutionFactory executionFactory;
    protected RuntimeMetadata metadata;
    private Select command;
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    protected Stack<DBObject> onGoingPullCriteria = new Stack();
    protected Stack<Object> onGoingExpression = new Stack();
    protected ConcurrentHashMap<Object, ColumnAlias> expressionMap = new ConcurrentHashMap();
    private HashMap<String, BasicDBObject> groupByProjections = new HashMap();
    protected ColumnAlias onGoingAlias;
    protected MongoDocument mongoDoc;
    protected BasicDBObject project = new BasicDBObject();
    protected Integer limit;
    protected Integer skip;
    protected DBObject sort;
    protected DBObject match;
    protected DBObject having;
    protected BasicDBObject group = new BasicDBObject();
    protected ArrayList<String> selectColumns = new ArrayList();
    protected ArrayList<String> selectColumnReferences = new ArrayList();
    protected boolean projectBeforeMatch = false;
    protected LinkedList<String> unwindTables = new LinkedList();
    protected ArrayList<Condition> pendingConditions = new ArrayList();
    protected LinkedList<MongoDocument> joinedDocuments = new LinkedList();
    private boolean processingDerivedColumn = false;

    public MongoDBSelectVisitor(MongoDBExecutionFactory executionFactory, RuntimeMetadata metadata) {
        this.executionFactory = executionFactory;
        this.metadata = metadata;
    }

    public void append(LanguageObject obj) {
        if (obj != null) {
            this.visitNode(obj);
        }
    }

    protected void append(List<? extends LanguageObject> items) {
        if (items != null && items.size() != 0) {
            this.append(items.get(0));
            for (int i = 1; i < items.size(); ++i) {
                this.append(items.get(i));
            }
        }
    }

    protected void append(LanguageObject[] items) {
        if (items != null && items.length != 0) {
            this.append(items[0]);
            for (int i = 1; i < items.length; ++i) {
                this.append(items[i]);
            }
        }
    }

    public static String getRecordName(AbstractMetadataRecord object) {
        String nameInSource = object.getNameInSource();
        if (nameInSource != null && nameInSource.length() > 0) {
            return nameInSource;
        }
        return object.getName();
    }

    public String getColumnName(ColumnReference obj) {
        String elemShortName = null;
        Column elementID = obj.getMetadataObject();
        elemShortName = elementID != null ? MongoDBSelectVisitor.getRecordName((AbstractMetadataRecord)elementID) : obj.getName();
        return elemShortName;
    }

    public void visit(DerivedColumn obj) {
        this.onGoingAlias = this.buildAlias(obj.getAlias());
        Expression originalExpr = obj.getExpression();
        this.processingDerivedColumn = true;
        this.append((LanguageObject)originalExpr);
        this.processingDerivedColumn = false;
        Object expr = this.onGoingExpression.pop();
        ColumnAlias previousAlias = this.expressionMap.put(expr, this.onGoingAlias);
        if (previousAlias == null) {
            previousAlias = this.onGoingAlias;
        }
        if (originalExpr instanceof ColumnReference) {
            String elementName = this.getColumnName((ColumnReference)obj.getExpression());
            this.selectColumnReferences.add(elementName);
            BasicDBObject id = this.groupByProjections.get("_id");
            if (id == null) {
                if (this.command.isDistinct() || this.groupByProjections.get(previousAlias.projectedName) != null) {
                    this.project.append(this.onGoingAlias.projectedName, (Object)("$_id." + previousAlias.projectedName));
                    this.selectColumns.add(this.onGoingAlias.projectedName);
                    this.group.put(this.onGoingAlias.projectedName, expr);
                } else {
                    this.project.append(this.onGoingAlias.projectedName, expr);
                    this.selectColumns.add(this.onGoingAlias.projectedName);
                }
            } else {
                this.project.append(this.onGoingAlias.projectedName, id.get(previousAlias.projectedName));
                this.selectColumns.add(this.onGoingAlias.projectedName);
            }
        } else {
            if (originalExpr instanceof AggregateFunction) {
                ColumnAlias alias = this.addToProject(expr, false);
                if (!this.group.values().contains(expr)) {
                    this.group.put(alias.projectedName, expr);
                }
            } else if (originalExpr instanceof Function) {
                this.addToProject(expr, true);
            } else if (originalExpr instanceof Condition) {
                BasicDBList values = new BasicDBList();
                values.add(0, expr);
                values.add(1, (Object)true);
                values.add(2, (Object)false);
                this.addToProject(new BasicDBObject("$cond", (Object)values), true);
            }
            this.selectColumns.add(previousAlias.projectedName);
            this.selectColumnReferences.add(previousAlias.projectedName);
        }
        this.onGoingAlias = null;
    }

    private ColumnAlias buildAlias(String alias) {
        if (alias == null) {
            String str = "_m" + this.aliasCount.getAndIncrement();
            return new ColumnAlias(str, str, str, str, null);
        }
        return new ColumnAlias(alias, alias, alias, alias, null);
    }

    public void visit(ColumnReference obj) {
        block18: {
            try {
                String elementName = this.getColumnName(obj);
                if (obj.getMetadataObject() == null) {
                    for (Object expr : this.expressionMap.keySet()) {
                        ColumnAlias alias = this.expressionMap.get(expr);
                        if (!alias.projectedName.equals(elementName)) continue;
                        this.onGoingExpression.push(expr);
                        break block18;
                    }
                    break block18;
                }
                String selectionName = elementName;
                String columnName = obj.getMetadataObject().getName();
                String pullColumnName = obj.getMetadataObject().getName();
                MongoDocument columnDocument = this.getDocument(obj.getTable().getMetadataObject());
                MongoDocument targetDocument = this.mongoDoc.getTargetDocument();
                String tableName = null;
                if (columnDocument.equals(targetDocument)) {
                    if (columnDocument.isPartOfPrimaryKey(columnName)) {
                        if (columnDocument.hasCompositePrimaryKey()) {
                            selectionName = elementName = "_id." + columnName;
                            pullColumnName = "_id." + columnName;
                        } else {
                            selectionName = elementName = "_id";
                            pullColumnName = "_id";
                        }
                    }
                    if (columnDocument.isPartOfForeignKey(columnName)) {
                        selectionName = elementName + ".$id";
                        if (columnDocument.isMultiKeyForeignKey(columnName)) {
                            selectionName = selectionName + "." + columnName;
                        }
                        pullColumnName = columnName + ".$id";
                    }
                } else if (targetDocument.embeds(columnDocument)) {
                    MutableDBRef ref = targetDocument.getEmbeddedDocumentReferenceKey(columnDocument);
                    elementName = ref.getName() + "." + columnName;
                    tableName = columnDocument.getTable().getName();
                    if (columnDocument.isPartOfPrimaryKey(columnName)) {
                        if (columnDocument.hasCompositePrimaryKey()) {
                            selectionName = elementName = ref.getName() + "." + "_id." + columnName;
                            pullColumnName = "_id." + columnName;
                        } else {
                            selectionName = elementName = ref.getName() + "." + "_id";
                            pullColumnName = "_id";
                        }
                    }
                    if (columnDocument.isPartOfForeignKey(columnName)) {
                        selectionName = elementName + ".$id";
                        if (columnDocument.isMultiKeyForeignKey(columnName)) {
                            selectionName = selectionName + "." + columnName;
                        }
                        pullColumnName = columnName + ".$id";
                    }
                }
                String mongoExpr = "$" + elementName;
                this.onGoingExpression.push(mongoExpr);
                if (this.onGoingAlias == null) {
                    this.expressionMap.putIfAbsent(mongoExpr, new ColumnAlias(elementName, selectionName, columnName, pullColumnName, tableName));
                }
            }
            catch (TranslatorException e) {
                this.exceptions.add(e);
                return;
            }
        }
    }

    private MongoDocument getDocument(Table table) {
        if (this.mongoDoc != null && this.mongoDoc.getTable().getName().equals(table.getName())) {
            return this.mongoDoc;
        }
        for (MongoDocument doc : this.joinedDocuments) {
            if (!doc.getTable().getName().equals(table.getName())) continue;
            return doc;
        }
        return null;
    }

    public void visit(AggregateFunction obj) {
        if (!obj.getParameters().isEmpty()) {
            this.append(obj.getParameters());
        } else {
            this.onGoingExpression.push(new Integer(1));
            this.group.put("_id", null);
        }
        BasicDBObject expr = null;
        if (obj.getName().equals("COUNT")) {
            expr = new BasicDBObject("$sum", this.onGoingExpression.pop());
        } else if (obj.getName().equals("AVG")) {
            expr = new BasicDBObject("$avg", this.onGoingExpression.pop());
        } else if (obj.getName().equals("SUM")) {
            expr = new BasicDBObject("$sum", this.onGoingExpression.pop());
        } else if (obj.getName().equals("MIN")) {
            expr = new BasicDBObject("$min", this.onGoingExpression.pop());
        } else if (obj.getName().equals("MAX")) {
            expr = new BasicDBObject("$max", this.onGoingExpression.pop());
        } else {
            this.exceptions.add(new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18005, new Object[]{obj.getName()})));
        }
        if (expr != null) {
            this.onGoingExpression.push(expr);
        }
    }

    private ColumnAlias addToProject(Object expr, boolean addExprAsProject) {
        ColumnAlias previousAlias = this.expressionMap.get(expr);
        if (previousAlias == null) {
            previousAlias = this.onGoingAlias;
            if (this.onGoingAlias == null) {
                this.projectBeforeMatch = true;
                previousAlias = this.buildAlias(null);
            }
            this.expressionMap.putIfAbsent(expr, previousAlias);
        }
        if (this.project.get(previousAlias.projectedName) == null && !this.project.values().contains(expr)) {
            this.project.append(previousAlias.projectedName, addExprAsProject ? expr : Integer.valueOf(1));
        }
        return previousAlias;
    }

    public void visit(Function obj) {
        if (this.executionFactory.getFunctionModifiers().containsKey(obj.getName())) {
            this.executionFactory.getFunctionModifiers().get(obj.getName()).translate(obj);
        }
        BasicDBObject expr = null;
        List args = obj.getParameters();
        if (args != null) {
            BasicDBList params = new BasicDBList();
            for (int i = 0; i < args.size(); ++i) {
                this.append((LanguageObject)args.get(i));
                Object param = this.onGoingExpression.pop();
                params.add(param);
            }
            expr = new BasicDBObject(obj.getName(), (Object)params);
        }
        if (expr != null) {
            this.onGoingExpression.push(expr);
        }
    }

    public void visit(NamedTable obj) {
        try {
            this.mongoDoc = new MongoDocument(obj.getMetadataObject(), this.metadata);
            this.configureUnwind(this.mongoDoc, null);
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(Join obj) {
        try {
            if (obj.getLeftItem() instanceof Join) {
                this.append((LanguageObject)obj.getLeftItem());
                Table right = ((NamedTable)obj.getRightItem()).getMetadataObject();
                this.processJoin(this.mongoDoc, new MongoDocument(right, this.metadata), obj.getCondition());
            } else {
                Table left = ((NamedTable)obj.getLeftItem()).getMetadataObject();
                Table right = ((NamedTable)obj.getRightItem()).getMetadataObject();
                this.processJoin(new MongoDocument(left, this.metadata), new MongoDocument(right, this.metadata), obj.getCondition());
            }
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    private void configureUnwind(MongoDocument doc, String child) throws TranslatorException {
        if (doc.isMerged()) {
            MongoDocument mergeDoc = doc.getMergeDocument();
            if (mergeDoc.isMerged()) {
                this.configureUnwind(mergeDoc, doc.getTable().getName());
            } else if (doc.getMergeAssosiation() == MutableDBRef.Assosiation.MANY) {
                if (child == null) {
                    this.unwindTables.addFirst(doc.getMergeKey().getName());
                } else {
                    this.unwindTables.addFirst(doc.getMergeKey().getName() + "." + child);
                    this.unwindTables.addFirst(doc.getMergeKey().getName());
                }
            }
        }
    }

    private void processJoin(MongoDocument left, MongoDocument right, Condition cond) throws TranslatorException {
        if (left.embeds(right)) {
            this.mongoDoc = left;
            this.joinedDocuments.add(right);
            this.configureUnwind(right, null);
        } else if (right.embeds(left)) {
            this.mongoDoc = right;
            this.joinedDocuments.add(right);
            this.configureUnwind(right, null);
        } else {
            if (this.mongoDoc != null) {
                for (MongoDocument child : this.joinedDocuments) {
                    if (!child.embeds(right)) continue;
                    this.joinedDocuments.add(right);
                    this.configureUnwind(right, null);
                    return;
                }
            }
            throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18012, new Object[]{left.getTable().getName(), right.getTable().getName()}));
        }
        if (cond != null) {
            this.pendingConditions.add(cond);
        }
    }

    public void visit(Select obj) {
        this.command = obj;
        if (obj.getFrom() != null && !obj.getFrom().isEmpty()) {
            this.append(obj.getFrom());
        }
        if (!this.exceptions.isEmpty()) {
            return;
        }
        if (obj.getWhere() != null) {
            this.append((LanguageObject)obj.getWhere());
        }
        if (!this.onGoingExpression.isEmpty()) {
            this.match = this.match != null ? QueryBuilder.start().and(new DBObject[]{this.match, (DBObject)this.onGoingExpression.pop()}).get() : (DBObject)this.onGoingExpression.pop();
        }
        if (obj.getGroupBy() != null) {
            this.append((LanguageObject)obj.getGroupBy());
        }
        this.append(obj.getDerivedColumns());
        if (obj.getGroupBy() == null && obj.isDistinct() && !this.group.containsField("_id")) {
            BasicDBObject id = new BasicDBObject((Map)this.group);
            this.group.clear();
            this.group.put("_id", (Object)id);
        }
        if (obj.getHaving() != null) {
            this.append((LanguageObject)obj.getHaving());
        }
        if (!this.onGoingExpression.isEmpty()) {
            this.having = (DBObject)this.onGoingExpression.pop();
        }
        if (!this.group.isEmpty()) {
            if (this.group.get("_id") == null) {
                this.group.put("_id", null);
            }
        } else {
            this.group = null;
        }
        if (obj.getOrderBy() != null) {
            this.append((LanguageObject)obj.getOrderBy());
        }
        if (obj.getLimit() != null) {
            this.append((LanguageObject)obj.getLimit());
        }
    }

    public void visit(Comparison obj) {
        if (this.processingDerivedColumn) {
            this.visitDerivedExpression(obj);
            return;
        }
        ColumnAlias exprAlias = this.getExpressionAlias(obj.getLeftExpression());
        this.append((LanguageObject)obj.getRightExpression());
        Object rightExpr = this.onGoingExpression.pop();
        if (this.expressionMap.get(rightExpr) != null) {
            rightExpr = this.expressionMap.get((Object)rightExpr).projectedName;
        }
        QueryBuilder query = QueryBuilder.start((String)exprAlias.selectionName);
        QueryBuilder pullQuery = QueryBuilder.start((String)exprAlias.pullColumnName);
        switch (obj.getOperator()) {
            case EQ: {
                query.is(rightExpr);
                pullQuery.is(rightExpr);
                break;
            }
            case NE: {
                query.notEquals(rightExpr);
                pullQuery.notEquals(rightExpr);
                break;
            }
            case LT: {
                query.lessThan(rightExpr);
                pullQuery.lessThan(rightExpr);
                break;
            }
            case LE: {
                query.lessThanEquals(rightExpr);
                pullQuery.lessThanEquals(rightExpr);
                break;
            }
            case GT: {
                query.greaterThan(rightExpr);
                pullQuery.greaterThan(rightExpr);
                break;
            }
            case GE: {
                query.greaterThanEquals(rightExpr);
                pullQuery.greaterThanEquals(rightExpr);
            }
        }
        this.onGoingExpression.push(query.get());
        if (obj.getLeftExpression() instanceof ColumnReference) {
            ColumnReference colum = (ColumnReference)obj.getLeftExpression();
            this.mongoDoc.updateReferenceColumnValue(colum.getTable().getName(), exprAlias.columnName, rightExpr);
        }
        this.onGoingPullCriteria.push(pullQuery.get());
    }

    private void visitDerivedExpression(Comparison obj) {
        this.append((LanguageObject)obj.getLeftExpression());
        Object leftExpr = this.onGoingExpression.pop();
        this.append((LanguageObject)obj.getRightExpression());
        Object rightExpr = this.onGoingExpression.pop();
        BasicDBList values = new BasicDBList();
        values.add(0, leftExpr);
        values.add(1, rightExpr);
        switch (obj.getOperator()) {
            case EQ: {
                this.onGoingExpression.push(new BasicDBObject("$eq", (Object)values));
                this.onGoingPullCriteria.push((DBObject)new BasicDBObject("$eq", (Object)values));
                break;
            }
            case NE: {
                this.onGoingExpression.push(new BasicDBObject("$ne", (Object)values));
                this.onGoingPullCriteria.push((DBObject)new BasicDBObject("$ne", (Object)values));
                break;
            }
            case LT: {
                this.onGoingExpression.push(new BasicDBObject("$lt", (Object)values));
                this.onGoingPullCriteria.push((DBObject)new BasicDBObject("$lt", (Object)values));
                break;
            }
            case LE: {
                this.onGoingExpression.push(new BasicDBObject("$lte", (Object)values));
                this.onGoingPullCriteria.push((DBObject)new BasicDBObject("$lte", (Object)values));
                break;
            }
            case GT: {
                this.onGoingExpression.push(new BasicDBObject("$gt", (Object)values));
                this.onGoingPullCriteria.push((DBObject)new BasicDBObject("$gt", (Object)values));
                break;
            }
            case GE: {
                this.onGoingExpression.push(new BasicDBObject("$gte", (Object)values));
                this.onGoingPullCriteria.push((DBObject)new BasicDBObject("$gte", (Object)values));
            }
        }
    }

    public void visit(AndOr obj) {
        this.append((LanguageObject)obj.getLeftCondition());
        this.append((LanguageObject)obj.getRightCondition());
        DBObject right = (DBObject)this.onGoingExpression.pop();
        DBObject left = (DBObject)this.onGoingExpression.pop();
        DBObject pullRight = this.onGoingPullCriteria.pop();
        DBObject pullLeft = this.onGoingPullCriteria.pop();
        switch (obj.getOperator()) {
            case AND: {
                this.onGoingExpression.push(QueryBuilder.start().and(new DBObject[]{left, right}).get());
                this.onGoingPullCriteria.push(QueryBuilder.start().and(new DBObject[]{pullLeft, pullRight}).get());
                break;
            }
            case OR: {
                this.onGoingExpression.push(QueryBuilder.start().or(new DBObject[]{left, right}).get());
                this.onGoingPullCriteria.push(QueryBuilder.start().or(new DBObject[]{pullLeft, pullRight}).get());
            }
        }
    }

    public void visit(Literal obj) {
        try {
            this.onGoingExpression.push(this.executionFactory.convertToMongoType(obj.getValue(), null, null));
        }
        catch (TranslatorException e) {
            this.exceptions.add(e);
        }
    }

    public void visit(In obj) {
        ColumnAlias exprAlias = this.getExpressionAlias(obj.getLeftExpression());
        QueryBuilder query = QueryBuilder.start((String)exprAlias.selectionName);
        QueryBuilder pullQuery = QueryBuilder.start((String)exprAlias.pullColumnName);
        this.append(obj.getRightExpressions());
        BasicDBList values = new BasicDBList();
        for (int i = 0; i < obj.getRightExpressions().size(); ++i) {
            values.add(0, this.onGoingExpression.pop());
        }
        if (query != null) {
            if (obj.isNegated()) {
                query.notIn((Object)values);
                pullQuery.notIn((Object)values);
            } else {
                query.in((Object)values);
                pullQuery.in((Object)values);
            }
            this.onGoingExpression.push(query.get());
            this.onGoingPullCriteria.push(pullQuery.get());
        }
    }

    private ColumnAlias getExpressionAlias(Expression obj) {
        this.append((LanguageObject)obj);
        Object expr = this.onGoingExpression.pop();
        ColumnAlias exprAlias = this.expressionMap.get(expr);
        if (exprAlias == null) {
            exprAlias = this.buildAlias(null);
            this.expressionMap.put(expr, exprAlias);
        }
        return exprAlias;
    }

    public void visit(IsNull obj) {
        ColumnAlias exprAlias = this.getExpressionAlias(obj.getExpression());
        QueryBuilder query = QueryBuilder.start((String)exprAlias.selectionName);
        QueryBuilder pullQuery = QueryBuilder.start((String)exprAlias.pullColumnName);
        if (query != null) {
            if (obj.isNegated()) {
                query.notEquals(null);
                pullQuery.notEquals(null);
            } else {
                query.is(null);
                pullQuery.is(null);
            }
            this.onGoingExpression.push(query.get());
            this.onGoingPullCriteria.push(pullQuery.get());
        }
    }

    public void visit(Like obj) {
        ColumnAlias exprAlias = this.getExpressionAlias(obj.getLeftExpression());
        QueryBuilder query = QueryBuilder.start((String)exprAlias.selectionName);
        QueryBuilder pullQuery = QueryBuilder.start((String)exprAlias.pullColumnName);
        if (query != null) {
            if (obj.isNegated()) {
                query.not();
                pullQuery.not();
            }
            this.append((LanguageObject)obj.getRightExpression());
            StringBuilder value = new StringBuilder((String)this.onGoingExpression.pop());
            int idx = -1;
            while (true) {
                if ((idx = value.indexOf("%", idx + 1)) != -1 && idx == 0 || idx != -1 && idx == value.length() - 1) {
                    continue;
                }
                if (idx == -1) break;
                value.replace(idx, idx + 1, ".*");
            }
            if (value.charAt(0) != '%') {
                value.insert(0, '^');
            }
            if (value.charAt((idx = value.length()) - 1) != '%') {
                value.insert(idx, '$');
            }
            String regex = value.toString().replaceAll("%", "");
            query.is((Object)Pattern.compile(regex));
            pullQuery.is((Object)Pattern.compile(regex));
            this.onGoingExpression.push(query.get());
            this.onGoingPullCriteria.push(pullQuery.get());
        }
    }

    public void visit(Limit obj) {
        this.limit = new Integer(obj.getRowLimit());
        this.skip = new Integer(obj.getRowOffset());
    }

    public void visit(OrderBy obj) {
        this.append(obj.getSortSpecifications());
    }

    public void visit(SortSpecification obj) {
        this.append((LanguageObject)obj.getExpression());
        Object expr = this.onGoingExpression.pop();
        ColumnAlias alias = this.expressionMap.get(expr);
        if (this.sort == null) {
            this.sort = new BasicDBObject(alias.projectedName, (Object)(obj.getOrdering() == SortSpecification.Ordering.ASC ? 1 : -1));
        } else {
            this.sort.put(alias.projectedName, (Object)(obj.getOrdering() == SortSpecification.Ordering.ASC ? 1 : -1));
        }
    }

    public void visit(GroupBy obj) {
        if (obj.getElements().size() == 1) {
            this.append((LanguageObject)obj.getElements().get(0));
            Object mongoExpr = this.onGoingExpression.pop();
            ColumnAlias alias = this.expressionMap.get(mongoExpr);
            this.group.put("_id", mongoExpr);
            this.groupByProjections.put("_id", new BasicDBObject(alias.projectedName, (Object)"$_id"));
        } else {
            BasicDBObject fields = new BasicDBObject();
            BasicDBObject exprs = new BasicDBObject();
            for (Expression expr : obj.getElements()) {
                this.append((LanguageObject)expr);
                Object mongoExpr = this.onGoingExpression.pop();
                ColumnAlias alias = this.expressionMap.get(mongoExpr);
                exprs.put(alias.projectedName, mongoExpr);
                fields.put(alias.projectedName, (Object)("$_id." + alias.projectedName));
            }
            this.group.put("_id", (Object)exprs);
            this.groupByProjections.put("_id", fields);
        }
    }

    static boolean isPartOfPrimaryKey(Table table, String columnName) {
        KeyRecord pk = table.getPrimaryKey();
        if (pk != null) {
            for (Column column : pk.getColumns()) {
                if (!MongoDBSelectVisitor.getRecordName((AbstractMetadataRecord)column).equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    boolean hasCompositePrimaryKey(Table table) {
        KeyRecord pk = table.getPrimaryKey();
        return pk.getColumns().size() > 1;
    }

    static boolean isPartOfForeignKey(Table table, String columnName) {
        for (ForeignKey fk : table.getForeignKeys()) {
            for (Column column : fk.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    static String getForeignKeyRefTable(Table table, String columnName) {
        for (ForeignKey fk : table.getForeignKeys()) {
            for (Column column : fk.getColumns()) {
                if (!column.getName().equals(columnName)) continue;
                return fk.getReferenceTableName();
            }
        }
        return null;
    }

    static List<String> getColumnNames(List<Column> columns) {
        ArrayList<String> names = new ArrayList<String>();
        for (Column c : columns) {
            names.add(c.getName());
        }
        return names;
    }
}

