/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.mongodb;

import com.mongodb.AggregationOutput;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.teiid.GeneratedKeys;
import org.teiid.core.BundleUtil;
import org.teiid.language.Command;
import org.teiid.language.Insert;
import org.teiid.language.LanguageObject;
import org.teiid.language.Update;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.mongodb.MongoDBConnection;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.translator.mongodb.MongoDBBaseExecution;
import org.teiid.translator.mongodb.MongoDBExecutionFactory;
import org.teiid.translator.mongodb.MongoDBPlugin;
import org.teiid.translator.mongodb.MongoDBSelectVisitor;
import org.teiid.translator.mongodb.MongoDBUpdateVisitor;
import org.teiid.translator.mongodb.MongoDocument;
import org.teiid.translator.mongodb.MutableDBRef;

public class MongoDBUpdateExecution
extends MongoDBBaseExecution
implements UpdateExecution {
    private Command command;
    private MongoDBUpdateVisitor visitor;
    private MongoDBExecutionFactory executionFactory;
    private int[] results;

    public MongoDBUpdateExecution(MongoDBExecutionFactory executionFactory, Command command, ExecutionContext executionContext, RuntimeMetadata metadata, MongoDBConnection connection) throws TranslatorException {
        super(executionContext, metadata, connection);
        this.command = command;
        this.visitor = new MongoDBUpdateVisitor(executionFactory, metadata, this.mongoDB);
        this.visitor.visitNode((LanguageObject)command);
        if (!this.visitor.exceptions.isEmpty()) {
            throw (TranslatorException)((Object)this.visitor.exceptions.get(0));
        }
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    public void execute() throws TranslatorException {
        DBCollection collection = this.getCollection(this.visitor.mongoDoc.getTargetTable());
        MongoDocument mongoDoc = this.visitor.mongoDoc;
        WriteResult result = null;
        if (this.command instanceof Insert) {
            Object[] mergeInfo;
            LinkedHashMap<String, DBObject> embeddedDocuments = this.fetchEmbeddedDocuments();
            result = mongoDoc.isMerged() ? ((mergeInfo = mongoDoc.getMergeParentCriteria(this.mongoDB, null, null, this.visitor.getInsert(this.mongoDB, embeddedDocuments), false))[2] == MutableDBRef.Assosiation.MANY ? collection.update((DBObject)mergeInfo[0], (DBObject)new BasicDBObject("$push", mergeInfo[1]), false, true, WriteConcern.ACKNOWLEDGED) : collection.update((DBObject)mergeInfo[0], (DBObject)new BasicDBObject("$set", mergeInfo[1]), false, true, WriteConcern.ACKNOWLEDGED)) : collection.insert((DBObject)this.visitor.getInsert(this.mongoDB, embeddedDocuments), WriteConcern.ACKNOWLEDGED);
        } else if (this.command instanceof Update) {
            LinkedHashMap<String, DBObject> embeddedDocuments = this.fetchEmbeddedDocuments();
            BasicDBObject match = new BasicDBObject();
            if (this.visitor.match != null) {
                match = this.visitor.match;
            }
            if (mongoDoc.isMerged()) {
                Object[] mergeInfo = mongoDoc.getMergeParentCriteria(this.mongoDB, null, null, this.visitor.getUpdate(this.mongoDB, embeddedDocuments), false);
                boolean nested = (Boolean)mergeInfo[3];
                if (nested) {
                    throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18016, new Object[0]));
                }
                for (DBObject row : collection.aggregate((DBObject)new BasicDBObject("$match", (Object)match), new DBObject[0]).results()) {
                    BasicDBList previousMerge = (BasicDBList)row.get(mongoDoc.getTable().getName());
                    BasicDBList updatedDoc = this.visitor.updateMerge(this.mongoDB, previousMerge);
                    if (updatedDoc.size() == 0) continue;
                    result = collection.update((DBObject)new BasicDBObject("_id", row.get("_id")), (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject(mongoDoc.getTable().getName(), (Object)updatedDoc)), false, true, WriteConcern.ACKNOWLEDGED);
                }
            } else {
                result = collection.update((DBObject)match, (DBObject)new BasicDBObject("$set", (Object)this.visitor.getUpdate(this.mongoDB, embeddedDocuments)), false, true, WriteConcern.ACKNOWLEDGED);
            }
            if (mongoDoc.isEmbeddable() && result.getError() == null) {
                this.updateReferenceTables(collection, mongoDoc, (DBObject)match);
            }
        } else {
            BasicDBObject match = new BasicDBObject();
            if (this.visitor.match != null) {
                match = this.visitor.match;
            }
            if (mongoDoc.isEmbeddable()) {
                AggregationOutput output = collection.aggregate((DBObject)new BasicDBObject("$match", (Object)match), new DBObject[0]);
                for (DBObject row : output.results()) {
                    if (row == null) continue;
                    for (MutableDBRef ref : mongoDoc.getEmbeddedInReferences()) {
                        DBCollection parent = this.getCollection(ref.getParentTable());
                        AggregationOutput referenceOutput = parent.aggregate((DBObject)new BasicDBObject("$match", (Object)new BasicDBObject(ref.getReferenceName() + ".$id", row.get("_id"))), new DBObject[0]);
                        if (!referenceOutput.results().iterator().hasNext()) continue;
                        throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18010, new Object[]{this.visitor.mongoDoc.getTargetTable().getName(), ref.getParentTable()}));
                    }
                }
            }
            if (mongoDoc.isMerged()) {
                Object[] mergeInfo = mongoDoc.getMergeParentCriteria(this.mongoDB, null, null, new BasicDBObject(), false);
                Boolean nested = (Boolean)mergeInfo[3];
                if (nested.booleanValue()) {
                    throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18016, new Object[0]));
                }
                result = collection.update((DBObject)match, (DBObject)new BasicDBObject("$pull", (Object)this.visitor.getPullQuery()), false, true, WriteConcern.ACKNOWLEDGED);
            } else {
                result = collection.remove((DBObject)match, WriteConcern.ACKNOWLEDGED);
            }
        }
        if (result != null) {
            if (result.getError() != null) {
                throw new TranslatorException(result.getError());
            }
            this.results = new int[1];
            this.results[0] = result.getN();
            if (this.command instanceof Insert && this.executionContext.getCommandContext().isReturnAutoGeneratedKeys()) {
                this.addAutoGeneretedKeys(result);
            }
        }
    }

    private void updateReferenceTables(DBCollection collection, MongoDocument mongoDoc, DBObject match) throws TranslatorException {
        AggregationOutput output = collection.aggregate((DBObject)new BasicDBObject("$match", (Object)match), new DBObject[0]);
        for (DBObject row : output.results()) {
            if (row == null) continue;
            for (MutableDBRef ref : mongoDoc.getEmbeddedInReferences()) {
                BasicDBObject parentmatch;
                DBCollection parent = this.getCollection(ref.getParentTable());
                WriteResult update = parent.update((DBObject)(parentmatch = new BasicDBObject(ref.getReferenceName() + ".$id", row.get("_id"))), (DBObject)new BasicDBObject("$set", (Object)new BasicDBObject(ref.getName(), (Object)row)), false, true, WriteConcern.ACKNOWLEDGED);
                if (update.getError() != null) {
                    throw new TranslatorException(MongoDBPlugin.Util.gs((BundleUtil.Event)MongoDBPlugin.Event.TEIID18009, new Object[0]));
                }
                Table parentTable = this.metadata.getTable(((Schema)mongoDoc.getTable().getParent()).getName(), ref.getParentTable());
                MongoDocument parentMongoDocument = new MongoDocument(parentTable, this.metadata);
                if (!parentMongoDocument.isEmbeddable()) continue;
                this.updateReferenceTables(parent, parentMongoDocument, (DBObject)parentmatch);
            }
        }
    }

    private LinkedHashMap<String, DBObject> fetchEmbeddedDocuments() {
        LinkedHashMap<String, DBObject> additionalDocuments = new LinkedHashMap<String, DBObject>();
        MongoDocument mongoDoc = this.visitor.mongoDoc;
        if (mongoDoc.hasEmbeddedDocuments()) {
            for (String docName : mongoDoc.getEmbeddedDocumentNames()) {
                DBObject document = mongoDoc.getEmbeddedDocument(this.mongoDB, docName);
                if (document == null) continue;
                additionalDocuments.put(docName, document);
            }
        }
        return additionalDocuments;
    }

    private DBCollection getCollection(String name) throws TranslatorException {
        return this.getCollection(this.metadata.getTable(((Schema)this.visitor.mongoDoc.getTable().getParent()).getName(), name));
    }

    private DBCollection getCollection(Table table) {
        DBCollection collection;
        if (!this.mongoDB.collectionExists(table.getName())) {
            collection = this.mongoDB.createCollection(table.getName(), null);
            for (ForeignKey record : table.getForeignKeys()) {
                this.createIndex(collection, (KeyRecord)record, false);
            }
            for (ForeignKey record : table.getUniqueKeys()) {
                this.createIndex(collection, (KeyRecord)record, true);
            }
            for (ForeignKey record : table.getIndexes()) {
                this.createIndex(collection, (KeyRecord)record, false);
            }
        } else {
            collection = this.mongoDB.getCollection(table.getName());
        }
        return collection;
    }

    private void createIndex(DBCollection collection, KeyRecord record, boolean unique) {
        BasicDBObject key = new BasicDBObject();
        for (Column c : record.getColumns()) {
            key.append(MongoDBSelectVisitor.getRecordName((AbstractMetadataRecord)c), (Object)1);
        }
        collection.ensureIndex((DBObject)key, record.getName(), unique);
    }

    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
        return this.results;
    }

    private void addAutoGeneretedKeys(WriteResult result) throws TranslatorException {
        Table table = this.visitor.mongoDoc.getTargetTable();
        int cols = table.getPrimaryKey().getColumns().size();
        Class[] columnDataTypes = new Class[cols];
        String[] columnNames = new String[cols];
        for (int i = 0; i < cols; ++i) {
            columnDataTypes[i] = ((Column)table.getPrimaryKey().getColumns().get(i)).getJavaType();
            columnNames[i] = ((Column)table.getPrimaryKey().getColumns().get(i)).getName();
        }
        GeneratedKeys generatedKeys = this.executionContext.getCommandContext().returnGeneratedKeys(columnNames, columnDataTypes);
        ArrayList<Object> vals = new ArrayList<Object>(columnDataTypes.length);
        for (int i = 0; i < columnDataTypes.length; ++i) {
            Object value = this.executionFactory.retrieveValue(result.getField(columnNames[i]), columnDataTypes[i], this.mongoDB, columnNames[i], columnNames[i]);
            vals.add(value);
        }
        generatedKeys.addKey(vals);
    }
}

