/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.loopback;

import org.teiid.core.util.ApplicationInfo;
import org.teiid.language.Command;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.BaseDelegatingExecutionFactory;
import org.teiid.translator.Execution;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.jdbc.teiid.TeiidExecutionFactory;
import org.teiid.translator.loopback.LoopbackExecution;

@Translator(name="loopback", description="A translator for testing, that returns mock data")
public class LoopbackExecutionFactory
extends BaseDelegatingExecutionFactory {
    private int waitTime = 0;
    private int rowCount = 1;
    private boolean throwError = false;
    private long pollIntervalInMilli = -1L;
    private boolean incrementRows = false;
    private int charValueSize = 10;

    public LoopbackExecutionFactory() {
        TeiidExecutionFactory tef = new TeiidExecutionFactory();
        tef.setDatabaseVersion(ApplicationInfo.getInstance().getReleaseNumber());
        this.setDelegate((ExecutionFactory)tef);
    }

    public void start() throws TranslatorException {
        if (this.getDelegateName() == null && this.getDelegate() != null) {
            this.getDelegate().start();
        }
        super.start();
    }

    @TranslatorProperty(display="Size of values for CLOB, VARCHAR, etc.", advanced=true)
    public int getCharacterValuesSize() {
        return this.charValueSize;
    }

    public void setCharacterValuesSize(int charValSize) {
        this.charValueSize = charValSize;
    }

    @TranslatorProperty(display="If set to true each value in each column is being incremented with each row", advanced=true)
    public boolean getIncrementRows() {
        return this.incrementRows;
    }

    public void setIncrementRows(boolean incrementRows) {
        this.incrementRows = incrementRows;
    }

    public Object getConnection(Object factory) throws TranslatorException {
        return null;
    }

    public Object getConnection(Object factory, ExecutionContext executionContext) throws TranslatorException {
        return null;
    }

    @TranslatorProperty(display="Max Random Wait Time", advanced=true)
    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    @TranslatorProperty(display="Rows Per Query", advanced=true)
    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    @TranslatorProperty(display="Always Throw Error")
    public boolean isThrowError() {
        return this.throwError;
    }

    public void setThrowError(boolean error) {
        this.throwError = error;
    }

    @TranslatorProperty(display="Poll interval if using a Asynchronous Connector")
    public long getPollIntervalInMilli() {
        return this.pollIntervalInMilli;
    }

    public void setPollIntervalInMilli(long intervel) {
        this.pollIntervalInMilli = intervel;
    }

    public Execution createExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
        return new LoopbackExecution(command, this);
    }

    public boolean isSourceRequired() {
        return false;
    }

    public boolean isSourceRequiredForMetadata() {
        return false;
    }

    public void getMetadata(MetadataFactory metadataFactory, Object conn) throws TranslatorException {
    }

    @TranslatorProperty(display="Delegate name", required=false)
    public String getDelegateName() {
        return super.getDelegateName();
    }
}

