/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.BootContext;
import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControllerLogger;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerImpl;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SecurityActions;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public abstract class AbstractControllerService
implements Service<ModelController> {
    public static final String BOOT_STACK_SIZE_PROPERTY = "jboss.boot.thread.stack.size";
    public static final int DEFAULT_BOOT_STACK_SIZE = 0x200000;
    protected final ProcessType processType;
    protected final DelegatingConfigurableAuthorizer authorizer;
    private final RunningModeControl runningModeControl;
    private final DescriptionProvider rootDescriptionProvider;
    private final ResourceDefinition rootResourceDefinition;
    private final ControlledProcessState processState;
    private final OperationStepHandler prepareStep;
    private final InjectedValue<ExecutorService> injectedExecutorService = new InjectedValue();
    private final ExpressionResolver expressionResolver;
    private volatile ModelControllerImpl controller;
    private ConfigurationPersister configurationPersister;
    private final ManagedAuditLogger auditLogger;

    private static int getBootStackSize() {
        String prop = SecurityActions.getSystemProperty(BOOT_STACK_SIZE_PROPERTY);
        if (prop == null) {
            return 0x200000;
        }
        int base = 1;
        String multiple = prop;
        int lastIdx = prop.length() - 1;
        if (lastIdx > 0) {
            char last = prop.charAt(lastIdx);
            if ('k' == last || 'K' == last) {
                multiple = prop.substring(0, lastIdx);
                base = 1024;
            } else if ('m' == last || 'M' == last) {
                multiple = prop.substring(0, lastIdx);
                base = 0x100000;
            }
        }
        try {
            return Integer.parseInt(multiple) * base;
        }
        catch (NumberFormatException e) {
            ControllerLogger.ROOT_LOGGER.invalidSystemPropertyValue(prop, BOOT_STACK_SIZE_PROPERTY, 0x200000);
            return 0x200000;
        }
    }

    @Deprecated
    protected AbstractControllerService(ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, DescriptionProvider rootDescriptionProvider, OperationStepHandler prepareStep, ExpressionResolver expressionResolver, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer) {
        this(processType, runningModeControl, configurationPersister, processState, null, rootDescriptionProvider, prepareStep, expressionResolver, auditLogger, authorizer);
    }

    protected AbstractControllerService(ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, ResourceDefinition rootResourceDefinition, OperationStepHandler prepareStep, ExpressionResolver expressionResolver, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer) {
        this(processType, runningModeControl, configurationPersister, processState, rootResourceDefinition, null, prepareStep, expressionResolver, auditLogger, authorizer);
    }

    @Deprecated
    protected AbstractControllerService(ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, DescriptionProvider rootDescriptionProvider, OperationStepHandler prepareStep, ExpressionResolver expressionResolver) {
        this(processType, runningModeControl, configurationPersister, processState, null, rootDescriptionProvider, prepareStep, expressionResolver, AuditLogger.NO_OP_LOGGER, new DelegatingConfigurableAuthorizer());
    }

    protected AbstractControllerService(ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, ResourceDefinition rootResourceDefinition, OperationStepHandler prepareStep, ExpressionResolver expressionResolver) {
        this(processType, runningModeControl, configurationPersister, processState, rootResourceDefinition, null, prepareStep, expressionResolver, AuditLogger.NO_OP_LOGGER, new DelegatingConfigurableAuthorizer());
    }

    private AbstractControllerService(ProcessType processType, RunningModeControl runningModeControl, ConfigurationPersister configurationPersister, ControlledProcessState processState, ResourceDefinition rootResourceDefinition, DescriptionProvider rootDescriptionProvider, OperationStepHandler prepareStep, ExpressionResolver expressionResolver, ManagedAuditLogger auditLogger, DelegatingConfigurableAuthorizer authorizer) {
        assert (rootDescriptionProvider != null || rootResourceDefinition != null) : rootDescriptionProvider == null ? "Null root description provider" : "Null root resource definition";
        assert (expressionResolver != null) : "Null expressionResolver";
        assert (auditLogger != null) : "Null auditLogger";
        assert (authorizer != null) : "Null authorizer";
        this.processType = processType;
        this.runningModeControl = runningModeControl;
        this.configurationPersister = configurationPersister;
        this.rootDescriptionProvider = rootDescriptionProvider;
        this.rootResourceDefinition = rootResourceDefinition;
        this.processState = processState;
        this.prepareStep = prepareStep;
        this.expressionResolver = expressionResolver;
        this.auditLogger = auditLogger;
        this.authorizer = authorizer;
    }

    public void start(StartContext context) throws StartException {
        if (this.configurationPersister == null) {
            throw ControllerMessages.MESSAGES.persisterNotInjected();
        }
        ServiceController serviceController = context.getController();
        final ServiceContainer container = serviceController.getServiceContainer();
        final ServiceTarget target = context.getChildTarget();
        ExecutorService executorService = (ExecutorService)this.injectedExecutorService.getOptionalValue();
        WritableAuthorizerConfiguration authorizerConfig = this.authorizer.getWritableAuthorizerConfiguration();
        authorizerConfig.reset();
        ManagementResourceRegistration rootResourceRegistration = this.rootDescriptionProvider != null ? ManagementResourceRegistration.Factory.create(this.rootDescriptionProvider, (AccessConstraintUtilizationRegistry)authorizerConfig) : ManagementResourceRegistration.Factory.create(this.rootResourceDefinition, (AccessConstraintUtilizationRegistry)authorizerConfig);
        ModelControllerImpl controller = new ModelControllerImpl((ServiceRegistry)container, target, rootResourceRegistration, new ContainerStateMonitor((ServiceRegistry)container, serviceController), this.configurationPersister, this.processType, this.runningModeControl, this.prepareStep, this.processState, executorService, this.expressionResolver, this.authorizer, this.auditLogger);
        this.initModel(controller.getRootResource(), controller.getRootRegistration());
        this.controller = controller;
        final long bootStackSize = AbstractControllerService.getBootStackSize();
        Thread bootThread = new Thread(null, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        AbstractControllerService.this.boot(new BootContext(){

                            @Override
                            public ServiceTarget getServiceTarget() {
                                return target;
                            }
                        });
                    }
                    finally {
                        AbstractControllerService.this.processState.setRunning();
                    }
                }
                catch (Throwable t) {
                    container.shutdown();
                    if (t instanceof StackOverflowError) {
                        ControllerLogger.ROOT_LOGGER.errorBootingContainer(t, bootStackSize, AbstractControllerService.BOOT_STACK_SIZE_PROPERTY);
                    } else {
                        ControllerLogger.ROOT_LOGGER.errorBootingContainer(t);
                    }
                }
                finally {
                    AbstractControllerService.this.bootThreadDone();
                }
            }
        }, "Controller Boot Thread", bootStackSize);
        bootThread.start();
    }

    protected void boot(BootContext context) throws ConfigurationPersistenceException {
        this.runPerformControllerInitialization(context);
        this.boot(this.configurationPersister.load(), false);
        this.finishBoot();
    }

    protected boolean boot(List<ModelNode> bootOperations, boolean rollbackOnRuntimeFailure) throws ConfigurationPersistenceException {
        return this.controller.boot(bootOperations, OperationMessageHandler.logging, ModelController.OperationTransactionControl.COMMIT, rollbackOnRuntimeFailure);
    }

    protected ModelNode internalExecute(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments, OperationStepHandler prepareStep) {
        return this.controller.internalExecute(operation, handler, control, attachments, prepareStep);
    }

    @Deprecated
    protected ModelNode executeReadOnlyOperation(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments, OperationStepHandler prepareStep, int lockPermit) {
        return this.controller.executeReadOnlyOperation(operation, handler, control, attachments, prepareStep, lockPermit);
    }

    protected void finishBoot() throws ConfigurationPersistenceException {
        this.controller.finishBoot();
        this.configurationPersister.successfulBoot();
    }

    protected void bootThreadDone() {
    }

    public void stop(final StopContext context) {
        this.controller = null;
        context.asynchronous();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    AbstractControllerService.this.stopAsynchronous(context);
                }
                finally {
                    try {
                        AbstractControllerService.this.authorizer.shutdown();
                    }
                    finally {
                        context.complete();
                    }
                }
            }
        };
        ExecutorService executorService = (ExecutorService)this.injectedExecutorService.getOptionalValue();
        if (executorService != null) {
            ((ExecutorService)this.injectedExecutorService.getValue()).execute(r);
        } else {
            Thread executorShutdown = new Thread(r, this.getClass().getSimpleName() + " Shutdown Thread");
            executorShutdown.start();
        }
    }

    protected void stopAsynchronous(StopContext context) {
    }

    public ModelController getValue() throws IllegalStateException, IllegalArgumentException {
        ModelControllerImpl controller;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        if ((controller = this.controller) == null) {
            throw new IllegalStateException();
        }
        return controller;
    }

    public InjectedValue<ExecutorService> getExecutorServiceInjector() {
        return this.injectedExecutorService;
    }

    protected void setConfigurationPersister(ConfigurationPersister persister) {
        this.configurationPersister = persister;
    }

    protected void runPerformControllerInitialization(BootContext context) {
        this.performControllerInitialization(context.getServiceTarget(), this.controller.getRootResource(), this.controller.getRootRegistration());
    }

    protected void performControllerInitialization(ServiceTarget target, Resource rootResource, ManagementResourceRegistration rootRegistration) {
    }

    protected abstract void initModel(Resource var1, ManagementResourceRegistration var2);

    protected ManagedAuditLogger getAuditLogger() {
        return this.auditLogger;
    }
}

