/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AbstractAttributeDefinitionBuilder;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DeprecationData;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SimpleListAttributeDefinition
extends ListAttributeDefinition {
    private final AttributeDefinition valueType;

    @Deprecated
    protected SimpleListAttributeDefinition(String name, String xmlName, AttributeDefinition valueType, boolean allowNull, int minSize, int maxSize, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, AttributeAccess.Flag ... flags) {
        this(name, xmlName, valueType, allowNull, minSize, maxSize, alternatives, requires, attributeMarshaller, resourceOnly, deprecated, accessConstraints, (Boolean)null, flags);
    }

    protected SimpleListAttributeDefinition(String name, String xmlName, AttributeDefinition valueType, boolean allowNull, int minSize, int maxSize, String[] alternatives, String[] requires, AttributeMarshaller attributeMarshaller, boolean resourceOnly, DeprecationData deprecated, AccessConstraintDefinition[] accessConstraints, Boolean nullSignificant, AttributeAccess.Flag ... flags) {
        super(name, xmlName, allowNull, false, minSize, maxSize, valueType.getValidator(), alternatives, requires, attributeMarshaller, resourceOnly, deprecated, accessConstraints, nullSignificant, flags);
        this.valueType = valueType;
    }

    public AttributeDefinition getValueType() {
        return this.valueType;
    }

    @Override
    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle2, prefix, resourceDescription);
        this.addValueTypeDescription(result, prefix, bundle2);
        return result;
    }

    @Override
    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle2, prefix, operationDescription);
        this.addValueTypeDescription(result, prefix, bundle2);
        return result;
    }

    @Override
    protected void addValueTypeDescription(ModelNode node, ResourceBundle bundle2) {
        node.get(new String[]{"value-type", this.valueType.getName()}).set(this.getValueTypeDescription(false));
    }

    protected void addValueTypeDescription(ModelNode node, String prefix, ResourceBundle bundle2) {
        ModelNode valueTypeDesc = this.getValueTypeDescription(false);
        valueTypeDesc.get("description").set(this.valueType.getAttributeTextDescription(bundle2, prefix));
        node.get(new String[]{"value-type", this.valueType.getName()}).set(valueTypeDesc);
    }

    @Override
    protected void addAttributeValueTypeDescription(ModelNode node, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueTypeDesc = this.getValueTypeDescription(false);
        valueTypeDesc.get("description").set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, this.valueType.getName()));
        node.get(new String[]{"value-type", this.valueType.getName()}).set(valueTypeDesc);
    }

    @Override
    protected void addOperationParameterValueTypeDescription(ModelNode node, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueTypeDesc = this.getValueTypeDescription(true);
        valueTypeDesc.get("description").set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, this.valueType.getName()));
        node.get(new String[]{"value-type", this.valueType.getName()}).set(valueTypeDesc);
    }

    @Override
    protected ModelNode convertParameterElementExpressions(ModelNode parameterElement) {
        boolean allowExp;
        boolean bl = allowExp = this.isAllowExpression() || this.valueType.isAllowExpression();
        if (allowExp && COMPLEX_TYPES.contains(this.valueType.getType())) {
            throw new IllegalStateException();
        }
        return allowExp ? SimpleListAttributeDefinition.convertStringExpression(parameterElement) : parameterElement;
    }

    private ModelNode getValueTypeDescription(boolean forOperation) {
        ParameterValidator validator;
        String[] requires;
        String[] alternatives;
        MeasurementUnit measurementUnit;
        ModelNode result = new ModelNode();
        result.get("type").set(this.valueType.getType());
        result.get("description");
        result.get("expressions-allowed").set(this.valueType.isAllowExpression());
        if (forOperation) {
            result.get("required").set(!this.valueType.isAllowNull());
        }
        result.get("nillable").set(this.isAllowNull());
        ModelNode defaultValue = this.valueType.getDefaultValue();
        if (!forOperation && defaultValue != null && defaultValue.isDefined()) {
            result.get("default").set(defaultValue);
        }
        if ((measurementUnit = this.valueType.getMeasurementUnit()) != null && measurementUnit != MeasurementUnit.NONE) {
            result.get("unit").set(measurementUnit.getName());
        }
        if ((alternatives = this.valueType.getAlternatives()) != null) {
            for (String alternative : alternatives) {
                result.get("alternatives").add(alternative);
            }
        }
        if ((requires = this.valueType.getRequires()) != null) {
            for (String required : requires) {
                result.get("requires").add(required);
            }
        }
        if ((validator = this.valueType.getValidator()) instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)((Object)validator);
            Long min = minMax.getMin();
            if (min != null) {
                switch (this.valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        result.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        result.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (this.valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: 
                    case BYTES: {
                        result.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        result.get("max").set(max.longValue());
                    }
                }
            }
        }
        this.addAllowedValuesToDescription(result, validator);
        return result;
    }

    public static class Builder
    extends AbstractAttributeDefinitionBuilder<Builder, SimpleListAttributeDefinition> {
        private final AttributeDefinition valueType;
        private boolean wrapXmlList = true;

        public Builder(String name, AttributeDefinition valueType) {
            super(name, ModelType.LIST);
            this.valueType = valueType;
        }

        public Builder(SimpleListAttributeDefinition basis) {
            super(basis);
            this.valueType = basis.getValueType();
        }

        public static Builder of(String name, AttributeDefinition valueType) {
            return new Builder(name, valueType);
        }

        @Deprecated
        public static Builder of(String name, SimpleAttributeDefinition valueType) {
            return new Builder(name, valueType);
        }

        public Builder setWrapXmlList(boolean wrap) {
            this.wrapXmlList = wrap;
            return this;
        }

        @Override
        public SimpleListAttributeDefinition build() {
            if (this.xmlName == null) {
                this.xmlName = this.name;
            }
            if (this.maxSize < 1) {
                this.maxSize = Integer.MAX_VALUE;
            }
            if (this.attributeMarshaller == null) {
                final boolean wrap = this.wrapXmlList;
                this.attributeMarshaller = new AttributeMarshaller(){

                    @Override
                    public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
                        if (resourceModel.hasDefined(attribute.getName())) {
                            if (wrap) {
                                writer.writeStartElement(attribute.getXmlName());
                            }
                            for (ModelNode handler : resourceModel.get(attribute.getName()).asList()) {
                                Builder.this.valueType.marshallAsElement(handler, writer);
                            }
                            if (wrap) {
                                writer.writeEndElement();
                            }
                        }
                    }
                };
            }
            return new SimpleListAttributeDefinition(this.name, this.xmlName, this.valueType, this.allowNull, this.minSize, this.maxSize, this.alternatives, this.requires, this.attributeMarshaller, this.resourceOnly, this.deprecated, this.accessConstraints, this.nullSignficant, this.flags);
        }

        @Override
        public Builder setAllowNull(boolean allowNull) {
            return (Builder)super.setAllowNull(allowNull);
        }

        @Override
        public Builder setMaxSize(int maxSize) {
            return (Builder)super.setMaxSize(maxSize);
        }

        @Override
        public Builder setMinSize(int minSize) {
            return (Builder)super.setMinSize(minSize);
        }
    }
}

