/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ConstrainedResourceDefinition;
import org.jboss.as.controller.descriptions.DefaultResourceAddDescriptionProvider;
import org.jboss.as.controller.descriptions.DefaultResourceDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;

public class SimpleResourceDefinition
implements ConstrainedResourceDefinition {
    private static final EnumSet<OperationEntry.Flag> RESTART_FLAGS = EnumSet.of(OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES, OperationEntry.Flag.RESTART_ALL_SERVICES, OperationEntry.Flag.RESTART_JVM);
    private final PathElement pathElement;
    private final ResourceDescriptionResolver descriptionResolver;
    private final DescriptionProvider descriptionProvider;
    private final OperationStepHandler addHandler;
    private final OperationStepHandler removeHandler;
    private final OperationEntry.Flag addRestartLevel;
    private final OperationEntry.Flag removeRestartLevel;

    @Deprecated
    public SimpleResourceDefinition(PathElement pathElement, DescriptionProvider descriptionProvider) {
        if (descriptionProvider == null) {
            throw ControllerMessages.MESSAGES.nullVar("descriptionProvider");
        }
        this.pathElement = pathElement;
        this.descriptionResolver = null;
        this.descriptionProvider = descriptionProvider;
        this.addHandler = null;
        this.removeHandler = null;
        this.addRestartLevel = null;
        this.removeRestartLevel = null;
    }

    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver) {
        this(pathElement, descriptionResolver, null, null, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
    }

    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler) {
        this(pathElement, descriptionResolver, addHandler, removeHandler, OperationEntry.Flag.RESTART_NONE, OperationEntry.Flag.RESTART_RESOURCE_SERVICES);
    }

    public SimpleResourceDefinition(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, OperationStepHandler addHandler, OperationStepHandler removeHandler, OperationEntry.Flag addRestartLevel, OperationEntry.Flag removeRestartLevel) {
        if (descriptionResolver == null) {
            throw ControllerMessages.MESSAGES.nullVar("descriptionProvider");
        }
        this.pathElement = pathElement;
        this.descriptionResolver = descriptionResolver;
        this.descriptionProvider = null;
        this.addHandler = addHandler;
        this.removeHandler = removeHandler;
        this.addRestartLevel = addRestartLevel == null ? OperationEntry.Flag.RESTART_NONE : SimpleResourceDefinition.validateRestartLevel("addRestartLevel", addRestartLevel);
        this.removeRestartLevel = removeRestartLevel == null ? OperationEntry.Flag.RESTART_ALL_SERVICES : SimpleResourceDefinition.validateRestartLevel("removeRestartLevel", removeRestartLevel);
    }

    @Override
    public PathElement getPathElement() {
        return this.pathElement;
    }

    @Override
    public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration resourceRegistration) {
        return this.descriptionProvider == null ? new DefaultResourceDescriptionProvider(resourceRegistration, this.descriptionResolver) : this.descriptionProvider;
    }

    @Override
    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        if (this.addHandler != null) {
            this.registerAddOperation(resourceRegistration, this.addHandler, this.addRestartLevel);
        }
        if (this.removeHandler != null) {
            this.registerRemoveOperation(resourceRegistration, this.removeHandler, this.removeRestartLevel);
        }
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
    }

    @Override
    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
    }

    public ResourceDescriptionResolver getResourceDescriptionResolver() {
        return this.descriptionResolver;
    }

    @Deprecated
    protected void registerAddOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        if (handler instanceof DescriptionProvider) {
            registration.registerOperationHandler("add", handler, (DescriptionProvider)((Object)handler), SimpleResourceDefinition.getFlagsSet(flags));
        } else {
            registration.registerOperationHandler("add", handler, (DescriptionProvider)new DefaultResourceAddDescriptionProvider(registration, this.descriptionResolver), SimpleResourceDefinition.getFlagsSet(flags));
        }
    }

    protected void registerAddOperation(ManagementResourceRegistration registration, AbstractAddStepHandler handler, OperationEntry.Flag ... flags) {
        this.registerAddOperation(registration, (OperationStepHandler)handler, flags);
    }

    @Deprecated
    protected void registerRemoveOperation(ManagementResourceRegistration registration, OperationStepHandler handler, OperationEntry.Flag ... flags) {
        if (handler instanceof DescriptionProvider) {
            registration.registerOperationHandler("remove", handler, (DescriptionProvider)((Object)handler), SimpleResourceDefinition.getFlagsSet(flags));
        } else {
            SimpleOperationDefinition opDef = new SimpleOperationDefinitionBuilder("remove", this.descriptionResolver).withFlags(flags).build();
            registration.registerOperationHandler(opDef, handler);
        }
    }

    protected void registerRemoveOperation(ManagementResourceRegistration registration, AbstractRemoveStepHandler handler, OperationEntry.Flag ... flags) {
        this.registerRemoveOperation(registration, (OperationStepHandler)handler, flags);
    }

    private static OperationEntry.Flag validateRestartLevel(String paramName, OperationEntry.Flag flag) {
        if (flag != null && !RESTART_FLAGS.contains((Object)flag)) {
            throw ControllerMessages.MESSAGES.invalidParameterValue(flag, paramName, RESTART_FLAGS);
        }
        return flag;
    }

    protected static EnumSet<OperationEntry.Flag> getFlagsSet(OperationEntry.Flag ... vararg) {
        return SimpleOperationDefinitionBuilder.getFlagsSet(vararg);
    }

    @Override
    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Collections.emptyList();
    }
}

