/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase.tds;

import com.metamatrix.jdbc.base.BaseCharacterStreamWrapper;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.base.BaseTimestamp;
import com.metamatrix.jdbc.sybase.SybaseConnection;
import com.metamatrix.jdbc.sybase.SybaseDateTime;
import com.metamatrix.jdbc.sybase.SybaseMetaData;
import com.metamatrix.jdbc.sybase.tds.SybaseTDS;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSBlobOutputStream;
import com.metamatrix.jdbc.sybase.tds.SybaseTDSCommunication;
import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;

public class SybaseTDSParameter
extends SybaseTDS {
    private static String footprint = "$Revision:   3.22.1.2  $";
    BaseExceptions exceptions;
    public boolean isInput;
    public boolean isOutput;
    public int sqlType;
    public short nativeTypeOfInputVal;
    public int actualDataLengthOfInputVal;
    public int precisionOfInputVal;
    public int scaleOfInputVal;
    public int signOfInputVal;
    private static final BigInteger ZERO = new BigInteger("0");
    public int scaleOfOutputVal;
    public Object data;
    public int baseDataType;
    public String name;
    public int fmtLength;
    public SybaseMetaData metaDataForOutputValue = null;
    BaseParameter par;
    int paramIndex;
    SybaseTDSCommunication comm;
    SybaseConnection connection;
    static String SINGLE_BLANK = new String(" ");

    public SybaseTDSParameter(BaseExceptions baseExceptions) {
        this.exceptions = baseExceptions;
    }

    public void setup(SybaseTDSCommunication sybaseTDSCommunication, SybaseConnection sybaseConnection, BaseParameters baseParameters, int n, boolean bl) {
        this.paramIndex = n;
        this.comm = sybaseTDSCommunication;
        this.connection = sybaseConnection;
        this.name = "";
        if (bl) {
            switch (n) {
                case 2: {
                    this.name = "@name";
                    break;
                }
                case 3: {
                    this.name = "@status";
                    break;
                }
                case 4: {
                    this.name = "@flags";
                    break;
                }
                case 5: {
                    this.name = "@mode";
                }
            }
        }
        this.nativeTypeOfInputVal = (short)-1;
        this.actualDataLengthOfInputVal = 0;
        BaseParameter baseParameter = baseParameters.getInput(n);
        this.isInput = baseParameter != null;
        BaseParameter baseParameter2 = baseParameters.getOutput(n);
        boolean bl2 = this.isOutput = baseParameter2 != null;
        if (this.isOutput) {
            this.scaleOfOutputVal = baseParameter2.scale;
        }
        this.par = this.isInput ? baseParameter : baseParameter2;
        this.sqlType = this.par.sqlType;
        this.data = this.par.getObject();
        this.baseDataType = this.par.getType();
    }

    private boolean isCharacterType(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public void setSqlType(int n) {
        this.sqlType = n;
    }

    public void prepareTDSData() throws SQLException {
        switch (this.sqlType) {
            case -7: {
                if (this.par.isNull() && !this.isOutput) {
                    String[] stringArray = new String[]{String.valueOf(this.paramIndex)};
                    throw this.exceptions.getException(7006, stringArray, "23000");
                }
                this.nativeTypeOfInputVal = (short)50;
                if (!this.isInput || this.par.isNull()) break;
                this.data = new Boolean(this.par.getBoolean(this.exceptions));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                this.nativeTypeOfInputVal = (short)38;
                if (!this.isInput || this.par.isNull()) break;
                this.data = new Integer(this.par.getInteger(this.exceptions));
                this.actualDataLengthOfInputVal = 4;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.nativeTypeOfInputVal = (short)109;
                if (!this.isInput || this.par.isNull()) break;
                this.data = new Double(this.par.getDouble(this.exceptions));
                this.actualDataLengthOfInputVal = 8;
                break;
            }
            case -5: 
            case 2: 
            case 3: {
                this.nativeTypeOfInputVal = (short)106;
                this.scaleOfInputVal = this.isOutput ? (this.scaleOfOutputVal > 38 ? 38 : this.scaleOfOutputVal) : -1;
                if (this.isInput && !this.par.isNull()) {
                    BigDecimal bigDecimal;
                    this.actualDataLengthOfInputVal = 33;
                    if (this.baseDataType != 8) {
                        this.data = this.par.getBigDecimal(this.exceptions);
                    }
                    if (this.scaleOfInputVal > (bigDecimal = (BigDecimal)this.data).scale()) {
                        this.data = bigDecimal.setScale(this.scaleOfInputVal);
                    } else {
                        this.scaleOfInputVal = bigDecimal.scale();
                    }
                    BigInteger bigInteger = bigDecimal.movePointRight(this.scaleOfInputVal).toBigInteger().abs();
                    if (bigInteger.compareTo(ZERO) == 0) {
                        this.precisionOfInputVal = 1;
                        this.scaleOfInputVal = 1;
                    } else {
                        this.precisionOfInputVal = bigInteger.toString().length();
                    }
                    this.signOfInputVal = bigDecimal.signum();
                    if (this.precisionOfInputVal > 38 || this.scaleOfInputVal > 38) {
                        String[] stringArray = new String[]{String.valueOf(this.paramIndex)};
                        throw this.exceptions.getException(7005, stringArray, "JZ00B");
                    }
                    this.data = bigInteger;
                    break;
                }
                this.precisionOfInputVal = 38;
                if (this.scaleOfInputVal != -1) break;
                this.scaleOfInputVal = 19;
                break;
            }
            case 91: 
            case 92: {
                if (this.connection.supportsDateAndTimeTypes) {
                    if (this.sqlType == 91) {
                        this.nativeTypeOfInputVal = (short)123;
                        if (!this.isInput || this.par.isNull()) break;
                        this.data = this.par.getDate(this.exceptions);
                        this.actualDataLengthOfInputVal = 4;
                        SybaseDateTime.validateDate(this.exceptions, (Date)this.data);
                        break;
                    }
                    this.nativeTypeOfInputVal = (short)-109;
                    if (!this.isInput || this.par.isNull()) break;
                    this.data = this.par.getTime(this.exceptions);
                    this.actualDataLengthOfInputVal = 4;
                    break;
                }
            }
            case 93: {
                this.nativeTypeOfInputVal = (short)111;
                if (!this.isInput || this.par.isNull()) break;
                try {
                    this.data = this.par.getTimestamp(this.exceptions);
                    this.actualDataLengthOfInputVal = 8;
                }
                catch (SQLException sQLException) {
                    this.data = this.par.getString(23, this.exceptions);
                    this.nativeTypeOfInputVal = (short)39;
                    this.actualDataLengthOfInputVal = ((String)this.data).length();
                }
                if (this.nativeTypeOfInputVal != 111) break;
                SybaseDateTime.validateTimestamp(this.exceptions, (BaseTimestamp)this.data);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                if (this.isInput && !this.par.isNull()) {
                    long l = 0L;
                    switch (this.baseDataType) {
                        case 10: {
                            l = ((String)this.data).length();
                            break;
                        }
                        case 15: {
                            l = ((BaseInputStreamWrapper)this.data).determineLength();
                            break;
                        }
                        case 18: {
                            l = ((BaseCharacterStreamWrapper)this.data).determineLength();
                            break;
                        }
                        case 20: {
                            this.data = this.par.getCharacterStreamReader(-1, (BaseConnection)this.connection, this.exceptions);
                            l = ((BaseCharacterStreamWrapper)this.data).determineLength();
                            this.baseDataType = 18;
                            break;
                        }
                        default: {
                            this.data = this.par.getString(-1, this.exceptions);
                            l = ((String)this.data).length();
                        }
                    }
                    if (l == 0L) {
                        this.nativeTypeOfInputVal = (short)39;
                        this.actualDataLengthOfInputVal = 1;
                        this.data = SINGLE_BLANK;
                        break;
                    }
                    if ((double)this.connection.getServerVersion() < 12.5) {
                        if (l > 255L) {
                            throw this.exceptions.getException(7004, new String[]{String.valueOf(this.paramIndex)}, "22001");
                        }
                        this.nativeTypeOfInputVal = (short)39;
                        this.actualDataLengthOfInputVal = (int)l;
                        this.data = this.par.getString(-1, this.exceptions);
                        break;
                    }
                    if (l < (long)this.connection.getPageSize()) {
                        this.nativeTypeOfInputVal = (short)-81;
                        this.actualDataLengthOfInputVal = (int)l;
                        break;
                    }
                    this.nativeTypeOfInputVal = (short)36;
                    break;
                }
                this.nativeTypeOfInputVal = (short)39;
                this.data = "";
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                if (this.isInput && !this.par.isNull()) {
                    long l = 0L;
                    switch (this.baseDataType) {
                        case 2: {
                            l = ((byte[])this.data).length;
                            break;
                        }
                        case 14: {
                            l = ((BaseInputStreamWrapper)this.data).determineLength();
                            break;
                        }
                        case 19: {
                            this.data = this.par.getBinaryStream(-1, (BaseConnection)this.connection, this.exceptions);
                            l = ((BaseInputStreamWrapper)this.data).determineLength();
                            this.baseDataType = 14;
                            break;
                        }
                        default: {
                            this.data = this.par.getBytes(-1, this.exceptions);
                            l = ((byte[])this.data).length;
                        }
                    }
                    if ((double)this.connection.getServerVersion() < 12.5) {
                        if (l > 255L) {
                            throw this.exceptions.getException(7004, new String[]{String.valueOf(this.paramIndex)}, "22001");
                        }
                        this.nativeTypeOfInputVal = (short)37;
                        this.actualDataLengthOfInputVal = (int)l;
                        this.data = this.par.getBytes(-1, this.exceptions);
                        break;
                    }
                    if (l < (long)this.connection.getPageSize()) {
                        this.nativeTypeOfInputVal = (short)-31;
                        this.actualDataLengthOfInputVal = (int)l;
                        break;
                    }
                    this.nativeTypeOfInputVal = (short)36;
                    break;
                }
                this.nativeTypeOfInputVal = (short)37;
            }
        }
        this.fmtLength = 1 + this.name.length() + 4 + 1 + 1;
        this.fmtLength = this.comm.supportsWideTables ? (this.fmtLength += 4) : ++this.fmtLength;
        switch (this.nativeTypeOfInputVal) {
            case -109: 
            case 37: 
            case 38: 
            case 39: 
            case 109: 
            case 111: 
            case 123: {
                ++this.fmtLength;
                break;
            }
            case 106: {
                this.fmtLength += 3;
                break;
            }
            case -81: 
            case -31: {
                this.fmtLength += 4;
                break;
            }
            case 36: {
                this.fmtLength += 3;
                break;
            }
            case 50: {
                break;
            }
            default: {
                UtilDebug.assert((String)"Unexpected TDS Type", (boolean)false);
            }
        }
    }

    public void writeFormat(UtilByteOrderedDataWriter utilByteOrderedDataWriter, boolean bl) throws UtilException {
        utilByteOrderedDataWriter.writeStringWithLength8(this.name);
        if (bl) {
            utilByteOrderedDataWriter.writeInt32(this.isOutput ? 1 : 0);
        } else {
            utilByteOrderedDataWriter.writeInt8(this.isOutput ? 1 : 0);
        }
        utilByteOrderedDataWriter.writeInt32(0);
        utilByteOrderedDataWriter.writeInt8((int)this.nativeTypeOfInputVal);
        switch (this.nativeTypeOfInputVal) {
            case 38: {
                utilByteOrderedDataWriter.writeInt8(4);
                break;
            }
            case 109: {
                utilByteOrderedDataWriter.writeInt8(8);
                break;
            }
            case 106: {
                utilByteOrderedDataWriter.writeInt8(33);
                utilByteOrderedDataWriter.writeInt8(this.precisionOfInputVal);
                utilByteOrderedDataWriter.writeInt8(this.scaleOfInputVal);
                break;
            }
            case -109: 
            case 123: {
                utilByteOrderedDataWriter.writeInt8(4);
                break;
            }
            case 111: {
                utilByteOrderedDataWriter.writeInt8(8);
                break;
            }
            case -81: 
            case -31: {
                utilByteOrderedDataWriter.writeInt32(Integer.MAX_VALUE);
                break;
            }
            case 37: 
            case 39: {
                utilByteOrderedDataWriter.writeInt8(255);
                break;
            }
            case 36: {
                if (this.isCharacterType(this.sqlType)) {
                    utilByteOrderedDataWriter.writeInt8(3);
                } else {
                    utilByteOrderedDataWriter.writeInt8(4);
                }
                utilByteOrderedDataWriter.writeInt16(0);
                break;
            }
            case 50: {
                break;
            }
            default: {
                UtilDebug.assert((String)"Unexpected TDS Type", (boolean)false);
            }
        }
        utilByteOrderedDataWriter.writeInt8(0);
    }

    public void writeData(UtilByteOrderedDataWriter utilByteOrderedDataWriter) throws UtilException, SQLException {
        block4 : switch (this.nativeTypeOfInputVal) {
            case 50: {
                if (this.data != null) {
                    utilByteOrderedDataWriter.writeInt8((Boolean)this.data != false ? 1 : 0);
                    break;
                }
                utilByteOrderedDataWriter.writeInt8(0);
                break;
            }
            case 38: {
                utilByteOrderedDataWriter.writeInt8(this.actualDataLengthOfInputVal);
                switch (this.actualDataLengthOfInputVal) {
                    case 1: {
                        utilByteOrderedDataWriter.writeInt8((int)((Byte)this.data).byteValue());
                        break;
                    }
                    case 2: {
                        utilByteOrderedDataWriter.writeInt16((int)((Short)this.data).shortValue());
                        break;
                    }
                    case 4: {
                        utilByteOrderedDataWriter.writeInt32(((Integer)this.data).intValue());
                    }
                }
                break;
            }
            case 109: {
                utilByteOrderedDataWriter.writeInt8(this.actualDataLengthOfInputVal);
                switch (this.actualDataLengthOfInputVal) {
                    case 4: {
                        utilByteOrderedDataWriter.writeIEEE32BitFloat(((Float)this.data).floatValue());
                        break;
                    }
                    case 8: {
                        utilByteOrderedDataWriter.writeIEEE64BitDouble(((Double)this.data).doubleValue());
                    }
                }
                break;
            }
            case 106: {
                if (this.actualDataLengthOfInputVal == 0) {
                    utilByteOrderedDataWriter.writeInt8(this.actualDataLengthOfInputVal);
                    break;
                }
                int n = 0;
                byte[] byArray = ((BigInteger)this.data).toByteArray();
                this.actualDataLengthOfInputVal = byArray.length + 1;
                if (byArray[0] == 0 && this.actualDataLengthOfInputVal > 2) {
                    --this.actualDataLengthOfInputVal;
                    ++n;
                }
                utilByteOrderedDataWriter.writeInt8(this.actualDataLengthOfInputVal);
                utilByteOrderedDataWriter.writeInt8(this.signOfInputVal >= 0 ? 0 : 1);
                utilByteOrderedDataWriter.writeBytes(byArray, n, byArray.length - n);
                break;
            }
            case 123: {
                utilByteOrderedDataWriter.writeInt8(this.actualDataLengthOfInputVal);
                if (this.actualDataLengthOfInputVal == 0) break;
                utilByteOrderedDataWriter.writeInt32(SybaseDateTime.toNativeDate((Date)this.data));
                break;
            }
            case -109: {
                utilByteOrderedDataWriter.writeInt8(this.actualDataLengthOfInputVal);
                if (this.actualDataLengthOfInputVal == 0) break;
                utilByteOrderedDataWriter.writeInt32(SybaseDateTime.toNativeTime((Time)this.data));
                break;
            }
            case 111: {
                utilByteOrderedDataWriter.writeInt8(this.actualDataLengthOfInputVal);
                if (this.actualDataLengthOfInputVal == 0) break;
                int[] nArray = SybaseDateTime.toNativeTimestamp((BaseTimestamp)this.data);
                utilByteOrderedDataWriter.writeInt32(nArray[0]);
                utilByteOrderedDataWriter.writeInt32(nArray[1]);
                break;
            }
            case 39: {
                utilByteOrderedDataWriter.setTransliterator(this.comm.transliteratorForCharData);
                utilByteOrderedDataWriter.writeStringWithLength8((String)this.data);
                utilByteOrderedDataWriter.setTransliterator(this.comm.transliteratorForDefaultCharset);
                break;
            }
            case -81: {
                try {
                    utilByteOrderedDataWriter.setTransliterator(this.comm.transliteratorForCharData);
                    switch (this.baseDataType) {
                        case 15: {
                            utilByteOrderedDataWriter.writeAsciiStreamWithLength32((InputStream)this.data, (int)((BaseInputStreamWrapper)this.data).determineLength());
                            break;
                        }
                        case 18: {
                            utilByteOrderedDataWriter.writeReaderWithLength32((Reader)this.data, (int)((BaseCharacterStreamWrapper)this.data).determineLength());
                            break;
                        }
                        default: {
                            utilByteOrderedDataWriter.writeStringWithLength32((String)this.data);
                        }
                    }
                    utilByteOrderedDataWriter.setTransliterator(this.comm.transliteratorForDefaultCharset);
                    break;
                }
                catch (UtilException utilException) {
                    utilByteOrderedDataWriter.setTransliterator(this.comm.transliteratorForDefaultCharset);
                    throw this.exceptions.getException((Exception)((Object)utilException));
                }
            }
            case 37: {
                utilByteOrderedDataWriter.writeInt8(this.actualDataLengthOfInputVal);
                utilByteOrderedDataWriter.writeBytes((byte[])this.data);
                break;
            }
            case -31: {
                try {
                    switch (this.baseDataType) {
                        case 14: {
                            utilByteOrderedDataWriter.writeStreamWithLength32((InputStream)this.data, (int)((BaseInputStreamWrapper)this.data).determineLength());
                            break block4;
                        }
                    }
                    utilByteOrderedDataWriter.writeInt32(this.actualDataLengthOfInputVal);
                    utilByteOrderedDataWriter.writeBytes((byte[])this.data);
                    break;
                }
                catch (UtilException utilException) {
                    throw this.exceptions.getException((Exception)((Object)utilException));
                }
            }
            case 36: {
                Object object;
                SybaseTDSBlobOutputStream sybaseTDSBlobOutputStream = new SybaseTDSBlobOutputStream(utilByteOrderedDataWriter);
                if (this.isCharacterType(this.sqlType)) {
                    switch (this.baseDataType) {
                        case 15: {
                            object = (BaseInputStreamWrapper)this.data;
                            this.comm.transliteratorForCharData.encode((InputStream)object, (int)object.determineLength(), (OutputStream)sybaseTDSBlobOutputStream);
                            break;
                        }
                        case 18: {
                            Reader reader = (Reader)this.data;
                            this.comm.transliteratorForCharData.encode(reader, (int)((BaseCharacterStreamWrapper)reader).determineLength(), (OutputStream)sybaseTDSBlobOutputStream);
                            break;
                        }
                        default: {
                            BaseData baseData = new BaseData(this.baseDataType, this.data, (BaseConnection)this.connection);
                            String string = baseData.getString(-1, this.exceptions);
                            this.comm.transliteratorForCharData.encode((Reader)new StringReader(string), string.length(), (OutputStream)sybaseTDSBlobOutputStream);
                            break;
                        }
                    }
                } else {
                    object = null;
                    switch (this.baseDataType) {
                        case 14: {
                            object = (BaseInputStreamWrapper)this.data;
                            break;
                        }
                        default: {
                            BaseData baseData = new BaseData(this.baseDataType, this.data, (BaseConnection)this.connection);
                            byte[] byArray = baseData.getBytes(-1, this.exceptions);
                            object = new ByteArrayInputStream(byArray);
                        }
                    }
                    try {
                        int n;
                        byte[] byArray = new byte[2048];
                        while ((n = object.read(byArray, 0, 2048)) >= 0) {
                            sybaseTDSBlobOutputStream.write(byArray, 0, n);
                        }
                    }
                    catch (IOException iOException) {
                        throw this.exceptions.getException((Exception)iOException);
                    }
                }
                try {
                    sybaseTDSBlobOutputStream.close();
                    break;
                }
                catch (IOException iOException) {
                    throw this.exceptions.getException((Exception)iOException);
                }
            }
            default: {
                UtilDebug.assert((String)"Not implmented input data type", (boolean)false);
            }
        }
    }
}

