/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.oracle.net8.OracleDataConsumer;
import com.metamatrix.jdbc.oracle.net8.OracleDataProvider;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import java.sql.SQLException;

public class OracleInternalParameter {
    private static String footprint = "$Revision:   1.2.1.2  $";
    public int m_nativeBindType;
    public int m_precision;
    public int m_scale;
    public int m_maxlen;
    public int m_direction = 32;
    public boolean m_writeDataAtEndOfRXD = false;
    public int m_charSetId;
    public int m_charSetForm;
    public UtilTransliterator m_transliterator;
    public byte[] m_nativeDataIn;
    public int m_nativeDataInLength;
    public int m_nativeDataInOffset;
    public byte[] m_nativeDataOut;
    public int m_nativeDataOutLength;
    public BaseColumn[] m_columnDescriptions;
    public static final byte IN = 32;
    public static final byte OUT = 16;

    public void setInfo(int n, int n2, int n3, int n4, int n5, int n6, UtilTransliterator utilTransliterator) {
        this.m_nativeBindType = n;
        this.m_precision = n2;
        this.m_scale = n3;
        this.m_maxlen = n4;
        this.m_charSetId = n5;
        this.m_charSetForm = n6;
        this.m_transliterator = utilTransliterator;
    }

    public void copy(OracleInternalParameter oracleInternalParameter) {
        this.m_nativeBindType = oracleInternalParameter.m_nativeBindType;
        this.m_precision = oracleInternalParameter.m_precision;
        this.m_scale = oracleInternalParameter.m_scale;
        this.m_maxlen = oracleInternalParameter.m_maxlen;
        this.m_charSetId = oracleInternalParameter.m_charSetId;
        this.m_charSetForm = oracleInternalParameter.m_charSetForm;
        this.m_transliterator = oracleInternalParameter.m_transliterator;
        this.m_direction = oracleInternalParameter.m_direction;
    }

    public void setupNativeDataInBuffer(int n) {
        if (this.m_nativeDataIn == null || n > this.m_nativeDataIn.length) {
            this.m_nativeDataIn = new byte[n];
        }
    }

    public void readData(OracleDataProvider oracleDataProvider) throws UtilException, SQLException {
        Object object = null;
        switch (this.m_nativeBindType) {
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 23: 
            case 24: 
            case 96: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 180: 
            case 181: 
            case 231: {
                object = oracleDataProvider.readCLR(4000);
                short s = oracleDataProvider.readB2();
                if (s == 0) {
                    this.m_nativeDataOut = object;
                    this.m_nativeDataOutLength = ((byte[])object).length;
                    break;
                }
                this.m_nativeDataOut = null;
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                object = oracleDataProvider.readB4() != 0 ? oracleDataProvider.readCLR(86) : null;
                short s = oracleDataProvider.readB2();
                if (s == 0) {
                    this.m_nativeDataOut = object;
                    this.m_nativeDataOutLength = ((byte[])object).length;
                    break;
                }
                this.m_nativeDataOut = null;
                break;
            }
            default: {
                UtilDebug.assert((String)"Unexpected output parameter type", (boolean)false);
            }
        }
    }

    public void writeData(OracleDataConsumer oracleDataConsumer) throws UtilException {
        switch (this.m_nativeBindType) {
            case 112: 
            case 113: {
                oracleDataConsumer.writeB4(86);
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 23: 
            case 24: 
            case 96: 
            case 100: 
            case 101: 
            case 102: 
            case 180: 
            case 181: 
            case 231: {
                if (this.m_nativeDataIn == null) {
                    oracleDataConsumer.writeByte((byte)0);
                    break;
                }
                oracleDataConsumer.writeCLR(this.m_nativeDataIn, this.m_nativeDataInOffset, this.m_nativeDataInLength);
                break;
            }
            default: {
                UtilDebug.assert((String)"Unexpected data type", (boolean)false);
            }
        }
    }
}

