/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import java.io.Reader;
import java.sql.SQLException;

public class BaseImplClobEmulated
extends BaseImplClob {
    private static String footprint = "$Revision:   1.3.1.0  $";
    private UtilPagedTempBuffer clobData;
    private boolean byteSwapped = false;

    public BaseImplClobEmulated(BaseExceptions baseExceptions, UtilPagedTempBuffer utilPagedTempBuffer, boolean bl) throws SQLException {
        super(baseExceptions);
        this.clobData = utilPagedTempBuffer;
        this.byteSwapped = bl;
    }

    public BaseImplClobEmulated(BaseExceptions baseExceptions, Reader reader) throws SQLException {
        super(baseExceptions);
        try {
            this.clobData = new UtilPagedTempBuffer(2, 16);
            int n = 1024;
            char[] cArray = new char[n];
            byte[] byArray = new byte[n * 2];
            int n2 = reader.read(cArray);
            long l = 0L;
            while (n2 != -1) {
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    byArray[n3++] = (byte)(cArray[n4] >>> 8 & 0xFF);
                    byArray[n3++] = (byte)(cArray[n4++] >>> 0 & 0xFF);
                }
                this.clobData.write(l, byArray, 0, n3);
                l += (long)n3;
                n2 = reader.read(cArray);
            }
        }
        catch (Exception exception) {
            throw baseExceptions.getException(exception);
        }
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(String string, long l) throws SQLException {
        long l2 = this.getLength() * 2L;
        long l3 = (l - 1L) * 2L;
        long l4 = string.length();
        long l5 = 0L;
        byte[] byArray = new byte[2];
        long l6 = l3;
        try {
            while (l5 < l4) {
                byte by;
                if (l3 == l2) {
                    return -1L;
                }
                char c = string.charAt((int)l5++);
                this.clobData.read(l3, byArray, 0, 2);
                if (this.byteSwapped) {
                    by = byArray[0];
                    byArray[0] = byArray[1];
                    byArray[1] = by;
                }
                l3 += 2L;
                char c2 = (char)(((byArray[0] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 0));
                if (c == c2) continue;
                l5 = 0L;
                c = string.charAt((int)l5++);
                l3 = l6 + 2L;
                do {
                    if (l3 >= l2) {
                        return -1L;
                    }
                    this.clobData.read(l3, byArray, 0, 2);
                    if (this.byteSwapped) {
                        by = byArray[0];
                        byArray[0] = byArray[1];
                        byArray[1] = by;
                    }
                    l3 += 2L;
                } while (c != (c2 = (char)(((byArray[0] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 0))));
                l6 = l3 - 2L;
            }
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
        return l6 / 2L + 1L;
    }

    public int readData(byte[] byArray, int n, long l, int n2) throws SQLException {
        try {
            int n3 = this.clobData.read((l - 1L) * 2L, byArray, n, n2 * 2);
            if (this.byteSwapped) {
                int n4 = 0;
                while (n4 < n3) {
                    byte by = byArray[n + n4];
                    byArray[n + n4] = byArray[n + n4 + 1];
                    byArray[n + n4 + 1] = by;
                    n4 += 2;
                }
            }
            return n3;
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    public int writeData(long l, byte[] byArray, int n, int n2) throws SQLException {
        try {
            if (this.byteSwapped) {
                int n3 = 0;
                int n4 = n2 * 2;
                while (n3 < n4) {
                    this.clobData.write((l - 1L) * 2L + (long)n3, byArray, n + n3 + 1, 1);
                    this.clobData.write((l - 1L) * 2L + (long)n3 + 1L, byArray, n + n3, 1);
                    n3 += 2;
                }
                return n3 / 2;
            }
            return this.clobData.write((l - 1L) * 2L, byArray, n, n2 * 2) / 2;
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void truncate(long l) throws SQLException {
        try {
            this.clobData.truncate(l * 2L);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public long getLength() throws SQLException {
        return this.clobData.getSize() / 2L;
    }

    public int getCharacterEncoding() {
        return 2;
    }

    public void close() throws SQLException {
        try {
            this.clobData.truncate(true);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException));
        }
    }
}

