/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameterInfo;
import java.sql.SQLException;

public class BaseParameters {
    private static String footprint = "$Revision:   3.12.1.2  $";
    private BaseExceptions exceptions;
    BaseParameterInfo[] parameterMetaData;
    public BaseParameter[] parametersIn;
    public BaseParameter[] parametersOut;
    boolean outputParamRegistered = false;
    public BaseConnection connection;

    public BaseParameters(int n, BaseExceptions baseExceptions, BaseConnection baseConnection) {
        this.parametersIn = new BaseParameter[n];
        this.parametersOut = new BaseParameter[n];
        this.exceptions = baseExceptions;
        this.connection = baseConnection;
    }

    public BaseParameters(BaseParameters baseParameters, BaseExceptions baseExceptions, BaseConnection baseConnection) {
        this.copy(baseParameters, baseExceptions, baseConnection);
    }

    public void copy(BaseParameters baseParameters, BaseExceptions baseExceptions, BaseConnection baseConnection) {
        if (this.parametersIn == null || this.parametersIn.length < baseParameters.parametersIn.length) {
            this.parametersIn = new BaseParameter[baseParameters.parametersIn.length];
        }
        if (this.parametersOut == null || this.parametersOut.length < baseParameters.parametersOut.length) {
            this.parametersOut = new BaseParameter[baseParameters.parametersOut.length];
        }
        this.exceptions = baseExceptions;
        this.connection = baseConnection;
        this.parameterMetaData = baseParameters.parameterMetaData;
        int n = 0;
        while (n < this.parametersIn.length) {
            if (baseParameters.parametersIn[n] != null) {
                if (this.parametersIn[n] == null) {
                    this.parametersIn[n] = new BaseParameter(baseParameters.parametersIn[n], baseConnection);
                } else {
                    this.parametersIn[n].copy(baseParameters.parametersIn[n], baseConnection);
                }
            }
            if (baseParameters.parametersOut[n] != null) {
                if (this.parametersOut[n] == null) {
                    this.parametersOut[n] = new BaseParameter(baseParameters.parametersOut[n], baseConnection);
                } else {
                    this.parametersOut[n].copy(baseParameters.parametersOut[n], baseConnection);
                }
                this.outputParamRegistered = true;
            }
            ++n;
        }
    }

    public void set(int n, int n2, BaseParameter baseParameter) throws SQLException {
        try {
            if (n2 == 1) {
                this.parametersIn[n - 1] = baseParameter;
            } else if (n2 == 2) {
                this.parametersOut[n - 1] = baseParameter;
                this.outputParamRegistered = true;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter getParameter(int n) throws SQLException {
        try {
            BaseParameter baseParameter = this.parametersIn[n - 1];
            if (baseParameter == null) {
                this.parametersIn[n - 1] = baseParameter = new BaseParameter(this.connection);
            }
            return baseParameter;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public void clearInput() {
        int n = this.count();
        int n2 = 0;
        while (n2 < n) {
            if (this.parametersIn[n2] != null) {
                this.parametersIn[n2].setNull(0);
            }
            ++n2;
        }
    }

    public void clearOutput(boolean bl) {
        int n = this.count();
        int n2 = 0;
        while (n2 < n) {
            if (this.parametersOut[n2] != null) {
                if (bl) {
                    this.outputParamRegistered = false;
                    this.parametersOut[n2] = null;
                } else {
                    this.parametersOut[n2].setNull(0);
                }
            }
            ++n2;
        }
    }

    public int count() {
        return this.parametersIn.length;
    }

    protected boolean anyOutputParamsRegistered() {
        return this.outputParamRegistered;
    }

    public BaseParameter get(int n, int n2) throws SQLException {
        try {
            Object var3_3 = null;
            if (n2 == 1) {
                return this.parametersIn[n - 1];
            }
            if (n2 == 2) {
                return this.parametersOut[n - 1];
            }
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameter getInput(int n) {
        return this.parametersIn[n - 1];
    }

    public BaseParameter getOutput(int n) {
        return this.parametersOut[n - 1];
    }

    boolean isValidOrdinal(int n) {
        return n > 0 && n <= this.count();
    }

    protected boolean haveMinimalBindings() {
        boolean bl = true;
        int n = this.count();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (this.parametersIn[n4] != null && this.parametersIn[n4].type != 0) {
                ++n2;
            } else if (this.parametersOut[n4] != null) {
                ++n3;
            }
            ++n4;
        }
        if (n2 + n3 < n) {
            bl = false;
        }
        return bl;
    }

    public void setParameterInfo(int n, BaseParameterInfo baseParameterInfo) {
        if (this.parameterMetaData == null) {
            this.parameterMetaData = new BaseParameterInfo[this.count()];
        }
        this.parameterMetaData[n] = baseParameterInfo;
    }

    public BaseParameterInfo getParameterInfoOrNull(int n) throws SQLException {
        try {
            if (this.parameterMetaData == null || n > this.parameterMetaData.length - 1 || this.parameterMetaData[n] == null) {
                return null;
            }
            return this.parameterMetaData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }

    public BaseParameterInfo getParameterInfo(int n) throws SQLException {
        try {
            if (this.parameterMetaData == null || n > this.parameterMetaData.length - 1 || this.parameterMetaData[n] == null) {
                throw this.exceptions.getException(6088);
            }
            return this.parameterMetaData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.exceptions.getException(6010, "07009");
        }
    }
}

