/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseCallEscape;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseFunctionEscape;
import com.metamatrix.jdbc.base.BaseTimestampEscape;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplStatement;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilStringFunctions;
import java.util.StringTokenizer;

public class DB2EscapeTranslator
extends BaseEscapeTranslator {
    private static String footprint = "$Revision:   3.18.1.1  $";
    public static final String PARAM = "?";
    public static final String COMMA = ",";
    private DB2ImplConnection implConn = null;

    public DB2EscapeTranslator(DB2ImplConnection dB2ImplConnection) {
        this.implConn = dB2ImplConnection;
    }

    public String translateFunctionEscape(BaseFunctionEscape baseFunctionEscape) {
        String string = null;
        switch (baseFunctionEscape.getFunctionType()) {
            case 8: {
                if (this.implConn.comm.serverOS == 8) {
                    string = baseFunctionEscape.getFunctionText();
                    break;
                }
                string = "CHR(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 35: {
                string = "LENGTH(RTRIM(" + baseFunctionEscape.getAllParameters() + "))";
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 26: 
            case 32: 
            case 33: 
            case 36: 
            case 39: 
            case 45: 
            case 52: 
            case 53: 
            case 56: 
            case 60: 
            case 61: 
            case 68: {
                break;
            }
            case 34: {
                if (this.implConn.comm.serverOS != 8) break;
                StringBuffer stringBuffer = new StringBuffer("SUBSTR(");
                stringBuffer.append(baseFunctionEscape.getParameter(1).toString());
                stringBuffer.append(", 1, ");
                stringBuffer.append(baseFunctionEscape.getParameter(2).toString());
                stringBuffer.append(')');
                string = stringBuffer.toString();
                break;
            }
            case 54: {
                if (this.implConn.comm.serverOS != 8) break;
                StringBuffer stringBuffer = new StringBuffer("SUBSTR(");
                stringBuffer.append(baseFunctionEscape.getParameter(1).toString());
                stringBuffer.append(", LENGTH(");
                stringBuffer.append(baseFunctionEscape.getParameter(1).toString());
                stringBuffer.append(")+1-(");
                stringBuffer.append(baseFunctionEscape.getParameter(2).toString());
                stringBuffer.append("),");
                stringBuffer.append(baseFunctionEscape.getParameter(2).toString());
                stringBuffer.append(')');
                string = stringBuffer.toString();
                break;
            }
            case 63: {
                string = "SUBSTR(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 5: {
                StringBuffer stringBuffer = new StringBuffer("ATAN2(");
                stringBuffer.append(baseFunctionEscape.getParameter(2).toString());
                stringBuffer.append(COMMA);
                stringBuffer.append(baseFunctionEscape.getParameter(1).toString());
                stringBuffer.append(")");
                string = stringBuffer.toString();
                break;
            }
            case 0: 
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 13: 
            case 14: 
            case 25: 
            case 27: 
            case 29: 
            case 37: 
            case 38: 
            case 41: 
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 55: 
            case 58: 
            case 59: 
            case 62: 
            case 64: 
            case 67: {
                break;
            }
            case 15: 
            case 16: {
                string = "DATE(CURRENT DATE)";
                break;
            }
            case 17: 
            case 19: {
                string = "TIME(CURRENT TIME)";
                break;
            }
            case 18: 
            case 44: {
                string = "TIMESTAMP(CURRENT TIMESTAMP)";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 28: {
                String string2 = baseFunctionEscape.getParameter(1).toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                string = string3 + "(" + string5 + ")";
                break;
            }
            case 30: 
            case 40: 
            case 42: 
            case 43: 
            case 49: 
            case 57: 
            case 70: 
            case 71: {
                break;
            }
            case 65: {
                String string6;
                String string7 = string6 = baseFunctionEscape.getParameter(1).toString();
                if (string6.equals("SQL_TSI_FRAC_SECOND")) {
                    string7 = ")MICROSECONDS";
                } else if (string6.equals("SQL_TSI_SECOND")) {
                    string7 = ")SECONDS";
                } else if (string6.equals("SQL_TSI_MINUTE")) {
                    string7 = ")MINUTES";
                } else if (string6.equals("SQL_TSI_HOUR")) {
                    string7 = ")HOURS";
                } else if (string6.equals("SQL_TSI_DAY")) {
                    string7 = ")DAYS";
                } else if (string6.equals("SQL_TSI_WEEK")) {
                    string7 = " * 7) DAYS";
                } else if (string6.equals("SQL_TSI_MONTH")) {
                    string7 = ")MONTHS";
                } else if (string6.equals("SQL_TSI_QUARTER")) {
                    string7 = " * 3) MONTHS";
                } else if (string6.equals("SQL_TSI_YEAR")) {
                    string7 = ")YEARS";
                }
                string = "TIMESTAMP(TIMESTAMP_ISO(" + baseFunctionEscape.getParameter(3) + ")) + (" + baseFunctionEscape.getParameter(2) + string7;
                break;
            }
            case 66: {
                String string8;
                String string9 = string8 = baseFunctionEscape.getParameter(1).toString();
                if (string8.equals("SQL_TSI_FRAC_SECOND")) {
                    string9 = "1";
                } else if (string8.equals("SQL_TSI_SECOND")) {
                    string9 = "2";
                } else if (string8.equals("SQL_TSI_MINUTE")) {
                    string9 = "4";
                } else if (string8.equals("SQL_TSI_HOUR")) {
                    string9 = "8";
                } else if (string8.equals("SQL_TSI_DAY")) {
                    string9 = "16";
                } else if (string8.equals("SQL_TSI_WEEK")) {
                    string9 = "32";
                } else if (string8.equals("SQL_TSI_MONTH")) {
                    string9 = "64";
                } else if (string8.equals("SQL_TSI_QUARTER")) {
                    string9 = "128";
                } else if (string8.equals("SQL_TSI_YEAR")) {
                    string9 = "256";
                }
                string = "ABS(TIMESTAMPDIFF( " + string9 + ", " + "CHAR( (TIMESTAMP(TIMESTAMP_ISO(" + baseFunctionEscape.getParameter(2) + "))" + "-TIMESTAMP(TIMESTAMP_ISO(" + baseFunctionEscape.getParameter(3) + "))))))";
                break;
            }
            case 31: {
                string = "COALESCE (" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 20: 
            case 69: {
                break;
            }
            case 47: {
                string = "POSSTR(" + baseFunctionEscape.getAllParameters() + ")";
                break;
            }
        }
        if (string == null) {
            string = baseFunctionEscape.getFunctionText();
        }
        return string;
    }

    public String translateTimestampEscape(BaseTimestampEscape baseTimestampEscape) {
        String string = "'?-?-?'";
        String string2 = "'?.?.?'";
        String string3 = "'?-?-?-?.?.?.?'";
        String[] stringArray = null;
        String[] stringArray2 = new String[8];
        StringBuffer stringBuffer = new StringBuffer();
        stringArray2[0] = PARAM;
        stringArray2[1] = baseTimestampEscape.getYear();
        stringArray2[2] = baseTimestampEscape.getMonth();
        stringArray2[3] = baseTimestampEscape.getDay();
        stringArray2[4] = baseTimestampEscape.getHour();
        stringArray2[5] = baseTimestampEscape.getMinutes();
        stringArray2[6] = baseTimestampEscape.getSeconds();
        stringArray2[7] = baseTimestampEscape.getSecondsFraction();
        switch (baseTimestampEscape.getEscapeType()) {
            case 8194: {
                stringArray = new String[]{stringArray2[0], stringArray2[1], stringArray2[2], stringArray2[3]};
                UtilStringFunctions.replaceStringDelimiters(string, stringArray, stringBuffer, false);
                break;
            }
            case 8193: {
                stringArray = new String[]{stringArray2[0], stringArray2[4], stringArray2[5], stringArray2[6]};
                UtilStringFunctions.replaceStringDelimiters(string2, stringArray, stringBuffer, false);
                break;
            }
            case 8196: {
                if (stringArray2[7] == null) {
                    stringArray2[7] = "0";
                } else if (stringArray2[7].indexOf(".") != -1) {
                    stringArray2[7] = stringArray2[7].substring(1, stringArray2[7].length());
                }
                UtilStringFunctions.replaceStringDelimiters(string3, stringArray2, stringBuffer, false);
            }
        }
        return stringBuffer.toString();
    }

    public String translateCallEscape(BaseCallEscape baseCallEscape) {
        boolean bl;
        int n;
        StringBuffer stringBuffer = baseCallEscape.getProcedureName();
        if (this.implConn.comm.serverOS == 8 && (n = stringBuffer.toString().indexOf(".")) == -1) {
            stringBuffer = new StringBuffer(this.implConn.collectionId + "." + stringBuffer.toString());
        }
        String string = stringBuffer.toString().toUpperCase();
        String string2 = baseCallEscape.getAllParameters();
        boolean bl2 = bl = baseCallEscape.getEscapeType() == 8210;
        if (this.implStatement != null) {
            ((DB2ImplStatement)this.implStatement).procedureName = string;
            ((DB2ImplStatement)this.implStatement).procedureParamList = string2;
            ((DB2ImplStatement)this.implStatement).hasReturnValue = bl;
        }
        if (this.implConn.comm.enableRealStoredProcPrepare) {
            if (bl) {
                String string3 = "CALL " + stringBuffer.append("(" + baseCallEscape.getAllParameters() + ")").toString();
                if (this.implStatement != null) {
                    ((DB2ImplStatement)this.implStatement).storedFunctionSQL = string3;
                }
                return "? = " + string3;
            }
            return "CALL " + stringBuffer.append("(" + baseCallEscape.getAllParameters() + ")").toString();
        }
        if (bl) {
            String string4 = stringBuffer.append("(" + baseCallEscape.getAllParameters() + ")").toString();
            if (this.implStatement != null) {
                ((DB2ImplStatement)this.implStatement).storedFunctionSQL = string4;
            }
            return "? = " + string4;
        }
        return stringBuffer.append("(" + baseCallEscape.getAllParameters() + ")").toString();
    }

    public int getTranslationNeeded(int n) {
        int n2 = 0;
        switch (n) {
            case 8193: 
            case 8194: 
            case 8196: 
            case 8200: 
            case 8209: 
            case 8210: {
                n2 = 2;
                break;
            }
            case 8208: 
            case 8212: {
                n2 = 1;
                break;
            }
            default: {
                UtilDebug.assert("Unknown escape type.", false);
            }
        }
        return n2;
    }
}

