@rem
@rem Copyright  2000-2006 MetaMatrix, Inc.  All rights reserved.
@rem
@rem This utility is used to assist in moving users from MetaMatrix System to another.
@rem This utility will import users from an xml formatted file.  
@rem --------------------------------------------------------------------
@rem 1rd argument - File Name for the file that contains the users and/or groups to load
@rem 2nd argument - User Name to connecto to MetaMatrix
@rem 3nd argument - Password to connecto to MetaMatrix
@rem --------------------------------------------------------------------
@rem

@set UNAME=%2
@set PW=%3
@set FN=%1

@echo off

if not "%1"=="" goto checkfile
:enterfile

echo ---------------------------------------------------------------
echo Enter the File Name (may need full path) that contains
echo the users and/or groups to be loaded
@set /P FN="Enter the File Name [x to Exit]: "
@IF /I %FN% EQU x goto :exit
@IF /I %FN% EQU X goto :exit

:checkfile
if exist "%FN%" goto nextcheck

echo ---------------------------------------------------------------
echo File %FN% does not exists, please enter a different file name
pause
goto enterfile


:nextcheck

if not "%2"=="" goto password

:username
echo ---------------------------------------------------------------
echo Enter the User Name to connect to the MetaMatrix Server
@set /P UNAME="Enter User Name [x to Exit]: "
@IF /I %UNAME% EQU x goto :exit
@IF /I %UNAME% EQU X goto :exit

:password
if not "%3"=="" goto runproc

echo ---------------------------------------------------------------
echo Enter the Password to connect to MetaMatrix Server
@set /P PW="Enter Password [x to Exit]: "
@IF /I %PW% EQU x goto :exit
@IF /I %PW% EQU X goto :exit


:runproc
@echo off
@call ..\bin\mmenv

cd %MM_ROOT%\util

@set ANT_OPTS=-Xmx512m

@set DEFAULTLOGGER=org.apache.tools.ant.DefaultLogger
@rem @set XMLLOGGER=org.apache.tools.ant.XmlLogger
@rem @set MAILLOGGER=org.apache.tools.ant.listener.MailLogger
@set LOGLEVEL=info
@set LOGFILE=-logfile %MM_UTIL%\importusers.log

@set LOGGER=%DEFAULTLOGGER%

@rem VM settings for ant
@rem @set ANT_OPTS=-Dmetamatrix.message.bus.type=noop.message.bus

@rem properties pass to the ant process
@set JAVA_OPTS=-Dmetamatix.message.bus.type=noop.message.bus
@set JAVA_OPTS=%JAVA_OPTS% -Dimport.file=%FN%
@set JAVA_OPTS=%JAVA_OPTS% -Duser.name=%UNAME%
@set JAVA_OPTS=%JAVA_OPTS% -Duser.pw=%PW%

@rem uncomment for additional debugging info in the logfile
@rem @set JAVA_OPTS=%JAVA_OPTS% -verbose


@echo ***********************************************
@echo Performing import of users with file %FN%
@echo ***********************************************
@echo JAVA_OPTS=%JAVA_OPTS%



@%MM_ROOT%\config/ant %JAVA_OPTS%  -propertyfile %MM_ROOT%\config\mmconfig.properties -buildfile %MM_ROOT%\util\config\import_users.xml -logger %LOGGER% %LOGFILE%
if %errorlevel% == -1 @echo Error occurred, see the log file
if %errorlevel% == -1 pause
if %errorlevel% == -1 goto exit


@echo off

goto exit

:nofilename
@echo File Name that specifies where to read the users from must be specified
@echo.
@pause
goto usage


:usage
@echo "usage:   importusers (xml file name)"
@echo.
@echo "example: importusers c:\temp\users.xml"
@echo.
@pause
goto end


goto exit

:exit


