/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.JdbcImporter;
import com.metamatrix.dqp.tools.mmshell.JdbcManager;
import com.metamatrix.dqp.tools.mmshell.MMShell;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.modeler.jdbc.JdbcFactory;
import com.metamatrix.modeler.jdbc.JdbcImportSettings;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.JdbcSourceProperty;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;

class ImportJdbcSourceCommand {
    static final String PATH_KEY = DQPToolsPlugin.UTIL.getString("ImportJdbcSourceCommand.path");
    static final String EXCLUDE_PATH_KEY = DQPToolsPlugin.UTIL.getString("ImportJdbcSourceCommand.excludepath");
    private MMShell shell;
    private Properties properties;

    public static Map getOptions() {
        Map options = JdbcImporter.getImportOptions();
        options.put(PATH_KEY, DQPToolsPlugin.UTIL.getString("ImportJdbcSourceCommand.description." + PATH_KEY));
        options.put(EXCLUDE_PATH_KEY, DQPToolsPlugin.UTIL.getString("ImportJdbcSourceCommand.description." + EXCLUDE_PATH_KEY));
        return options;
    }

    ImportJdbcSourceCommand(Properties properties, MMShell shell) {
        this.properties = properties;
        this.shell = shell;
    }

    protected boolean arePropertiesValid() {
        if (this.properties == null || this.properties.isEmpty()) {
            return true;
        }
        Map options = ImportJdbcSourceCommand.getOptions();
        HashSet<String> validOptions = new HashSet<String>();
        Iterator<Map.Entry<Object, Object>> iter = options.entrySet().iterator();
        while (iter.hasNext()) {
            String option = (String)iter.next().getKey();
            validOptions.add(option.toLowerCase());
        }
        iter = this.properties.entrySet().iterator();
        while (iter.hasNext()) {
            String secondKey;
            int equalIndex;
            Map.Entry<Object, Object> entry = iter.next();
            String key = (String)entry.getKey();
            if (!validOptions.contains(key.toLowerCase())) {
                this.shell.printlnError(DQPToolsPlugin.UTIL.getString("ImportJdbcSourceCommand.invalidOption", (Object)key, (Object)this.getValidOptionList(options.keySet())));
                return false;
            }
            String value = (String)entry.getValue();
            int commaIndex = value.indexOf(44);
            if (commaIndex < 0 || (equalIndex = value.indexOf(61, commaIndex + 1)) < 0 || !validOptions.contains(secondKey = value.substring(commaIndex + 1, equalIndex).toLowerCase())) continue;
            this.shell.printlnError(DQPToolsPlugin.UTIL.getString("ImportJdbcSourceCommand.comma_separated_prop_vals"));
            return false;
        }
        return true;
    }

    private String getValidOptionList(Set options) {
        StringBuffer optionString = new StringBuffer();
        int lineLength = 0;
        Iterator optionIter = options.iterator();
        while (optionIter.hasNext()) {
            String option = (String)optionIter.next();
            if (optionString.length() > 0) {
                optionString.append(",");
                if (lineLength + option.length() > 75) {
                    optionString.append(StringUtil.LINE_SEPARATOR);
                    lineLength = 0;
                } else {
                    optionString.append(" ");
                }
            }
            lineLength += option.length() + 2;
            optionString.append(option);
        }
        return optionString.toString();
    }

    public final boolean execute(String sourceName, Resource resource, VDBContext context) throws Exception {
        if (!this.arePropertiesValid()) {
            return false;
        }
        JdbcSource src = null;
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof JdbcSource)) continue;
            src = (JdbcSource)obj;
            break;
        }
        if (src == null) {
            this.shell.printlnError(DQPToolsPlugin.UTIL.getString("noConnectionInfo", (Object)sourceName));
            return false;
        }
        JdbcManager.create(context.getConfigDirectory(), context.getContainer());
        return this.execute(sourceName, resource, context, src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean execute(String sourceName, Resource resource, VDBContext context, JdbcSource source) throws Exception {
        String path;
        JdbcSourceProperty prop;
        EList props;
        JdbcImporter importer;
        block16: {
            boolean bl;
            importer = new JdbcImporter();
            try {
                Connection conn = importer.connect(source, context.getBindingProperty(sourceName, JdbcManager.PWD));
                Properties connProps = ImportJdbcSourceCommand.buildVariableProperties(conn.getMetaData());
                props = source.getProperties();
                prop = null;
                String oldPath = null;
                path = ImportJdbcSourceCommand.replaceVariables(this.properties.getProperty(PATH_KEY), connProps);
                String excludepath = ImportJdbcSourceCommand.replaceVariables(this.properties.getProperty(EXCLUDE_PATH_KEY), connProps);
                if (excludepath != null) {
                    this.properties.setProperty(EXCLUDE_PATH_KEY, excludepath);
                }
                JdbcImportSettings settings = importer.getImportSettings();
                settings.getExcludedObjectPaths().clear();
                importer.setImportOptions(settings, this.properties);
                Iterator iter = props.iterator();
                while (iter.hasNext()) {
                    prop = (JdbcSourceProperty)iter.next();
                    if (!PATH_KEY.equals(prop.getName())) continue;
                    oldPath = prop.getValue();
                    break;
                }
                if (oldPath == null) {
                    prop = null;
                } else if (path != null) {
                    path = oldPath + ',' + path;
                }
                IStatus status = importer.importModel(path, resource);
                if (status.isOK()) break block16;
                if (status.getCode() == 3) {
                    this.shell.printlnError(DQPToolsPlugin.UTIL.getString("ImportJdbcSourceCommand.noSourceObjectsSelected", (Object)sourceName));
                } else {
                    context.printStatus(status);
                }
                bl = false;
                Object var17_17 = null;
            }
            catch (Throwable throwable) {
                Object var17_19 = null;
                try {
                    importer.close();
                }
                catch (SQLException err) {
                    this.shell.printlnException(err);
                }
                throw throwable;
            }
            try {
                importer.close();
            }
            catch (SQLException err) {
                this.shell.printlnException(err);
            }
            return bl;
        }
        if (path != null) {
            if (prop == null) {
                prop = JdbcFactory.eINSTANCE.createJdbcSourceProperty();
                prop.setName(PATH_KEY);
            }
            prop.setValue(path);
            props.add(prop);
        }
        boolean bl = true;
        Object var17_18 = null;
        try {
            importer.close();
        }
        catch (SQLException err) {
            this.shell.printlnException(err);
        }
        return bl;
    }

    static String extractUserName(DatabaseMetaData md) throws Exception {
        return md.getUserName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String extractCatalogName(DatabaseMetaData md) throws Exception {
        String url = md.getURL().toLowerCase();
        ResultSet rs = md.getCatalogs();
        try {
            while (rs.next()) {
                String catalog = rs.getString(1);
                if (url.indexOf(catalog.toLowerCase()) == -1) continue;
                String string = catalog;
                return string;
            }
        }
        finally {
            rs.close();
        }
        return null;
    }

    static Properties buildVariableProperties(DatabaseMetaData md) throws Exception {
        String currentCatalog = ImportJdbcSourceCommand.extractCatalogName(md);
        String userName = ImportJdbcSourceCommand.extractUserName(md);
        Properties prop = new Properties();
        if (currentCatalog != null) {
            prop.put("${catalog}", currentCatalog);
        }
        if (userName != null) {
            prop.put("${user}", userName);
        }
        return prop;
    }

    private static String replaceVariables(String str, Properties props) {
        if (str != null) {
            if (str.indexOf("${") != -1) {
                Iterator<Object> i = props.keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    str = StringUtil.replaceAll((String)str, (String)key, (String)props.getProperty(key));
                }
                if (str.indexOf("${") != -1) {
                    return null;
                }
            }
            return StringUtil.replaceAll((String)str, (String)"*", (String)".*");
        }
        return str;
    }
}

