/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.util.crypto.PasswordCryptoFactory;
import com.metamatrix.common.util.crypto.keymanage.KeystoreCreator;
import com.metamatrix.core.classloader.URLClassLoaderRegistry;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.util.ClassUtil;
import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.AddCommand;
import com.metamatrix.dqp.tools.mmshell.ArgReader;
import com.metamatrix.dqp.tools.mmshell.AsynchExecutor;
import com.metamatrix.dqp.tools.mmshell.BrowseCommand;
import com.metamatrix.dqp.tools.mmshell.ConfigurationBuilder;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminContext;
import com.metamatrix.dqp.tools.mmshell.ExtendedDeleteCommand;
import com.metamatrix.dqp.tools.mmshell.ExtendedInsertCommand;
import com.metamatrix.dqp.tools.mmshell.ExtendedSelectCommand;
import com.metamatrix.dqp.tools.mmshell.ExtendedUpdateCommand;
import com.metamatrix.dqp.tools.mmshell.GetCommand;
import com.metamatrix.dqp.tools.mmshell.ImportCommand;
import com.metamatrix.dqp.tools.mmshell.ListCommand;
import com.metamatrix.dqp.tools.mmshell.OpenCommand;
import com.metamatrix.dqp.tools.mmshell.PackageCommand;
import com.metamatrix.dqp.tools.mmshell.RefreshCommand;
import com.metamatrix.dqp.tools.mmshell.RemoveCommand;
import com.metamatrix.dqp.tools.mmshell.RenameCommand;
import com.metamatrix.dqp.tools.mmshell.SetCommand;
import com.metamatrix.dqp.tools.mmshell.StatsCommand;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.modeler.internal.core.ModelEditorImpl;
import com.metamatrix.modeler.internal.core.container.ContainerImpl;
import com.metamatrix.tools.toolshell.CommandImpl;
import com.metamatrix.tools.toolshell.CommentCommand;
import com.metamatrix.tools.toolshell.ExitCommand;
import com.metamatrix.tools.toolshell.HelpCommand;
import com.metamatrix.tools.toolshell.ScriptFileCommand;
import com.metamatrix.tools.toolshell.ToolShell;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionContext;
import com.metamatrix.tools.toolshell.log.Logger;
import com.metamatrix.tools.toolshell.log.ShellLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;

public class MMShell
extends ToolShell {
    public static final String MM_PROPERTIES = "mm.properties";
    public static final String MMSHELL_DIR = "mmshell.dir";
    private static final String LIB_FOLDER = "lib";
    public static final String LIB_PROP = "mmshell.lib";
    private static final String LOG_FILE_NAME = "mmshell.log";
    private static final String COMMAND_FILE_NAME = "mmcommand.log";
    private static final String KNOWN_VDBS_FILE = "knownVdbs.txt";
    public static final String PLUGINS_PROP = "mmshell.plugins";
    private static final String DEFAULT_PROMPT = "NO-VDB";
    private VDBContext context;
    private ArrayList knownVdbs;
    static /* synthetic */ Class class$com$metamatrix$dqp$tools$mmshell$EmbeddedAdminContext;
    static /* synthetic */ Class class$com$metamatrix$dqp$tools$mmshell$VDBContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String scriptFileName = null;
        String[] command = null;
        String vdbName = null;
        int verbosity = 0;
        boolean interactive = false;
        try {
            ArgReader reader = new ArgReader(args);
            if (reader.requestedHelp()) {
                MMShell.printUsage();
                System.exit(0);
            }
            scriptFileName = reader.getScriptFile();
            command = reader.getCommand();
            vdbName = reader.getVdb();
            verbosity = reader.getLogLevel();
            interactive = reader.getMode() == 0;
        }
        catch (Exception e) {
            MMShell.printUsage();
            MMShell.waitForExit();
        }
        MMShell shell = null;
        try {
            shell = new MMShell(vdbName, null, null, interactive, verbosity);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            MMShell.waitForExit();
        }
        try {
            if (scriptFileName != null) {
                shell.runCommandFile(scriptFileName);
            } else if (command != null) {
                shell.runSingleCommand(command);
            } else {
                shell.acceptCommands(new InputStreamReader(System.in), false);
            }
        }
        catch (Exception err) {
            shell.printlnException(err);
        }
        finally {
            try {
                shell.close();
            }
            catch (Exception err) {
                shell.printlnException(err);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initializeCrypto(String dqpProperties) throws CryptoException {
        block22: {
            File propFile = new File(dqpProperties);
            if (!propFile.exists()) {
                Object[] prams = new Object[]{dqpProperties};
                String msg = DQPToolsPlugin.UTIL.getString("MMShell.error_opening_props_file", prams);
                throw new RuntimeException(msg);
            }
            String keyStorePath = propFile.getParent() + File.separator + LIB_FOLDER + File.separator + "metamatrixpki.keystore";
            File keystoreFile = new File(keyStorePath);
            if (!keystoreFile.exists()) {
                Random gen = new Random(new Date().getTime());
                String dqpKey = new Long(gen.nextLong()).toString();
                CryptoUtil.initJCEProvider();
                KeystoreCreator.createKeyStore((String)keystoreFile.getAbsolutePath(), (char[])dqpKey.toCharArray(), (String)"encrypt", (int)45);
                char[] pwd = CryptoFactory.argle((char[])dqpKey.toCharArray());
                String pwdComment = DQPToolsPlugin.UTIL.getString("MMShell.keystore_password_property_constant");
                StringBuffer pwdBuf = new StringBuffer();
                String lineSeparator = System.getProperty("line.separator");
                pwdBuf.append("metamatrix.security.password.PasswordKeyStore");
                pwdBuf.append('=');
                pwdBuf.append(pwd);
                StringBuffer lineBuf = new StringBuffer();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(propFile));
                    String aLine = null;
                    int whtSpc = 0;
                    while ((aLine = reader.readLine()) != null) {
                        if (aLine.equals(pwdComment) || aLine.startsWith("metamatrix.security.password.PasswordKeyStore")) continue;
                        whtSpc = aLine.trim().length() != 0 ? 0 : ++whtSpc;
                        if (whtSpc > 1) continue;
                        lineBuf.append(aLine);
                        lineBuf.append(lineSeparator);
                    }
                    lineBuf.append(pwdComment);
                    lineBuf.append(lineSeparator);
                    lineBuf.append(pwdBuf.toString());
                    lineBuf.append(lineSeparator);
                    lineBuf.append(lineSeparator);
                }
                catch (FileNotFoundException err) {
                    Object[] prams = new Object[]{dqpProperties, err.getMessage()};
                    String msg = DQPToolsPlugin.UTIL.getString("MMShell.error_opening_props_file", prams);
                    throw new RuntimeException(msg);
                }
                catch (IOException err) {
                    Object[] prams = new Object[]{dqpProperties, err.getMessage()};
                    String msg = DQPToolsPlugin.UTIL.getString("MMShell.error_reading_props_file", prams);
                    throw new RuntimeException(msg);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException err) {}
                }
                FileOutputStream stream = null;
                try {
                    try {
                        stream = new FileOutputStream(propFile);
                        ((OutputStream)stream).write(lineBuf.toString().getBytes());
                    }
                    catch (FileNotFoundException err) {
                        Object[] prams = new Object[]{dqpProperties, err.getMessage()};
                        String msg = DQPToolsPlugin.UTIL.getString("MMShell.error_opening_props_file", prams);
                        throw new RuntimeException(msg);
                    }
                    catch (IOException err) {
                        Object[] prams = new Object[]{dqpProperties, err.getMessage()};
                        String msg = DQPToolsPlugin.UTIL.getString("MMShell.error_writing_props_file", prams);
                        throw new RuntimeException(msg);
                    }
                    Object var18_31 = null;
                    if (stream == null) break block22;
                }
                catch (Throwable throwable) {
                    Object var18_32 = null;
                    if (stream == null) throw throwable;
                    try {
                        ((OutputStream)stream).close();
                        throw throwable;
                    }
                    catch (IOException err) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException err) {}
                ((OutputStream)stream).close();
            }
        }
        Properties props = MMShell.loadProperties(dqpProperties);
        PasswordCryptoFactory.init((char[])props.getProperty("metamatrix.security.password.PasswordKeyStore").toCharArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadProperties(String dqpProperties) {
        Properties props = new Properties();
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(dqpProperties);
                props.load(stream);
            }
            catch (IOException err) {
                Object[] prams = new Object[]{dqpProperties, err.getMessage()};
                String msg = DQPToolsPlugin.UTIL.getString("MMShell.error_opening_props_file", prams);
                throw new RuntimeException(msg);
            }
            Object var7_3 = null;
            if (stream == null) return props;
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            if (stream == null) throw throwable;
            try {
                ((InputStream)stream).close();
                throw throwable;
            }
            catch (IOException err) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException err) {}
        ((InputStream)stream).close();
        return props;
    }

    private static void printUsage() {
        System.out.println(DQPToolsPlugin.UTIL.getString("MMShell.usage"));
    }

    private static void waitForExit() {
        System.out.println(DQPToolsPlugin.UTIL.getString("MMShell.wait_for_exit"));
        try {
            System.in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(1);
    }

    public MMShell(String vdbName, PrintStream logOutput, PrintStream commandRecord, boolean interactive, int shellVerbosity) throws Exception {
        PrintStream logStream;
        System.setProperty("metamatrix.config.none", "true");
        String mmshellDir = System.getProperty(MMSHELL_DIR);
        if (mmshellDir == null) {
            throw new RuntimeException(DQPToolsPlugin.UTIL.getString("MMShell.error_missing_mmshell_dir"));
        }
        PrintStream commandStream = commandRecord;
        if (commandStream == null) {
            commandStream = new PrintStream(new FileOutputStream(mmshellDir + File.separator + COMMAND_FILE_NAME));
        }
        if ((logStream = logOutput) == null) {
            logStream = new PrintStream(new FileOutputStream(mmshellDir + File.separator + LOG_FILE_NAME));
        }
        Logger shellLogger = new Logger();
        shellLogger.addDestination(ShellLogger.DEST.LOG, logStream);
        shellLogger.addDestination(ShellLogger.DEST.COMMAND, commandStream);
        shellLogger.addDestination(ShellLogger.DEST.STDOUT, System.out);
        shellLogger.addDestination(ShellLogger.DEST.STDERR, System.err);
        this.setLogger(shellLogger);
        this.setInteractive(interactive);
        this.setVerbosity(shellVerbosity);
        this.setShellDirectory(new File(mmshellDir));
        File workspacePath = null;
        String dqpProperties = System.getProperty(MM_PROPERTIES);
        if (dqpProperties == null) {
            throw new RuntimeException(DQPToolsPlugin.UTIL.getString("MMShell.error_missing_props_file"));
        }
        MMShell.initializeCrypto(dqpProperties);
        this.context = this.getVDBContext();
        this.context.setToolShell(this);
        if (workspacePath != null) {
            this.context.setWorkspaceDirectory(workspacePath);
        }
        final EmbeddedAdminContext dqpContext = this.getDQPAdminContext();
        dqpContext.setToolShell(this);
        dqpContext.setDqpProperties(dqpProperties);
        this.setQueryUrl(dqpContext, "Admin");
        dqpContext.setUseLazyConnections(true);
        dqpContext.setDriver("com.metamatrix.jdbc.EmbeddedDriver");
        BasicEObjectImpl.setObjectIDFactory(IDGenerator.getInstance().getFactory("mmuuid"));
        String pluginsFolder = System.getProperty(PLUGINS_PROP);
        if (pluginsFolder == null) {
            pluginsFolder = this.context.getConfigDirectory().getAbsolutePath();
        }
        ConfigurationBuilder.build(pluginsFolder, shellVerbosity == 3);
        XSDSchemaImpl.getMagicSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
        XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
        XSDSchemaImpl.getSchemaInstance((String)"http://www.w3.org/2001/XMLSchema-instance");
        String libFolder = System.getProperty(LIB_PROP);
        if (libFolder == null) {
            libFolder = new File(this.getShellDirectory(), LIB_FOLDER).getAbsolutePath();
        }
        URLClassLoaderRegistry.setBaseFolder((String)libFolder);
        ModelEditorImpl.setContainer((ContainerImpl)((ContainerImpl)this.context.getContainer()));
        DatabaseConnectionContext dcContext = this.getDatabaseConnectionContext();
        dcContext.setToolShell(this);
        dcContext.setUseLazyConnections(true);
        dcContext.setDriver("com.metamatrix.jdbc.EmbeddedDriver");
        dcContext.setDqpProperties(dqpProperties);
        this.initializeCommands();
        if (vdbName == null) {
            this.printHelp(DQPToolsPlugin.UTIL.getString("MMShell.noVdb"));
            String knownVdbs = this.getKnownVdbsText();
            if (knownVdbs.length() > 0) {
                this.printlnVerbose("");
                this.printlnVerbose(knownVdbs);
            }
            AsynchExecutor.execute(new Runnable(){

                public void run() {
                    try {
                        dqpContext.getAdmin();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        } else {
            OpenCommand open = OpenCommand.get();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(open.getCommandName());
            cmd.add(vdbName);
            open.executeCommand(cmd.iterator());
        }
    }

    public void addKnownVdb(File vdb) throws IOException {
        this.createKnownVdbsList();
        String path = vdb.getCanonicalPath();
        if (this.knownVdbs.contains(path)) {
            return;
        }
        this.knownVdbs.add(path);
        this.saveKnownVdbs();
    }

    public void close() throws Exception {
        this.context.close();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createKnownVdbsList() {
        if (this.knownVdbs != null) return;
        this.knownVdbs = new ArrayList();
        File file = new File(this.getVDBContext().getConfigDirectory(), KNOWN_VDBS_FILE);
        if (!file.exists()) return;
        BufferedReader rdr = null;
        rdr = new BufferedReader(new FileReader(file));
        String line = rdr.readLine();
        while (line != null) {
            String name = line.trim();
            if (new File(name).exists()) {
                this.knownVdbs.add(name);
            }
            line = rdr.readLine();
        }
        Object var6_6 = null;
        if (rdr == null) return;
        try {
            rdr.close();
            return;
        }
        catch (IOException err2) {
            this.printlnException(err2);
        }
        return;
        {
            catch (IOException err) {
                this.printlnException(err);
                Object var6_7 = null;
                if (rdr == null) return;
                try {
                    rdr.close();
                    return;
                }
                catch (IOException err2) {
                    this.printlnException(err2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (rdr == null) throw throwable;
            try {
                rdr.close();
                throw throwable;
            }
            catch (IOException err2) {
                this.printlnException(err2);
            }
            throw throwable;
        }
    }

    protected void initializeCommandList() {
        this.commands = new HashMap();
        this.putCommand(new CommentCommand());
        this.putCommand(new HelpCommand());
        this.putCommand(new ScriptFileCommand());
        ExitCommand exitCommand = new ExitCommand();
        this.putCommand(exitCommand);
        this.commands.put(ExitCommand.QUIT_COMMAND_STRING, exitCommand);
        this.commands.put(ExitCommand.BYE_COMMAND_STRING, exitCommand);
        this.putCommand(new ExtendedSelectCommand());
        this.putCommand(new ExtendedInsertCommand());
        this.putCommand(new ExtendedUpdateCommand());
        this.putCommand(new ExtendedDeleteCommand());
        this.putCommand(OpenCommand.get());
        this.putCommand(AddCommand.get());
        this.putCommand(new BrowseCommand());
        this.putCommand(ImportCommand.get());
        this.putCommand(RefreshCommand.get());
        this.putCommand(StatsCommand.get());
        this.putCommand(ListCommand.get());
        this.putCommand(new RemoveCommand());
        this.putCommand(new GetCommand());
        this.putCommand(new SetCommand());
        this.putCommand(new RenameCommand());
        this.putCommand(new PackageCommand());
    }

    public EmbeddedAdminContext getDQPAdminContext() {
        EmbeddedAdminContext context = (EmbeddedAdminContext)this.getContext((class$com$metamatrix$dqp$tools$mmshell$EmbeddedAdminContext == null ? (class$com$metamatrix$dqp$tools$mmshell$EmbeddedAdminContext = MMShell.class$("com.metamatrix.dqp.tools.mmshell.EmbeddedAdminContext")) : class$com$metamatrix$dqp$tools$mmshell$EmbeddedAdminContext).getName());
        return context;
    }

    public String getKnownVdbsText() {
        this.createKnownVdbsList();
        StringBuffer text = new StringBuffer();
        if (!this.knownVdbs.isEmpty()) {
            text.append(DQPToolsPlugin.UTIL.getString("VDBContext.known_vdbs"));
            Iterator iter = this.knownVdbs.iterator();
            while (iter.hasNext()) {
                text.append("  ");
                String name = (String)iter.next();
                text.append(name);
                if (this.context.getVDBFile() != null && this.context.getVDBFile().equals(new File(name))) {
                    text.append(" - ");
                    text.append(DQPToolsPlugin.UTIL.getString("VDBContext.vdb_open"));
                }
                if (!iter.hasNext()) continue;
                text.append('\n');
            }
        }
        return CommandImpl.format(text.toString());
    }

    protected String getPrompt() {
        VDBContext vdbContext = this.getVDBContext();
        String prompt = vdbContext.getVDBName();
        if (prompt == null || prompt.length() == 0) {
            return DEFAULT_PROMPT;
        }
        return prompt;
    }

    public VDBContext getVDBContext() {
        VDBContext context = (VDBContext)this.getContext((class$com$metamatrix$dqp$tools$mmshell$VDBContext == null ? (class$com$metamatrix$dqp$tools$mmshell$VDBContext = MMShell.class$("com.metamatrix.dqp.tools.mmshell.VDBContext")) : class$com$metamatrix$dqp$tools$mmshell$VDBContext).getName());
        return context;
    }

    public void removeKnownVdb(File vdb) throws IOException {
        String path = vdb.getCanonicalPath();
        this.knownVdbs.remove(path);
        this.saveKnownVdbs();
    }

    public void runCommandFile(String fileName) throws IOException {
        super.runCommandFile(fileName);
    }

    public void runSingleCommand(String command) throws IOException {
        StringTokenizer iter = new StringTokenizer(command);
        String[] tokens = new String[iter.countTokens()];
        int ndx = 0;
        while (iter.hasMoreTokens()) {
            tokens[ndx] = iter.nextToken();
            ++ndx;
        }
        this.runSingleCommand(tokens);
    }

    public void runSingleCommand(String[] commandArray) throws IOException {
        super.runSingleCommand(commandArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveKnownVdbs() throws IOException {
        File configFolder = this.getVDBContext().getConfigDirectory();
        File file = new File(configFolder, KNOWN_VDBS_FILE);
        File tmpFile = File.createTempFile(ClassUtil.getSimpleClassName((Object)this), null, configFolder);
        PrintWriter wtr = null;
        try {
            wtr = new PrintWriter(new FileWriter(tmpFile));
            Iterator iter = this.knownVdbs.iterator();
            while (iter.hasNext()) {
                wtr.println(iter.next());
            }
            wtr.close();
            wtr = null;
            if (file.exists() && !file.delete()) {
                this.printlnError(DQPToolsPlugin.UTIL.getString("MMShell.saveError"));
            }
            if (!tmpFile.renameTo(file)) {
                this.printlnError(DQPToolsPlugin.UTIL.getString("MMShell.saveError"));
                this.printlnError(DQPToolsPlugin.UTIL.getString("MMShell.renameError", (Object)tmpFile));
            }
        }
        catch (IOException err) {
            this.printlnException(err);
        }
        finally {
            if (wtr != null) {
                wtr.close();
            }
        }
    }

    public void setQueryURL(String vdb) {
        this.setQueryUrl(this.getDatabaseConnectionContext(), vdb);
    }

    private void setQueryUrl(DatabaseConnectionContext context, String vdb) {
        context.setURL("jdbc:metamatrix:" + vdb + "@mmrofile:" + context.getDqpProperties() + ";dqp.classpath=");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        System.setProperty("shutdownHookInstalled", String.valueOf(Boolean.TRUE));
    }
}

