/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.common.util.VDBNameValidator;
import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminCommandImpl;
import com.metamatrix.dqp.tools.mmshell.JdbcManager;
import com.metamatrix.dqp.tools.mmshell.MMShell;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.vdb.edit.VdbEditingContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;

public class RemoveCommand
extends EmbeddedAdminCommandImpl {
    private static final String ALL_KEYWORD = "*";
    private static final String OPEN = "open";
    private static final String VDB = "vdb";

    public String getCommandName() {
        return DQPToolsPlugin.UTIL.getString("RemoveCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return DQPToolsPlugin.UTIL.getString("RemoveCommand.longHelp");
    }

    public String getShortHelp() {
        return DQPToolsPlugin.UTIL.getString("RemoveCommand.shortHelp");
    }

    public String getArgHelp() {
        return DQPToolsPlugin.UTIL.getString("RemoveCommand.argHelp");
    }

    private void deleteSource(String srcName) throws Exception {
        EmfResource resrc;
        if (srcName == null) {
            return;
        }
        if (VDBNameValidator.isSourceNameReserved((String)srcName)) {
            this.printlnVerbose(DQPToolsPlugin.UTIL.getString("RemoveCommand.errro_unable_to_remove_reserved_source", (Object)srcName));
            return;
        }
        VDBContext context = this.getVDBContext();
        if (context.deleteResource(srcName, resrc = (EmfResource)context.findResource(srcName))) {
            context.activate();
            this.printlnVerbose(DQPToolsPlugin.UTIL.getString("RemoveCommand.deletedSource", (Object)srcName));
        }
    }

    private void deleteAllSources() throws Exception {
        VDBContext context = this.getVDBContext();
        VdbEditingContext editingContext = context.getEditingContext();
        if (editingContext != null) {
            Container container = editingContext.getVdbContainer();
            ArrayList resources = new ArrayList(container.getResources());
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                Resource resource = (Resource)iter.next();
                if (JdbcManager.getJdbcSource(resource, this.toolShell) == null) continue;
                String sourceName = resource.getURI().trimFileExtension().lastSegment();
                EmfResource resrc = (EmfResource)context.findResource(sourceName);
                context.deleteResource(sourceName, resrc);
                this.printlnVerbose(DQPToolsPlugin.UTIL.getString("RemoveCommand.deletedSource", (Object)sourceName));
            }
            context.activate();
        } else {
            this.printlnError(DQPToolsPlugin.UTIL.getString("MMShell.VDBNotOpen"));
        }
    }

    private void deleteVdb() throws Exception {
        VDBContext context = this.getVDBContext();
        String vdbName = context.getVDBName();
        File vdb = context.getVDBFile();
        if (!context.deleteVDB()) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("RemoveCommand.error_unable_to_delete_file", (Object)vdbName));
            return;
        }
        ((MMShell)this.toolShell).removeKnownVdb(vdb);
        this.printlnVerbose(DQPToolsPlugin.UTIL.getString("RemoveCommand.deletedVdb", (Object)vdbName));
    }

    public boolean executeCommand(Iterator iterator) throws Exception {
        if (!this.verifyOpen()) {
            return true;
        }
        iterator.next();
        if (iterator.hasNext()) {
            String source = this.getSourceName(iterator);
            String vdb = null;
            if (iterator.hasNext()) {
                vdb = (String)iterator.next();
            }
            if (source.equalsIgnoreCase(OPEN) && vdb != null && vdb.equalsIgnoreCase(VDB)) {
                this.deleteVdb();
            } else if (source.equalsIgnoreCase(ALL_KEYWORD)) {
                this.deleteAllSources();
            } else {
                int dotIndex = source.indexOf(46);
                if (dotIndex == -1) {
                    this.deleteSource(source);
                } else {
                    this.printlnVerbose(this.getLongHelp(null));
                }
            }
        } else {
            this.printlnVerbose(this.getLongHelp(null));
        }
        return true;
    }
}

