/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.tools.mmshell;

import com.metamatrix.dqp.tools.DQPToolsPlugin;
import com.metamatrix.dqp.tools.mmshell.EmbeddedAdminCommandImpl;
import com.metamatrix.dqp.tools.mmshell.MMShell;
import com.metamatrix.dqp.tools.mmshell.VDBContext;
import java.io.File;
import java.util.Iterator;
import java.util.List;

public class RenameCommand
extends EmbeddedAdminCommandImpl {
    private static final String ERROR_MISSING_NEW_VDB_NAME = DQPToolsPlugin.UTIL.getString("RenameCommand.error_missing_new_vdb_name");

    public boolean executeCommand(Iterator argIter) throws Exception {
        if (!this.verifyOpen()) {
            return true;
        }
        argIter.next();
        if (!argIter.hasNext()) {
            this.printlnError(ERROR_MISSING_NEW_VDB_NAME);
            return true;
        }
        String newVDBName = (String)argIter.next();
        boolean isValidName = true;
        if (argIter.hasNext()) {
            isValidName = false;
            while (argIter.hasNext()) {
                newVDBName = newVDBName + " " + argIter.next();
            }
        } else {
            File tmpFile = new File(newVDBName);
            if (tmpFile.getParentFile() != null) {
                this.printlnError(DQPToolsPlugin.UTIL.getString("RenameCommand.pathError"));
                return true;
            }
            newVDBName = VDBContext.cleanupVDBName(newVDBName);
            isValidName = VDBContext.isVDBNameValid(newVDBName);
        }
        if (!isValidName) {
            this.printlnError(DQPToolsPlugin.UTIL.getString("MMShell.invalid_vdb", (Object)newVDBName));
            return true;
        }
        VDBContext context = this.getVDBContext();
        File oldVDB = this.getVDBContext().getVDBFile();
        if (context.rename(newVDBName)) {
            ((MMShell)context.getToolShell()).removeKnownVdb(oldVDB);
            ((MMShell)context.getToolShell()).setQueryURL(context.getVDBName());
            ((MMShell)context.getToolShell()).addKnownVdb(this.getVDBContext().getVDBFile());
            this.printlnVerbose(DQPToolsPlugin.UTIL.getString("RenameCommand.renamed_vdb", (Object)newVDBName));
        }
        return true;
    }

    public String getCommandName() {
        return DQPToolsPlugin.UTIL.getString("RenameCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return DQPToolsPlugin.UTIL.getString("RenameCommand.longHelp");
    }

    public String getShortHelp() {
        return DQPToolsPlugin.UTIL.getString("RenameCommand.shortHelp");
    }

    public String getArgHelp() {
        return DQPToolsPlugin.UTIL.getString("RenameCommand.argHelp");
    }
}

